/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.projectView.impl.ProjectViewFileNestingService;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.DumbAwareActionButton;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.table.TableView;
import com.intellij.util.Consumer;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ElementProducer;
import com.intellij.util.ui.ListTableModel;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileNestingInProjectViewDialog
extends DialogWrapper {
    private final JBCheckBox myUseNestingRulesCheckBox;
    private final JPanel myRulesPanel;
    private final TableView<ProjectViewFileNestingService.NestingRule> myTable;
    private final Action myOkAction;

    public FileNestingInProjectViewDialog(@NotNull Project project2) {
        if (project2 == null) {
            FileNestingInProjectViewDialog.$$$reportNull$$$0(0);
        }
        super(project2);
        this.myOkAction = new DialogWrapper.OkAction(){

            public void actionPerformed(ActionEvent e) {
                FileNestingInProjectViewDialog.this.myTable.stopEditing();
                super.actionPerformed(e);
            }
        };
        this.setTitle(IdeBundle.message((String)"file.nesting.dialog.title", (Object[])new Object[0]));
        this.myUseNestingRulesCheckBox = new JBCheckBox(IdeBundle.message((String)"use.file.nesting.rules.checkbox", (Object[])new Object[0]));
        this.myUseNestingRulesCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UIUtil.setEnabled((Component)FileNestingInProjectViewDialog.this.myRulesPanel, (boolean)FileNestingInProjectViewDialog.this.myUseNestingRulesCheckBox.isSelected(), (boolean)true);
            }
        });
        this.myTable = FileNestingInProjectViewDialog.createTable();
        this.myRulesPanel = FileNestingInProjectViewDialog.createRulesPanel(this.myTable);
        this.init();
    }

    protected String getHelpId() {
        return "project.view.file.nesting.dialog";
    }

    protected JComponent createCenterPanel() {
        JPanel mainPanel = new JPanel(new BorderLayout());
        mainPanel.add((Component)this.myUseNestingRulesCheckBox, "North");
        mainPanel.add((Component)this.myRulesPanel, "Center");
        return mainPanel;
    }

    private static JPanel createRulesPanel(final @NotNull TableView<ProjectViewFileNestingService.NestingRule> table) {
        if (table == null) {
            FileNestingInProjectViewDialog.$$$reportNull$$$0(1);
        }
        ToolbarDecorator toolbarDecorator = ToolbarDecorator.createDecorator(table, (ElementProducer)new ElementProducer<ProjectViewFileNestingService.NestingRule>(){

            public boolean canCreateElement() {
                return true;
            }

            public ProjectViewFileNestingService.NestingRule createElement() {
                return new ProjectViewFileNestingService.NestingRule();
            }
        }).disableUpDownActions().addExtraAction((AnActionButton)new DumbAwareActionButton(IdeBundle.message((String)"file.nesting.use.default.ruleset", (Object[])new Object[0]), AllIcons.Actions.Reset_to_default){

            public void actionPerformed(AnActionEvent e) {
                ArrayList<ProjectViewFileNestingService.NestingRule> rules = new ArrayList<ProjectViewFileNestingService.NestingRule>();
                for (ProjectViewFileNestingService.NestingRule rule : ProjectViewFileNestingService.DEFAULT_NESTING_RULES) {
                    rules.add(new ProjectViewFileNestingService.NestingRule(rule.getParentFileSuffix(), rule.getChildFileSuffix()));
                }
                table.getListTableModel().setItems(rules);
            }
        });
        return toolbarDecorator.createPanel();
    }

    private static TableView<ProjectViewFileNestingService.NestingRule> createTable() {
        ListTableModel model = new ListTableModel(new ColumnInfo[]{new ColumnInfo<ProjectViewFileNestingService.NestingRule, String>("Parent file suffix"){

            public boolean isCellEditable(ProjectViewFileNestingService.NestingRule rule) {
                return true;
            }

            public String valueOf(ProjectViewFileNestingService.NestingRule rule) {
                return rule.getParentFileSuffix();
            }

            public void setValue(ProjectViewFileNestingService.NestingRule rule, String value2) {
                rule.setParentFileSuffix(value2.trim());
            }
        }, new ColumnInfo<ProjectViewFileNestingService.NestingRule, String>("Child file suffix"){

            public boolean isCellEditable(ProjectViewFileNestingService.NestingRule rule) {
                return true;
            }

            public String valueOf(ProjectViewFileNestingService.NestingRule rule) {
                return rule.getChildFileSuffix();
            }

            public void setValue(ProjectViewFileNestingService.NestingRule rule, String value2) {
                rule.setChildFileSuffix(value2);
            }
        }});
        TableView table = new TableView(model);
        table.setRowHeight(new JTextField().getPreferredSize().height + table.getRowMargin());
        return table;
    }

    @NotNull
    protected Action getOKAction() {
        Action action = this.myOkAction;
        if (action == null) {
            FileNestingInProjectViewDialog.$$$reportNull$$$0(2);
        }
        return action;
    }

    @Nullable
    protected ValidationInfo doValidate() {
        if (!this.myUseNestingRulesCheckBox.isSelected()) {
            return null;
        }
        List items = this.myTable.getListTableModel().getItems();
        for (int i = 0; i < items.size(); ++i) {
            ProjectViewFileNestingService.NestingRule rule = (ProjectViewFileNestingService.NestingRule)items.get(i);
            int row = i + 1;
            if (rule.getParentFileSuffix().isEmpty()) {
                return new ValidationInfo("Parent file suffix must not be empty (see row " + row + ")", null);
            }
            if (rule.getChildFileSuffix().isEmpty()) {
                return new ValidationInfo("Child file suffix must not be empty (see row " + row + ")", null);
            }
            if (!rule.getChildFileSuffix().equals(rule.getParentFileSuffix())) continue;
            return new ValidationInfo("Parent and child file suffixes must not be equal ('" + rule.getParentFileSuffix() + "', see row " + row + ")", null);
        }
        return null;
    }

    public void reset(boolean useFileNestingRules) {
        this.myUseNestingRulesCheckBox.setSelected(useFileNestingRules);
        UIUtil.setEnabled((Component)this.myRulesPanel, (boolean)this.myUseNestingRulesCheckBox.isSelected(), (boolean)true);
        ArrayList<ProjectViewFileNestingService.NestingRule> rules = new ArrayList<ProjectViewFileNestingService.NestingRule>();
        for (ProjectViewFileNestingService.NestingRule rule : ProjectViewFileNestingService.getInstance().getRules()) {
            rules.add(new ProjectViewFileNestingService.NestingRule(rule.getParentFileSuffix(), rule.getChildFileSuffix()));
        }
        this.myTable.getListTableModel().setItems(rules);
    }

    public void apply(@NotNull Consumer<Boolean> useNestingRulesOptionConsumer) {
        if (useNestingRulesOptionConsumer == null) {
            FileNestingInProjectViewDialog.$$$reportNull$$$0(3);
        }
        useNestingRulesOptionConsumer.consume((Object)this.myUseNestingRulesCheckBox.isSelected());
        if (this.myUseNestingRulesCheckBox.isSelected()) {
            ArrayList<ProjectViewFileNestingService.NestingRule> result2 = new ArrayList<ProjectViewFileNestingService.NestingRule>();
            for (ProjectViewFileNestingService.NestingRule rule : this.myTable.getListTableModel().getItems()) {
                result2.add(new ProjectViewFileNestingService.NestingRule(rule.getParentFileSuffix(), rule.getChildFileSuffix()));
            }
            ProjectViewFileNestingService.getInstance().setRules(result2);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/projectView/impl/FileNestingInProjectViewDialog";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "useNestingRulesOptionConsumer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/projectView/impl/FileNestingInProjectViewDialog";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getOKAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createRulesPanel";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "apply";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

