/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl.nodes;

import com.intellij.ide.util.treeView.TreeAnchorizer;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiTreeAnchorizer
extends TreeAnchorizer {
    public Object createAnchor(Object element) {
        if (element instanceof PsiElement) {
            PsiElement psi = (PsiElement)element;
            return ReadAction.compute(() -> {
                if (!psi.isValid()) {
                    return psi;
                }
                return new SmartPointerWrapper(SmartPointerManager.getInstance((Project)psi.getProject()).createSmartPsiElementPointer(psi));
            });
        }
        return super.createAnchor(element);
    }

    @Nullable
    public Object retrieveElement(Object pointer) {
        if (pointer instanceof SmartPointerWrapper) {
            return ReadAction.compute(() -> ((SmartPointerWrapper)pointer).myPointer.getElement());
        }
        return super.retrieveElement(pointer);
    }

    public void freeAnchor(Object element) {
        if (element instanceof SmartPointerWrapper) {
            ApplicationManager.getApplication().runReadAction(() -> {
                SmartPsiElementPointer pointer = ((SmartPointerWrapper)element).myPointer;
                Project project2 = pointer.getProject();
                if (!project2.isDisposed()) {
                    SmartPointerManager.getInstance((Project)project2).removePointer(pointer);
                }
            });
        }
    }

    private static class SmartPointerWrapper {
        private final SmartPsiElementPointer myPointer;

        private SmartPointerWrapper(@NotNull SmartPsiElementPointer pointer) {
            if (pointer == null) {
                SmartPointerWrapper.$$$reportNull$$$0(0);
            }
            this.myPointer = pointer;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof SmartPointerWrapper)) {
                return false;
            }
            SmartPointerWrapper wrapper = (SmartPointerWrapper)o;
            return this.myPointer.equals(wrapper.myPointer);
        }

        public int hashCode() {
            return this.myPointer.hashCode();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pointer", "com/intellij/ide/projectView/impl/nodes/PsiTreeAnchorizer$SmartPointerWrapper", "<init>"));
        }
    }
}

