/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.scratch;

import com.intellij.icons.AllIcons;
import com.intellij.ide.scratch.RootType;
import com.intellij.ide.scratch.ScratchFileService;
import com.intellij.ide.scratch.ScratchFileType;
import com.intellij.lang.Language;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.RunResult;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.UIBundle;
import com.intellij.util.ObjectUtils;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ScratchRootType
extends RootType {
    @NotNull
    public static ScratchRootType getInstance() {
        ScratchRootType scratchRootType = (ScratchRootType)ScratchRootType.findByClass(ScratchRootType.class);
        if (scratchRootType == null) {
            ScratchRootType.$$$reportNull$$$0(0);
        }
        return scratchRootType;
    }

    ScratchRootType() {
        super("scratches", "Scratches");
    }

    public Language substituteLanguage(@NotNull Project project2, @NotNull VirtualFile file2) {
        if (project2 == null) {
            ScratchRootType.$$$reportNull$$$0(1);
        }
        if (file2 == null) {
            ScratchRootType.$$$reportNull$$$0(2);
        }
        return (Language)ScratchFileService.getInstance().getScratchesMapping().getMapping(file2);
    }

    @Nullable
    public Icon substituteIcon(@NotNull Project project2, @NotNull VirtualFile file2) {
        if (project2 == null) {
            ScratchRootType.$$$reportNull$$$0(3);
        }
        if (file2 == null) {
            ScratchRootType.$$$reportNull$$$0(4);
        }
        Icon icon = (Icon)ObjectUtils.chooseNotNull((Object)super.substituteIcon(project2, file2), (Object)ScratchFileType.INSTANCE.getIcon());
        return LayeredIcon.create((Icon)icon, (Icon)AllIcons.Actions.Scratch);
    }

    @Nullable
    public VirtualFile createScratchFile(Project project2, String fileName, Language language, String text2) {
        return this.createScratchFile(project2, fileName, language, text2, ScratchFileService.Option.create_new_always);
    }

    @Nullable
    public VirtualFile createScratchFile(Project project2, final String fileName, final Language language, final String text2, final ScratchFileService.Option option) {
        RunResult result2 = new WriteCommandAction<VirtualFile>(project2, UIBundle.message((String)"file.chooser.create.new.scratch.file.command.name", (Object[])new Object[0]), new PsiFile[0]){

            protected boolean isGlobalUndoAction() {
                return true;
            }

            protected boolean shouldRecordActionForActiveDocument() {
                return false;
            }

            protected UndoConfirmationPolicy getUndoConfirmationPolicy() {
                return UndoConfirmationPolicy.REQUEST_CONFIRMATION;
            }

            protected void run(@NotNull Result<VirtualFile> result2) throws Throwable {
                if (result2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                ScratchFileService fileService = ScratchFileService.getInstance();
                VirtualFile file2 = fileService.findFile((RootType)ScratchRootType.this, fileName, option);
                VfsUtil.saveText((VirtualFile)file2, (String)text2);
                fileService.getScratchesMapping().setMapping(file2, (Object)language);
                result2.setResult((Object)file2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/ide/scratch/ScratchRootType$1", "run"));
            }
        }.execute();
        if (result2.hasException()) {
            Messages.showMessageDialog((String)UIBundle.message((String)"create.new.file.could.not.create.file.error.message", (Object[])new Object[]{fileName}), (String)UIBundle.message((String)"error.dialog.title", (Object[])new Object[0]), (Icon)Messages.getErrorIcon());
            return null;
        }
        return (VirtualFile)result2.getResultObject();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/scratch/ScratchRootType";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/scratch/ScratchRootType";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "substituteLanguage";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "substituteIcon";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

