/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.todo.nodes;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.PsiFileNode;
import com.intellij.ide.todo.HighlightedRegionProvider;
import com.intellij.ide.todo.SmartTodoItemPointer;
import com.intellij.ide.todo.SmartTodoItemPointerComparator;
import com.intellij.ide.todo.TodoFilter;
import com.intellij.ide.todo.TodoTreeBuilder;
import com.intellij.ide.todo.nodes.TodoItemNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.impl.search.TodoItemImpl;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.search.PsiTodoSearchHelper;
import com.intellij.psi.search.TodoItem;
import com.intellij.ui.HighlightedRegion;
import com.intellij.usageView.UsageTreeColors;
import com.intellij.usageView.UsageTreeColorsScheme;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;

public final class TodoFileNode
extends PsiFileNode
implements HighlightedRegionProvider {
    private final TodoTreeBuilder myBuilder;
    private final ArrayList<HighlightedRegion> myHighlightedRegions;
    private final boolean mySingleFileMode;

    public TodoFileNode(Project project2, PsiFile file2, TodoTreeBuilder treeBuilder, boolean singleFileMode) {
        super(project2, file2, ViewSettings.DEFAULT);
        this.myBuilder = treeBuilder;
        this.myHighlightedRegions = new ArrayList(2);
        this.mySingleFileMode = singleFileMode;
    }

    public ArrayList<HighlightedRegion> getHighlightedRegions() {
        return this.myHighlightedRegions;
    }

    @Override
    public Collection<AbstractTreeNode> getChildrenImpl() {
        try {
            if (!this.mySingleFileMode) {
                return this.createGeneralList();
            }
            return this.createListForSingleFile();
        }
        catch (IndexNotReadyException e) {
            return Collections.emptyList();
        }
    }

    private Collection<AbstractTreeNode> createListForSingleFile() {
        PsiFile psiFile = (PsiFile)this.getValue();
        TodoItem[] items = TodoFileNode.findAllTodos(psiFile, this.myBuilder.getTodoTreeStructure().getSearchHelper());
        ArrayList<AbstractTreeNode> children2 = new ArrayList<AbstractTreeNode>(items.length);
        Document document = PsiDocumentManager.getInstance((Project)this.getProject()).getDocument(psiFile);
        if (document != null) {
            for (TodoItem todoItem : items) {
                if (todoItem.getTextRange().getEndOffset() >= document.getTextLength() + 1) continue;
                SmartTodoItemPointer pointer = new SmartTodoItemPointer(todoItem, document);
                TodoFilter toDoFilter = this.getToDoFilter();
                if (toDoFilter != null) {
                    TodoItemNode itemNode = new TodoItemNode(this.getProject(), pointer, this.myBuilder);
                    if (!toDoFilter.contains(todoItem.getPattern())) continue;
                    children2.add(itemNode);
                    continue;
                }
                children2.add(new TodoItemNode(this.getProject(), pointer, this.myBuilder));
            }
        }
        Collections.sort(children2, SmartTodoItemPointerComparator.ourInstance);
        return children2;
    }

    public static TodoItem[] findAllTodos(final PsiFile psiFile, final PsiTodoSearchHelper helper) {
        final ArrayList<TodoItem> todoItems = new ArrayList<TodoItem>(Arrays.asList(helper.findTodoItems(psiFile)));
        psiFile.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){

            public void visitElement(PsiElement element) {
                if (element instanceof PsiLanguageInjectionHost) {
                    InjectedLanguageUtil.enumerate(element, (injectedPsi, places) -> {
                        if (places.size() == 1) {
                            Document document = PsiDocumentManager.getInstance((Project)injectedPsi.getProject()).getCachedDocument(injectedPsi);
                            if (!(document instanceof DocumentWindow)) {
                                return;
                            }
                            for (TodoItem item : helper.findTodoItems(injectedPsi)) {
                                TextRange rangeInHost = ((DocumentWindow)document).injectedToHost(item.getTextRange());
                                todoItems.add(new TodoItemImpl(psiFile, rangeInHost.getStartOffset(), rangeInHost.getEndOffset(), item.getPattern()));
                            }
                        }
                    });
                }
                super.visitElement(element);
            }
        });
        return todoItems.toArray(new TodoItem[todoItems.size()]);
    }

    private Collection<AbstractTreeNode> createGeneralList() {
        ArrayList<AbstractTreeNode> children2 = new ArrayList<AbstractTreeNode>();
        PsiFile psiFile = (PsiFile)this.getValue();
        TodoItem[] items = TodoFileNode.findAllTodos(psiFile, this.myBuilder.getTodoTreeStructure().getSearchHelper());
        Document document = PsiDocumentManager.getInstance((Project)this.getProject()).getDocument(psiFile);
        if (document != null) {
            for (TodoItem todoItem : items) {
                if (todoItem.getTextRange().getEndOffset() >= document.getTextLength() + 1) continue;
                SmartTodoItemPointer pointer = new SmartTodoItemPointer(todoItem, document);
                TodoFilter todoFilter = this.getToDoFilter();
                if (todoFilter != null) {
                    if (!todoFilter.contains(todoItem.getPattern())) continue;
                    children2.add(new TodoItemNode(this.getProject(), pointer, this.myBuilder));
                    continue;
                }
                children2.add(new TodoItemNode(this.getProject(), pointer, this.myBuilder));
            }
        }
        Collections.sort(children2, SmartTodoItemPointerComparator.ourInstance);
        return children2;
    }

    private TodoFilter getToDoFilter() {
        return this.myBuilder.getTodoTreeStructure().getTodoFilter();
    }

    @Override
    protected void updateImpl(PresentationData data) {
        int todoItemCount;
        super.updateImpl(data);
        String newName = this.myBuilder.getTodoTreeStructure().isPackagesShown() ? ((PsiFile)this.getValue()).getName() : (this.mySingleFileMode ? ((PsiFile)this.getValue()).getName() : ((PsiFile)this.getValue()).getVirtualFile().getPresentableUrl());
        int nameEndOffset = newName.length();
        try {
            todoItemCount = this.myBuilder.getTodoTreeStructure().getTodoItemCount((PsiFile)this.getValue());
        }
        catch (IndexNotReadyException e) {
            return;
        }
        newName = this.mySingleFileMode ? (todoItemCount == 0 ? IdeBundle.message((String)"node.todo.no.items.found", (Object[])new Object[]{newName}) : IdeBundle.message((String)"node.todo.found.items", (Object[])new Object[]{newName, todoItemCount})) : IdeBundle.message((String)"node.todo.items", (Object[])new Object[]{newName, todoItemCount});
        this.myHighlightedRegions.clear();
        TextAttributes textAttributes = new TextAttributes();
        textAttributes.setForegroundColor(this.myColor);
        this.myHighlightedRegions.add(new HighlightedRegion(0, nameEndOffset, textAttributes));
        EditorColorsScheme colorsScheme = UsageTreeColorsScheme.getInstance().getScheme();
        this.myHighlightedRegions.add(new HighlightedRegion(nameEndOffset, newName.length(), colorsScheme.getAttributes(UsageTreeColors.NUMBER_OF_USAGES)));
    }

    @Override
    public int getWeight() {
        return 4;
    }
}

