/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.todo.nodes;

import com.intellij.ide.projectView.impl.nodes.PackageElement;
import com.intellij.ide.projectView.impl.nodes.PackageUtil;
import com.intellij.ide.todo.TodoTreeBuilder;
import com.intellij.ide.todo.nodes.TodoDirNode;
import com.intellij.ide.todo.nodes.TodoFileNode;
import com.intellij.ide.todo.nodes.TodoPackageNode;
import com.intellij.ide.todo.nodes.TodoTreeHelper;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class TodoJavaTreeHelper
extends TodoTreeHelper {
    public TodoJavaTreeHelper(Project project2) {
        super(project2);
    }

    @Override
    public boolean skipDirectory(PsiDirectory directory) {
        return JavaDirectoryService.getInstance().getPackage(directory) != null;
    }

    @Override
    public PsiElement getSelectedElement(Object userObject) {
        if (userObject instanceof TodoPackageNode) {
            TodoPackageNode descriptor2 = (TodoPackageNode)userObject;
            PackageElement packageElement = (PackageElement)descriptor2.getValue();
            return packageElement != null ? packageElement.getPackage() : null;
        }
        return super.getSelectedElement(userObject);
    }

    @Override
    public void addPackagesToChildren(ArrayList<AbstractTreeNode> children2, Module module2, TodoTreeBuilder builder) {
        Project project2 = this.getProject();
        PsiManager psiManager = PsiManager.getInstance((Project)project2);
        ArrayList sourceRoots = new ArrayList();
        if (module2 == null) {
            ProjectRootManager projectRootManager = ProjectRootManager.getInstance((Project)project2);
            ContainerUtil.addAll(sourceRoots, (Object[])projectRootManager.getContentSourceRoots());
        } else {
            ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module2);
            ContainerUtil.addAll(sourceRoots, (Object[])moduleRootManager.getSourceRoots());
        }
        HashSet<PsiPackage> topLevelPackages = new HashSet<PsiPackage>();
        for (VirtualFile root : sourceRoots) {
            PsiDirectory directory = psiManager.findDirectory(root);
            if (directory == null) continue;
            PsiPackage directoryPackage = JavaDirectoryService.getInstance().getPackage(directory);
            if (directoryPackage == null || PackageUtil.isPackageDefault(directoryPackage)) {
                PsiDirectory[] subdirectories = directory.getSubdirectories();
                for (PsiDirectory subdirectory : subdirectories) {
                    TodoDirNode dirNode;
                    PsiPackage aPackage = JavaDirectoryService.getInstance().getPackage(subdirectory);
                    if (aPackage != null && !PackageUtil.isPackageDefault(aPackage)) {
                        topLevelPackages.add(aPackage);
                        continue;
                    }
                    Iterator<PsiFile> files = builder.getFiles(subdirectory);
                    if (!files.hasNext() || children2.contains(dirNode = new TodoDirNode(project2, subdirectory, builder))) continue;
                    children2.add((AbstractTreeNode)dirNode);
                }
                Iterator<PsiFile> filesUnderDirectory = builder.getFilesUnderDirectory(directory);
                while (filesUnderDirectory.hasNext()) {
                    PsiFile file2 = filesUnderDirectory.next();
                    TodoFileNode todoFileNode = new TodoFileNode(project2, file2, builder, false);
                    if (children2.contains(todoFileNode)) continue;
                    children2.add((AbstractTreeNode)todoFileNode);
                }
                continue;
            }
            topLevelPackages.add(directoryPackage);
        }
        GlobalSearchScope scope = module2 != null ? GlobalSearchScope.moduleScope((Module)module2) : GlobalSearchScope.projectScope((Project)project2);
        ArrayList<PsiPackage> packages = new ArrayList<PsiPackage>();
        for (PsiPackage psiPackage : topLevelPackages) {
            PsiPackage aPackage = TodoJavaTreeHelper.findNonEmptyPackage(psiPackage, module2, project2, builder, scope);
            if (aPackage == null) continue;
            packages.add(aPackage);
        }
        for (PsiPackage psiPackage : packages) {
            if (!builder.getTodoTreeStructure().getIsFlattenPackages()) {
                PackageElement element = new PackageElement(module2, psiPackage, false);
                TodoPackageNode packageNode = new TodoPackageNode(project2, element, builder, psiPackage.getQualifiedName());
                if (children2.contains(packageNode)) continue;
                children2.add((AbstractTreeNode)packageNode);
                continue;
            }
            HashSet<PsiPackage> allPackages = new HashSet<PsiPackage>();
            TodoJavaTreeHelper.traverseSubPackages(psiPackage, module2, builder, project2, allPackages);
            for (PsiPackage aPackage : allPackages) {
                TodoPackageNode packageNode = new TodoPackageNode(project2, new PackageElement(module2, aPackage, false), builder);
                if (children2.contains(packageNode)) continue;
                children2.add((AbstractTreeNode)packageNode);
            }
        }
        List<VirtualFile> roots = this.collectContentRoots(module2);
        roots.removeAll(sourceRoots);
        this.addDirsToChildren(roots, children2, builder);
    }

    @Nullable
    public static PsiPackage findNonEmptyPackage(PsiPackage rootPackage, Module module2, Project project2, TodoTreeBuilder builder, GlobalSearchScope scope) {
        if (!TodoJavaTreeHelper.isPackageEmpty(new PackageElement(module2, rootPackage, false), builder, project2)) {
            return rootPackage;
        }
        PsiPackage[] subPackages = rootPackage.getSubPackages(scope);
        PsiPackage suggestedNonEmptyPackage = null;
        int count = 0;
        for (PsiPackage aPackage : subPackages) {
            if (TodoJavaTreeHelper.isPackageEmpty(new PackageElement(module2, aPackage, false), builder, project2)) continue;
            if (++count > 1) {
                return rootPackage;
            }
            suggestedNonEmptyPackage = aPackage;
        }
        for (PsiPackage aPackage : subPackages) {
            PsiPackage subPackage;
            if (aPackage == suggestedNonEmptyPackage || (subPackage = TodoJavaTreeHelper.findNonEmptyPackage(aPackage, module2, project2, builder, scope)) == null) continue;
            if (count > 0) {
                return rootPackage;
            }
            ++count;
            suggestedNonEmptyPackage = subPackage;
        }
        return suggestedNonEmptyPackage;
    }

    private static void traverseSubPackages(PsiPackage psiPackage, Module module2, TodoTreeBuilder builder, Project project2, Set<PsiPackage> packages) {
        PsiPackage[] subPackages;
        if (!TodoJavaTreeHelper.isPackageEmpty(new PackageElement(module2, psiPackage, false), builder, project2)) {
            packages.add(psiPackage);
        }
        GlobalSearchScope scope = module2 != null ? GlobalSearchScope.moduleScope((Module)module2) : GlobalSearchScope.projectScope((Project)project2);
        for (PsiPackage subPackage : subPackages = psiPackage.getSubPackages(scope)) {
            TodoJavaTreeHelper.traverseSubPackages(subPackage, module2, builder, project2, packages);
        }
    }

    private static boolean isPackageEmpty(PackageElement packageElement, TodoTreeBuilder builder, Project project2) {
        if (packageElement == null) {
            return true;
        }
        PsiPackage psiPackage = packageElement.getPackage();
        Module module2 = packageElement.getModule();
        GlobalSearchScope scope = module2 != null ? GlobalSearchScope.moduleScope((Module)module2) : GlobalSearchScope.projectScope((Project)project2);
        PsiDirectory[] directories = psiPackage.getDirectories(scope);
        boolean isEmpty = true;
        for (PsiDirectory psiDirectory : directories) {
            isEmpty &= builder.isDirectoryEmpty(psiDirectory);
        }
        return isEmpty;
    }
}

