/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf.darcula.ui;

import com.intellij.ide.ui.laf.darcula.DarculaUIUtil;
import com.intellij.openapi.ui.ErrorBorderCapable;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Area;
import java.awt.geom.RoundRectangle2D;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JSpinner;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.UIResource;

public class DarculaSpinnerBorder
implements Border,
UIResource,
ErrorBorderCapable {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        JSpinner spinner = (JSpinner)c;
        JFormattedTextField editor = (JFormattedTextField)UIUtil.findComponentOfType((JComponent)spinner, JFormattedTextField.class);
        int x1 = x + JBUI.scale((int)1);
        int y1 = y + JBUI.scale((int)3);
        int width1 = width - JBUI.scale((int)2);
        int height1 = height - JBUI.scale((int)6);
        boolean focused = c.isEnabled() && c.isVisible() && editor != null && editor.hasFocus();
        Graphics2D g2 = (Graphics2D)g.create();
        try {
            Object op;
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
            if (c.isOpaque()) {
                g2.setColor(UIUtil.getPanelBackground());
                g2.fillRect(x, y, width, height);
            }
            g2.setColor(UIUtil.getTextFieldBackground());
            g2.fillRoundRect(x1, y1, width1, height1, JBUI.scale((int)5), JBUI.scale((int)5));
            g2.setColor(UIManager.getColor(spinner.isEnabled() ? "Spinner.darcula.enabledButtonColor" : "Spinner.darcula.disabledButtonColor"));
            if (editor != null) {
                int off = editor.getBounds().x + editor.getWidth() + ((JSpinner)c).getInsets().left + JBUI.scale((int)1);
                Area rect = new Area(new RoundRectangle2D.Double(x1, y1, width1, height1, JBUI.scale((int)5), JBUI.scale((int)5)));
                Area blueRect = new Area(new Rectangle(off, y1, JBUI.scale((int)22), height1));
                rect.intersect(blueRect);
                g2.fill(rect);
                if (UIUtil.isUnderDarcula()) {
                    g2.setColor((Color)Gray._100);
                    g2.drawLine(off, y1, off, height1 + JBUI.scale((int)2));
                }
            }
            if (!c.isEnabled()) {
                g2.setComposite(AlphaComposite.getInstance(3, 0.4f));
            }
            if ((op = ((JComponent)c).getClientProperty("JComponent.outline")) != null) {
                g2.translate(x, y + JBUI.scale((int)1));
                DarculaUIUtil.paintOutlineBorder(g2, width, height - JBUI.scale((int)1) * 2, JBUI.scale((int)5), true, focused, DarculaUIUtil.Outline.valueOf(op.toString()));
            } else if (focused) {
                DarculaUIUtil.paintFocusRing(g2, new Rectangle(x1 + JBUI.scale((int)2), y1, width1 - JBUI.scale((int)3), height1));
            } else {
                g2.setColor((Color)new JBColor((Color)Gray._149, (Color)Gray._100));
                g2.drawRoundRect(x1, y1, width1, height1, JBUI.scale((int)5), JBUI.scale((int)5));
            }
        }
        finally {
            g2.dispose();
        }
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return JBUI.insets((int)5, (int)7, (int)5, (int)7).asUIResource();
    }

    @Override
    public boolean isBorderOpaque() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isFocused(Component c) {
        JSpinner spinner;
        if (c.hasFocus()) {
            return true;
        }
        if (c instanceof JSpinner && (spinner = (JSpinner)c).getEditor() != null) {
            Object object = spinner.getEditor().getTreeLock();
            synchronized (object) {
                return spinner.getEditor().getComponent(0).hasFocus();
            }
        }
        return false;
    }
}

