/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util;

import com.intellij.ide.ui.UISettings;
import com.intellij.ide.util.ModuleRendererFactory;
import com.intellij.ide.util.PlatformModuleRendererFactory;
import com.intellij.navigation.ColoredItemPresentation;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.impl.EditorTabbedContainer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.problems.WolfTheProblemSolver;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.JBColor;
import com.intellij.ui.ListSpeedSearch;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.speedSearch.SpeedSearchUtil;
import com.intellij.util.IconUtil;
import com.intellij.util.text.Matcher;
import com.intellij.util.text.MatcherHolder;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.Comparator;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PsiElementListCellRenderer<T extends PsiElement>
extends JPanel
implements ListCellRenderer {
    private static final String LEFT = "West";
    private boolean myFocusBorderEnabled = Registry.is((String)"psi.element.list.cell.renderer.focus.border.enabled");
    protected int myRightComponentWidth;

    protected PsiElementListCellRenderer() {
        super(new BorderLayout());
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new MyAccessibleContext();
        }
        return this.accessibleContext;
    }

    protected static Color getBackgroundColor(@Nullable Object value2) {
        if (value2 instanceof PsiElement) {
            Color fileBgColor;
            PsiElement psiElement = (PsiElement)value2;
            Project project2 = psiElement.getProject();
            VirtualFile file2 = null;
            PsiFile psiFile = psiElement.getContainingFile();
            if (psiFile != null) {
                file2 = psiFile.getVirtualFile();
            } else if (psiElement instanceof PsiDirectory) {
                file2 = ((PsiDirectory)psiElement).getVirtualFile();
            }
            Color color = fileBgColor = file2 != null ? EditorTabbedContainer.calcTabColor(project2, file2) : null;
            if (fileBgColor != null) {
                return fileBgColor;
            }
        }
        return UIUtil.getListBackground();
    }

    @Nullable
    protected TextAttributes getNavigationItemAttributes(Object value2) {
        TextAttributes attributes = null;
        if (value2 instanceof NavigationItem) {
            TextAttributesKey attributesKey = null;
            ItemPresentation presentation = ((NavigationItem)value2).getPresentation();
            if (presentation instanceof ColoredItemPresentation) {
                attributesKey = ((ColoredItemPresentation)presentation).getTextAttributesKey();
            }
            if (attributesKey != null) {
                attributes = EditorColorsManager.getInstance().getGlobalScheme().getAttributes(attributesKey);
            }
        }
        return attributes;
    }

    public Component getListCellRendererComponent(JList list2, Object value2, int index, boolean isSelected, boolean cellHasFocus) {
        this.removeAll();
        this.myRightComponentWidth = 0;
        DefaultListCellRenderer rightRenderer = this.getRightCellRenderer(value2);
        Component rightCellRendererComponent = null;
        JPanel spacer = null;
        if (rightRenderer != null) {
            rightCellRendererComponent = rightRenderer.getListCellRendererComponent((JList<?>)list2, value2, index, isSelected, cellHasFocus);
            this.add(rightCellRendererComponent, "East");
            spacer = new JPanel();
            spacer.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
            this.add((Component)spacer, "Center");
            this.myRightComponentWidth = rightCellRendererComponent.getPreferredSize().width;
            this.myRightComponentWidth += spacer.getPreferredSize().width;
        }
        LeftRenderer leftRenderer = new LeftRenderer(null, value2 == null ? new ItemMatchers(null, null) : this.getItemMatchers(list2, value2));
        Component leftCellRendererComponent = leftRenderer.getListCellRendererComponent(list2, value2, index, isSelected, cellHasFocus);
        this.add(leftCellRendererComponent, LEFT);
        Color bg = isSelected ? UIUtil.getListSelectionBackground() : leftCellRendererComponent.getBackground();
        this.setBackground(bg);
        if (rightCellRendererComponent != null) {
            rightCellRendererComponent.setBackground(bg);
        }
        if (spacer != null) {
            spacer.setBackground(bg);
        }
        return this;
    }

    @NotNull
    protected ItemMatchers getItemMatchers(@NotNull JList list2, @NotNull Object value2) {
        if (list2 == null) {
            PsiElementListCellRenderer.$$$reportNull$$$0(0);
        }
        if (value2 == null) {
            PsiElementListCellRenderer.$$$reportNull$$$0(1);
        }
        ItemMatchers itemMatchers = new ItemMatchers(MatcherHolder.getAssociatedMatcher(list2), null);
        if (itemMatchers == null) {
            PsiElementListCellRenderer.$$$reportNull$$$0(2);
        }
        return itemMatchers;
    }

    protected void setFocusBorderEnabled(boolean enabled) {
        this.myFocusBorderEnabled = enabled;
    }

    protected boolean customizeNonPsiElementLeftRenderer(ColoredListCellRenderer renderer, JList list2, Object value2, int index, boolean selected, boolean hasFocus) {
        return false;
    }

    @Nullable
    protected DefaultListCellRenderer getRightCellRenderer(Object value2) {
        if (UISettings.getInstance().getShowIconInQuickNavigation()) {
            DefaultListCellRenderer renderer = ModuleRendererFactory.findInstance(value2).getModuleRenderer();
            if (renderer instanceof PlatformModuleRendererFactory.PlatformModuleRenderer) {
                return null;
            }
            return renderer;
        }
        return null;
    }

    public abstract String getElementText(T var1);

    @Nullable
    protected abstract String getContainerText(T var1, String var2);

    @Nullable
    protected String getContainerTextForLeftComponent(T element, String name2) {
        return this.getContainerText(element, name2);
    }

    @Iconable.IconFlags
    protected abstract int getIconFlags();

    protected Icon getIcon(PsiElement element) {
        return element.getIcon(this.getIconFlags());
    }

    public Comparator<T> getComparator() {
        return Comparator.comparing(this::getComparingObject);
    }

    @NotNull
    public Comparable getComparingObject(T element) {
        Comparable comparable = (Comparable)ReadAction.compute(() -> {
            String elementText = this.getElementText(element);
            String containerText = this.getContainerText(element, elementText);
            return containerText != null ? elementText + " " + containerText : elementText;
        });
        if (comparable == null) {
            PsiElementListCellRenderer.$$$reportNull$$$0(3);
        }
        return comparable;
    }

    public void installSpeedSearch(PopupChooserBuilder builder) {
        this.installSpeedSearch(builder, false);
    }

    public void installSpeedSearch(PopupChooserBuilder builder, boolean includeContainerText) {
        builder.setFilteringEnabled(o -> {
            if (o instanceof PsiElement) {
                String elementText = this.getElementText((PsiElement)o);
                if (includeContainerText) {
                    return elementText + " " + this.getContainerText((PsiElement)o, elementText);
                }
                return elementText;
            }
            return o.toString();
        });
    }

    @Deprecated
    public void installSpeedSearch(JList list2) {
        new ListSpeedSearch(list2){

            @Override
            protected String getElementText(Object o) {
                if (o instanceof PsiElement) {
                    String elementText = PsiElementListCellRenderer.this.getElementText((PsiElement)o);
                    return elementText + " " + PsiElementListCellRenderer.this.getContainerText((PsiElement)o, elementText);
                }
                return o.toString();
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/util/PsiElementListCellRenderer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/util/PsiElementListCellRenderer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getItemMatchers";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getComparingObject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getItemMatchers";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class LeftRenderer
    extends ColoredListCellRenderer {
        private final String myModuleName;
        private final ItemMatchers myMatchers;

        public LeftRenderer(@NotNull String moduleName, ItemMatchers matchers) {
            if (matchers == null) {
                LeftRenderer.$$$reportNull$$$0(0);
            }
            this.myModuleName = moduleName;
            this.myMatchers = matchers;
        }

        protected void customizeCellRenderer(@NotNull JList list2, Object value2, int index, boolean selected, boolean hasFocus) {
            if (list2 == null) {
                LeftRenderer.$$$reportNull$$$0(1);
            }
            Color bgColor = UIUtil.getListBackground();
            Color color = list2.getForeground();
            this.setPaintFocusBorder(hasFocus && UIUtil.isToUseDottedCellBorder() && PsiElementListCellRenderer.this.myFocusBorderEnabled);
            if (value2 instanceof PsiElement) {
                SimpleTextAttributes nameAttributes;
                TextAttributes attributes;
                VirtualFile vFile;
                PsiElement element = (PsiElement)value2;
                String name2 = element.isValid() ? PsiElementListCellRenderer.this.getElementText(element) : "INVALID";
                PsiFile psiFile = element.isValid() ? element.getContainingFile() : null;
                boolean isProblemFile = false;
                if (psiFile != null && (vFile = psiFile.getVirtualFile()) != null) {
                    Project project2 = psiFile.getProject();
                    if (WolfTheProblemSolver.getInstance((Project)project2).isProblemFile(vFile)) {
                        isProblemFile = true;
                    }
                    FileStatus status = FileStatusManager.getInstance((Project)project2).getStatus(vFile);
                    color = status.getColor();
                    Color fileBgColor = EditorTabbedContainer.calcTabColor(project2, vFile);
                    bgColor = fileBgColor == null ? bgColor : fileBgColor;
                }
                TextAttributes textAttributes = attributes = element.isValid() ? PsiElementListCellRenderer.this.getNavigationItemAttributes(value2) : null;
                if (isProblemFile) {
                    attributes = TextAttributes.merge((TextAttributes)new TextAttributes(color, null, (Color)JBColor.RED, EffectType.WAVE_UNDERSCORE, 0), (TextAttributes)attributes);
                }
                SimpleTextAttributes simpleTextAttributes = nameAttributes = attributes != null ? SimpleTextAttributes.fromTextAttributes((TextAttributes)attributes) : null;
                if (nameAttributes == null) {
                    nameAttributes = new SimpleTextAttributes(0, color);
                }
                assert (name2 != null) : "Null name for PSI element " + element + " (by " + PsiElementListCellRenderer.this + ")";
                SpeedSearchUtil.appendColoredFragmentForMatcher((String)name2, (SimpleColoredComponent)this, (SimpleTextAttributes)nameAttributes, (Matcher)this.myMatchers.nameMatcher, (Color)bgColor, (boolean)selected);
                if (!element.isValid()) {
                    this.append(" Invalid", SimpleTextAttributes.ERROR_ATTRIBUTES);
                    return;
                }
                this.setIcon(PsiElementListCellRenderer.this.getIcon(element));
                String containerText = PsiElementListCellRenderer.this.getContainerTextForLeftComponent(element, name2 + (this.myModuleName != null ? this.myModuleName + "        " : ""));
                if (containerText != null) {
                    SimpleTextAttributes locationAttrs = new SimpleTextAttributes(0, (Color)JBColor.GRAY);
                    SpeedSearchUtil.appendColoredFragmentForMatcher((String)(" " + containerText), (SimpleColoredComponent)this, (SimpleTextAttributes)locationAttrs, (Matcher)this.myMatchers.locationMatcher, (Color)bgColor, (boolean)selected);
                }
            } else if (!PsiElementListCellRenderer.this.customizeNonPsiElementLeftRenderer(this, list2, value2, index, selected, hasFocus)) {
                this.setIcon(IconUtil.getEmptyIcon((boolean)false));
                this.append(value2 == null ? "" : value2.toString(), new SimpleTextAttributes(0, list2.getForeground()));
            }
            this.setBackground(selected ? UIUtil.getListSelectionBackground() : bgColor);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "matchers";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "list";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ide/util/PsiElementListCellRenderer$LeftRenderer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "customizeCellRenderer";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class ItemMatchers {
        @Nullable
        public final Matcher nameMatcher;
        @Nullable
        public final Matcher locationMatcher;

        public ItemMatchers(@Nullable Matcher nameMatcher, @Nullable Matcher locationMatcher) {
            this.nameMatcher = nameMatcher;
            this.locationMatcher = locationMatcher;
        }
    }

    private class MyAccessibleContext
    extends JPanel.AccessibleJPanel {
        private MyAccessibleContext() {
            super(PsiElementListCellRenderer.this);
        }

        @Override
        public String getAccessibleName() {
            LayoutManager lm = PsiElementListCellRenderer.this.getLayout();
            assert (lm instanceof BorderLayout);
            Component leftCellRendererComp = ((BorderLayout)lm).getLayoutComponent(PsiElementListCellRenderer.LEFT);
            return leftCellRendererComp instanceof Accessible ? leftCellRendererComp.getAccessibleContext().getAccessibleName() : super.getAccessibleName();
        }
    }
}

