/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.gotoByName;

import com.intellij.ide.util.gotoByName.ChooseByNamePopup;
import com.intellij.navigation.ChooseByNameContributorEx;
import com.intellij.navigation.GotoClassContributor;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.MinusculeMatcher;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.psi.presentation.java.SymbolPresentationUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiShortNamesCache;
import com.intellij.psi.util.ClassUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import com.intellij.util.Processors;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FindSymbolParameters;
import com.intellij.util.indexing.IdFilter;
import java.util.ArrayList;
import java.util.regex.Matcher;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultClassNavigationContributor
implements ChooseByNameContributorEx,
GotoClassContributor {
    @NotNull
    public String[] getNames(Project project2, boolean includeNonProjectItems) {
        if (FileBasedIndex.ourEnableTracingOfKeyHashToVirtualFileMapping) {
            GlobalSearchScope scope = includeNonProjectItems ? GlobalSearchScope.allScope((Project)project2) : GlobalSearchScope.projectScope((Project)project2);
            ArrayList result2 = new ArrayList();
            Processor processor2 = Processors.cancelableCollectProcessor(result2);
            this.processNames((Processor<String>)processor2, scope, IdFilter.getProjectIdFilter((Project)project2, (boolean)includeNonProjectItems));
            String[] stringArray = ArrayUtil.toStringArray(result2);
            if (stringArray == null) {
                DefaultClassNavigationContributor.$$$reportNull$$$0(0);
            }
            return stringArray;
        }
        String[] stringArray = PsiShortNamesCache.getInstance((Project)project2).getAllClassNames();
        if (stringArray == null) {
            DefaultClassNavigationContributor.$$$reportNull$$$0(1);
        }
        return stringArray;
    }

    @NotNull
    public NavigationItem[] getItemsByName(String name2, String pattern, Project project2, boolean includeNonProjectItems) {
        ArrayList result2 = new ArrayList();
        Processor processor2 = Processors.cancelableCollectProcessor(result2);
        this.processElementsWithName(name2, (Processor<NavigationItem>)processor2, FindSymbolParameters.wrap(pattern, project2, includeNonProjectItems));
        NavigationItem[] navigationItemArray = result2.isEmpty() ? NavigationItem.EMPTY_NAVIGATION_ITEM_ARRAY : result2.toArray(new NavigationItem[result2.size()]);
        if (navigationItemArray == null) {
            DefaultClassNavigationContributor.$$$reportNull$$$0(2);
        }
        return navigationItemArray;
    }

    public String getQualifiedName(NavigationItem item) {
        if (item instanceof PsiClass) {
            return DefaultClassNavigationContributor.getQualifiedNameForClass((PsiClass)item);
        }
        return null;
    }

    public static String getQualifiedNameForClass(PsiClass psiClass) {
        String qName = psiClass.getQualifiedName();
        if (qName != null) {
            return qName;
        }
        String containerText = SymbolPresentationUtil.getSymbolContainerText((PsiElement)psiClass);
        return containerText + "." + psiClass.getName();
    }

    public String getQualifiedNameSeparator() {
        return "$";
    }

    @Override
    public void processNames(@NotNull Processor<String> processor2, @NotNull GlobalSearchScope scope, @Nullable IdFilter filter2) {
        if (processor2 == null) {
            DefaultClassNavigationContributor.$$$reportNull$$$0(3);
        }
        if (scope == null) {
            DefaultClassNavigationContributor.$$$reportNull$$$0(4);
        }
        PsiShortNamesCache.getInstance((Project)scope.getProject()).processAllClassNames(processor2, scope, filter2);
    }

    @Override
    public void processElementsWithName(@NotNull String name2, final @NotNull Processor<NavigationItem> processor2, final @NotNull FindSymbolParameters parameters2) {
        Matcher matcher;
        String namePattern;
        boolean hasDollar;
        if (name2 == null) {
            DefaultClassNavigationContributor.$$$reportNull$$$0(5);
        }
        if (processor2 == null) {
            DefaultClassNavigationContributor.$$$reportNull$$$0(6);
        }
        if (parameters2 == null) {
            DefaultClassNavigationContributor.$$$reportNull$$$0(7);
        }
        if ((hasDollar = (namePattern = StringUtil.getShortName((String)parameters2.getCompletePattern())).contains("$")) && (matcher = ChooseByNamePopup.patternToDetectAnonymousClasses.matcher(namePattern)).matches()) {
            namePattern = matcher.group(1);
            hasDollar = namePattern.contains("$");
        }
        final MinusculeMatcher innerMatcher = hasDollar ? NameUtil.buildMatcher((String)("*" + namePattern)).build() : null;
        PsiShortNamesCache.getInstance((Project)parameters2.getProject()).processClassesWithName(name2, (Processor)new Processor<PsiClass>(){
            final boolean isAnnotation;
            {
                this.isAnnotation = parameters2.getLocalPatternName().startsWith("@");
            }

            public boolean process(PsiClass aClass) {
                if (!DefaultClassNavigationContributor.isPhysical(aClass)) {
                    return true;
                }
                if (this.isAnnotation && !aClass.isAnnotationType()) {
                    return true;
                }
                if (innerMatcher != null) {
                    if (aClass.getContainingClass() == null) {
                        return true;
                    }
                    String jvmQName = ClassUtil.getJVMClassName((PsiClass)aClass);
                    if (jvmQName == null || !innerMatcher.matches(StringUtil.getShortName((String)jvmQName))) {
                        return true;
                    }
                }
                return processor2.process((Object)aClass);
            }
        }, parameters2.getSearchScope(), parameters2.getIdFilter());
    }

    private static boolean isPhysical(PsiClass aClass) {
        PsiFile file2 = aClass.getContainingFile();
        return file2 != null && file2.getVirtualFile() != null && aClass.isPhysical();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/util/gotoByName/DefaultClassNavigationContributor";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getNames";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getItemsByName";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/util/gotoByName/DefaultClassNavigationContributor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "processNames";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "processElementsWithName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

