/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.importProject;

import com.intellij.ide.util.projectWizard.importSources.DetectedProjectRoot;
import com.intellij.ide.util.projectWizard.importSources.ProjectStructureDetector;
import com.intellij.util.containers.MultiMap;
import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class DetectedRootData {
    private final File myDirectory;
    private MultiMap<DetectedProjectRoot, ProjectStructureDetector> myRoots = MultiMap.createLinked();
    private boolean myIncluded = true;
    private DetectedProjectRoot mySelectedRoot;

    public DetectedRootData(ProjectStructureDetector detector, DetectedProjectRoot root) {
        this.myDirectory = root.getDirectory();
        this.mySelectedRoot = root;
        this.myRoots.putValue((Object)root, (Object)detector);
    }

    public File getDirectory() {
        return this.myDirectory;
    }

    public DetectedProjectRoot addRoot(ProjectStructureDetector detector, DetectedProjectRoot root) {
        for (Map.Entry entry : this.myRoots.entrySet()) {
            DetectedProjectRoot oldRoot = (DetectedProjectRoot)entry.getKey();
            DetectedProjectRoot combined = oldRoot.combineWith(root);
            if (combined == null) continue;
            this.myRoots.remove((Object)oldRoot);
            HashSet<ProjectStructureDetector> values = new HashSet<ProjectStructureDetector>((Collection)entry.getValue());
            values.add(detector);
            this.myRoots.put((Object)combined, values);
            if (this.mySelectedRoot == oldRoot) {
                this.mySelectedRoot = combined;
            }
            return combined;
        }
        this.myRoots.putValue((Object)root, (Object)detector);
        return root;
    }

    public DetectedProjectRoot[] getAllRoots() {
        Set roots = this.myRoots.keySet();
        return roots.toArray(new DetectedProjectRoot[roots.size()]);
    }

    public boolean isEmpty() {
        return this.myRoots.isEmpty();
    }

    public boolean isIncluded() {
        return this.myIncluded;
    }

    public void setIncluded(boolean included) {
        this.myIncluded = included;
    }

    @NotNull
    public Collection<ProjectStructureDetector> getSelectedDetectors() {
        Collection collection = this.myRoots.get((Object)this.mySelectedRoot);
        if (collection == null) {
            DetectedRootData.$$$reportNull$$$0(0);
        }
        return collection;
    }

    public DetectedProjectRoot getSelectedRoot() {
        return this.mySelectedRoot;
    }

    public void setSelectedRoot(DetectedProjectRoot root) {
        this.mySelectedRoot = root;
    }

    public Collection<ProjectStructureDetector> removeRoot(DetectedProjectRoot root) {
        return this.myRoots.remove((Object)root);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/importProject/DetectedRootData", "getSelectedDetectors"));
    }
}

