/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.projectWizard;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.util.projectWizard.NamePathComponent;
import com.intellij.ide.util.projectWizard.ProjectBuilder;
import com.intellij.ide.util.projectWizard.ProjectWizardUtil;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.components.StorageScheme;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NonNls;

public class ProjectNameStep
extends ModuleWizardStep {
    private final NamePathComponent myNamePathComponent;
    private final JPanel myPanel;
    private final WizardContext myWizardContext;

    public ProjectNameStep(WizardContext wizardContext) {
        this.myWizardContext = wizardContext;
        this.myNamePathComponent = new NamePathComponent(IdeBundle.message((String)"label.project.name", (Object[])new Object[0]), IdeBundle.message((String)"label.component.file.location", (Object[])new Object[]{StringUtil.capitalize((String)this.myWizardContext.getPresentationName())}), 'a', 'l', IdeBundle.message((String)"title.select.project.file.directory", (Object[])new Object[]{this.myWizardContext.getPresentationName()}), IdeBundle.message((String)"description.select.project.file.directory", (Object[])new Object[]{this.myWizardContext.getPresentationName()}));
        this.myPanel = new JPanel(new GridBagLayout());
        this.myPanel.setBorder(BorderFactory.createEtchedBorder());
        String appName = ApplicationNamesInfo.getInstance().getFullProductName();
        this.myPanel.add((Component)new JLabel(IdeBundle.message((String)"label.please.enter.project.name", (Object[])new Object[]{appName, wizardContext.getPresentationName()})), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 18, 2, (Insets)JBUI.insets((int)8, (int)10), 0, 0));
        this.myPanel.add((Component)this.myNamePathComponent, new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 18, 2, (Insets)JBUI.insets((int)8, (int)10), 0, 0));
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myNamePathComponent.getNameComponent();
    }

    public String getHelpId() {
        return "reference.dialogs.new.project.import.name";
    }

    public JComponent getComponent() {
        return this.myPanel;
    }

    public void updateStep() {
        List components;
        super.updateStep();
        this.myNamePathComponent.setPath(FileUtil.toSystemDependentName((String)this.myWizardContext.getProjectFileDirectory()));
        String name2 = this.myWizardContext.getProjectName();
        if (name2 == null && !(components = StringUtil.split((String)FileUtil.toSystemIndependentName((String)this.myWizardContext.getProjectFileDirectory()), (String)"/")).isEmpty()) {
            name2 = (String)components.get(components.size() - 1);
        }
        this.myNamePathComponent.setNameValue(name2);
        if (name2 != null) {
            this.myNamePathComponent.getNameComponent().setSelectionStart(0);
            this.myNamePathComponent.getNameComponent().setSelectionEnd(name2.length());
        }
    }

    public void updateDataModel() {
        this.myWizardContext.setProjectName(this.getProjectName());
        this.myWizardContext.setProjectFileDirectory(this.getProjectFileDirectory());
    }

    public Icon getIcon() {
        return this.myWizardContext.getStepIcon();
    }

    public boolean validate() throws ConfigurationException {
        String name2 = this.myNamePathComponent.getNameValue();
        if (name2.length() == 0) {
            ApplicationNamesInfo info = ApplicationNamesInfo.getInstance();
            throw new ConfigurationException(IdeBundle.message((String)"prompt.new.project.file.name", (Object[])new Object[]{info.getFullProductName(), this.myWizardContext.getPresentationName()}));
        }
        String projectFileDirectory = this.getProjectFileDirectory();
        if (projectFileDirectory.length() == 0) {
            throw new ConfigurationException(IdeBundle.message((String)"prompt.enter.project.file.location", (Object[])new Object[]{this.myWizardContext.getPresentationName()}));
        }
        boolean shouldPromptCreation = this.myNamePathComponent.isPathChangedByUser();
        String prefix = IdeBundle.message((String)"directory.project.file.directory", (Object[])new Object[]{this.myWizardContext.getPresentationName()});
        if (!ProjectWizardUtil.createDirectoryIfNotExists(prefix, projectFileDirectory, shouldPromptCreation)) {
            return false;
        }
        boolean shouldContinue = true;
        String path = this.myWizardContext.isCreatingNewProject() && this.myWizardContext.getProjectStorageFormat() == StorageScheme.DIRECTORY_BASED ? this.getProjectFileDirectory() + "/" + ".idea" : this.getProjectFilePath();
        File projectFile = new File(path);
        if (projectFile.exists()) {
            String title = this.myWizardContext.isCreatingNewProject() ? IdeBundle.message((String)"title.new.project", (Object[])new Object[0]) : IdeBundle.message((String)"title.add.module", (Object[])new Object[0]);
            String message2 = this.myWizardContext.isCreatingNewProject() && this.myWizardContext.getProjectStorageFormat() == StorageScheme.DIRECTORY_BASED ? IdeBundle.message((String)"prompt.overwrite.project.folder", (Object[])new Object[]{".idea", projectFile.getParentFile().getAbsolutePath()}) : IdeBundle.message((String)"prompt.overwrite.project.file", (Object[])new Object[]{projectFile.getAbsolutePath(), this.myWizardContext.getPresentationName()});
            int answer = Messages.showYesNoDialog((String)message2, (String)title, (Icon)Messages.getQuestionIcon());
            shouldContinue = answer == 0;
        }
        return shouldContinue;
    }

    @NonNls
    public String getProjectFilePath() {
        return this.getProjectFileDirectory() + "/" + this.myNamePathComponent.getNameValue() + (this.myWizardContext.getProject() == null ? ".ipr" : ".iml");
    }

    public String getProjectFileDirectory() {
        return FileUtil.toSystemIndependentName((String)this.myNamePathComponent.getPath());
    }

    public String getProjectName() {
        return this.myNamePathComponent.getNameValue();
    }

    public String getName() {
        return "Name";
    }

    public boolean isStepVisible() {
        ProjectBuilder builder = this.myWizardContext.getProjectBuilder();
        if (builder != null && builder.isUpdate()) {
            return false;
        }
        return super.isStepVisible();
    }
}

