/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.psiView.formattingblocks;

import com.intellij.diagnostic.AttachmentFactory;
import com.intellij.diagnostic.LogMessageEx;
import com.intellij.formatting.ASTBlock;
import com.intellij.formatting.Block;
import com.intellij.formatting.FormattingModel;
import com.intellij.formatting.FormattingModelBuilder;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.internal.psiView.PsiViewerDialog;
import com.intellij.internal.psiView.ViewerPsiBasedTree;
import com.intellij.internal.psiView.formattingblocks.BlockTreeBuilder;
import com.intellij.internal.psiView.formattingblocks.BlockTreeNode;
import com.intellij.internal.psiView.formattingblocks.BlockTreeStructure;
import com.intellij.lang.ASTNode;
import com.intellij.lang.LanguageFormatting;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBTreeTraverser;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Collection;
import java.util.HashMap;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockViewerPsiBasedTree
implements ViewerPsiBasedTree {
    @NotNull
    private final JPanel myBlockStructurePanel;
    @Nullable
    private BlockTreeBuilder myBlockTreeBuilder;
    @NotNull
    private final Tree myBlockTree;
    @NotNull
    private final Project myProject;
    @NotNull
    private final ViewerPsiBasedTree.PsiTreeUpdater myUpdater;
    private int myIgnoreBlockTreeSelectionMarker;
    @Nullable
    private volatile HashMap<PsiElement, BlockTreeNode> myPsiToBlockMap;

    public BlockViewerPsiBasedTree(@NotNull Project project2, @NotNull ViewerPsiBasedTree.PsiTreeUpdater updater) {
        if (project2 == null) {
            BlockViewerPsiBasedTree.$$$reportNull$$$0(0);
        }
        if (updater == null) {
            BlockViewerPsiBasedTree.$$$reportNull$$$0(1);
        }
        this.myIgnoreBlockTreeSelectionMarker = 0;
        this.myProject = project2;
        this.myUpdater = updater;
        this.myBlockTree = new Tree((TreeModel)new DefaultTreeModel(new DefaultMutableTreeNode()));
        this.myBlockStructurePanel = new JPanel(new BorderLayout());
        this.myBlockStructurePanel.add(ScrollPaneFactory.createScrollPane((Component)this.myBlockTree));
        this.myBlockStructurePanel.setBorder(IdeBorderFactory.createBorder());
        PsiViewerDialog.initTree((JTree)this.myBlockTree);
    }

    @Override
    public void reloadTree(@Nullable PsiElement rootRootElement, @NotNull String text2) {
        if (text2 == null) {
            BlockViewerPsiBasedTree.$$$reportNull$$$0(2);
        }
        this.resetBlockTree();
        this.buildBlockTree(rootRootElement);
    }

    @Override
    public void selectNodeFromPsi(@Nullable PsiElement element) {
        BlockTreeNode currentBlockNode;
        if (this.myBlockTreeBuilder != null && element != null && (currentBlockNode = this.findBlockNode(element)) != null) {
            this.selectBlockNode(currentBlockNode);
        }
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myBlockStructurePanel;
        if (jPanel == null) {
            BlockViewerPsiBasedTree.$$$reportNull$$$0(3);
        }
        return jPanel;
    }

    @Override
    public boolean isFocusOwner() {
        return this.myBlockTree.isFocusOwner();
    }

    @Override
    public void focusTree() {
        IdeFocusManager.getInstance((Project)this.myProject).requestFocus((Component)this.myBlockTree, true);
    }

    public void dispose() {
        this.resetBlockTree();
    }

    private void resetBlockTree() {
        this.myBlockTree.removeAll();
        if (this.myBlockTreeBuilder != null) {
            Disposer.dispose((Disposable)this.myBlockTreeBuilder);
            this.myBlockTreeBuilder = null;
        }
        this.myPsiToBlockMap = null;
        ViewerPsiBasedTree.removeListenerOfClass(this.myBlockTree, BlockTreeSelectionListener.class);
    }

    private void buildBlockTree(@Nullable PsiElement rootElement) {
        Block rootBlock;
        Block block = rootBlock = rootElement == null ? null : BlockViewerPsiBasedTree.buildBlocks(rootElement);
        if (rootBlock == null) {
            this.myBlockTreeBuilder = null;
            this.myBlockTree.setRootVisible(false);
            this.myBlockTree.setVisible(false);
            return;
        }
        this.myBlockTree.setVisible(true);
        BlockTreeStructure blockTreeStructure = new BlockTreeStructure();
        BlockTreeNode rootNode = new BlockTreeNode(rootBlock, null);
        blockTreeStructure.setRoot(rootNode);
        this.myBlockTreeBuilder = new BlockTreeBuilder((JTree)this.myBlockTree, blockTreeStructure);
        this.initMap(rootNode, rootElement);
        assert (this.myPsiToBlockMap != null);
        PsiElement rootPsi = rootNode.getBlock() instanceof ASTBlock ? ((ASTBlock)rootNode.getBlock()).getNode().getPsi() : rootElement;
        BlockTreeNode blockNode = this.myPsiToBlockMap.get(rootPsi);
        if (blockNode == null) {
            PsiViewerDialog.LOG.error((Object)LogMessageEx.createEvent("PsiViewer: rootNode not found", "Current language: " + rootElement.getContainingFile().getLanguage(), AttachmentFactory.createAttachment(rootElement.getContainingFile().getOriginalFile().getVirtualFile())));
            blockNode = this.findBlockNode(rootPsi);
        }
        blockTreeStructure.setRoot(blockNode);
        this.myBlockTree.addTreeSelectionListener((TreeSelectionListener)new BlockTreeSelectionListener(rootElement));
        this.myBlockTree.setRootVisible(true);
        this.myBlockTree.expandRow(0);
        this.myBlockTreeBuilder.queueUpdate();
    }

    @Nullable
    private BlockTreeNode findBlockNode(PsiElement element) {
        BlockTreeNode result2;
        HashMap<PsiElement, BlockTreeNode> psiToBlockMap = this.myPsiToBlockMap;
        BlockTreeNode blockTreeNode = result2 = psiToBlockMap == null ? null : psiToBlockMap.get(element);
        if (result2 == null) {
            TextRange rangeInHostFile = InjectedLanguageManager.getInstance((Project)this.myProject).injectedToHost(element, element.getTextRange());
            result2 = this.findBlockNode(rangeInHostFile);
        }
        return result2;
    }

    private void selectBlockNode(@Nullable BlockTreeNode currentBlockNode) {
        if (this.myBlockTreeBuilder == null) {
            return;
        }
        if (currentBlockNode != null) {
            ++this.myIgnoreBlockTreeSelectionMarker;
            this.myBlockTreeBuilder.select((Object)currentBlockNode, () -> {
                assert (this.myIgnoreBlockTreeSelectionMarker > 0);
                --this.myIgnoreBlockTreeSelectionMarker;
            });
        } else {
            ++this.myIgnoreBlockTreeSelectionMarker;
            try {
                this.myBlockTree.getSelectionModel().clearSelection();
            }
            finally {
                assert (this.myIgnoreBlockTreeSelectionMarker > 0);
                --this.myIgnoreBlockTreeSelectionMarker;
            }
        }
    }

    @Nullable
    private BlockTreeNode findBlockNode(TextRange range) {
        BlockTreeBuilder builder = this.myBlockTreeBuilder;
        if (builder == null || !this.myBlockStructurePanel.isVisible()) {
            return null;
        }
        AbstractTreeStructure treeStructure = builder.getTreeStructure();
        if (treeStructure == null) {
            return null;
        }
        BlockTreeNode node = (BlockTreeNode)((Object)treeStructure.getRootElement());
        block0: while (true) {
            if (node.getBlock().getTextRange().equals((Object)range)) {
                return node;
            }
            for (BlockTreeNode child : node.getChildren()) {
                if (!child.getBlock().getTextRange().contains(range)) continue;
                node = child;
                continue block0;
            }
            break;
        }
        return node;
    }

    @Nullable
    private static Block buildBlocks(@NotNull PsiElement rootElement) {
        if (rootElement == null) {
            BlockViewerPsiBasedTree.$$$reportNull$$$0(4);
        }
        FormattingModelBuilder formattingModelBuilder = LanguageFormatting.INSTANCE.forContext(rootElement);
        CodeStyleSettings settings = CodeStyleSettingsManager.getSettings((Project)rootElement.getProject());
        if (formattingModelBuilder != null) {
            FormattingModel formattingModel = formattingModelBuilder.createModel(rootElement, settings);
            return formattingModel.getRootBlock();
        }
        return null;
    }

    private void initMap(BlockTreeNode rootBlockNode, PsiElement psiEl) {
        this.myPsiToBlockMap = new HashMap();
        JBTreeTraverser traverser = JBTreeTraverser.of(BlockTreeNode::getChildren);
        for (BlockTreeNode block : (JBTreeTraverser)traverser.withRoot((Object)rootBlockNode)) {
            ASTNode node;
            PsiElement currentElem = null;
            if (block.getBlock() instanceof ASTBlock && (node = ((ASTBlock)block.getBlock()).getNode()) != null) {
                currentElem = node.getPsi();
            }
            if (currentElem == null) {
                currentElem = InjectedLanguageUtil.findElementAtNoCommit(psiEl.getContainingFile(), block.getBlock().getTextRange().getStartOffset());
            }
            this.myPsiToBlockMap.put(currentElem, block);
            TextRange curTextRange = currentElem.getTextRange();
            for (PsiElement parentElem = currentElem.getParent(); parentElem != null && parentElem.getTextRange().equals((Object)curTextRange); parentElem = parentElem.getParent()) {
                this.myPsiToBlockMap.put(parentElem, block);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/psiView/formattingblocks/BlockViewerPsiBasedTree";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/psiView/formattingblocks/BlockViewerPsiBasedTree";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "reloadTree";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "buildBlocks";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public class BlockTreeSelectionListener
    implements TreeSelectionListener {
        @NotNull
        private PsiElement myRootElement;

        public BlockTreeSelectionListener(PsiElement rootElement) {
            if (rootElement == null) {
                BlockTreeSelectionListener.$$$reportNull$$$0(0);
            }
            this.myRootElement = rootElement;
        }

        @Override
        public void valueChanged(@NotNull TreeSelectionEvent e) {
            if (e == null) {
                BlockTreeSelectionListener.$$$reportNull$$$0(1);
            }
            if (BlockViewerPsiBasedTree.this.myIgnoreBlockTreeSelectionMarker > 0 || BlockViewerPsiBasedTree.this.myBlockTreeBuilder == null) {
                return;
            }
            Set blockElementsSet = BlockViewerPsiBasedTree.this.myBlockTreeBuilder.getSelectedElements();
            Object item = ContainerUtil.getFirstItem((Collection)blockElementsSet);
            if (!(item instanceof BlockTreeNode)) {
                return;
            }
            BlockTreeNode descriptor2 = (BlockTreeNode)((Object)item);
            PsiElement rootPsi = this.myRootElement;
            int blockStart = descriptor2.getBlock().getTextRange().getStartOffset();
            PsiFile file2 = rootPsi.getContainingFile();
            PsiElement currentPsiEl = InjectedLanguageUtil.findElementAtNoCommit(file2, blockStart);
            if (currentPsiEl == null) {
                currentPsiEl = file2;
            }
            int blockLength = descriptor2.getBlock().getTextRange().getLength();
            while (currentPsiEl.getParent() != null && currentPsiEl.getTextRange().getStartOffset() == blockStart && currentPsiEl.getTextLength() != blockLength) {
                currentPsiEl = currentPsiEl.getParent();
            }
            BlockTreeStructure treeStructure = (BlockTreeStructure)((Object)ObjectUtils.notNull((Object)((Object)((BlockTreeStructure)BlockViewerPsiBasedTree.this.myBlockTreeBuilder.getTreeStructure()))));
            BlockTreeNode rootBlockNode = treeStructure.getRootElement();
            int baseOffset = 0;
            if (rootBlockNode != null) {
                baseOffset = rootBlockNode.getBlock().getTextRange().getStartOffset();
            }
            TextRange range = descriptor2.getBlock().getTextRange();
            range = range.shiftRight(-baseOffset);
            BlockViewerPsiBasedTree.this.myUpdater.updatePsiTree(currentPsiEl, (TextRange)(BlockViewerPsiBasedTree.this.myBlockTree.hasFocus() ? range : null));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rootElement";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/internal/psiView/formattingblocks/BlockViewerPsiBasedTree$BlockTreeSelectionListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "valueChanged";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

