/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic;

import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.ide.plugins.cl.PluginClassLoader;
import com.intellij.internal.statistic.CollectUsagesException;
import com.intellij.internal.statistic.beans.GroupDescriptor;
import com.intellij.internal.statistic.beans.UsageDescriptor;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.util.Pair;
import java.util.Set;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

public abstract class UsagesCollector {
    public static final ExtensionPointName<UsagesCollector> EP_NAME = ExtensionPointName.create((String)"com.intellij.statistics.usagesCollector");

    @NotNull
    public abstract Set<UsageDescriptor> getUsages() throws CollectUsagesException;

    @NotNull
    public abstract GroupDescriptor getGroupId();

    private static Pair<Double, Double> findBucket(double value2, double ... ranges) {
        if (ranges.length == 0) {
            throw new IllegalArgumentException("Constrains are empty");
        }
        if (value2 < ranges[0]) {
            return Pair.create(null, (Object)ranges[0]);
        }
        for (int i = 1; i < ranges.length; ++i) {
            if (ranges[i] <= ranges[i - 1]) {
                throw new IllegalArgumentException("Constrains are unsorted");
            }
            if (!(value2 < ranges[i])) continue;
            return Pair.create((Object)ranges[i - 1], (Object)ranges[i]);
        }
        return Pair.create((Object)ranges[ranges.length - 1], null);
    }

    public static boolean isNotBundledPluginClass(@NotNull Class clazz) {
        IdeaPluginDescriptor plugin;
        PluginId id;
        ClassLoader loader;
        if (clazz == null) {
            UsagesCollector.$$$reportNull$$$0(0);
        }
        return (loader = clazz.getClassLoader()) instanceof PluginClassLoader && (id = ((PluginClassLoader)((Object)loader)).getPluginId()) != null && (plugin = PluginManager.getPlugin(id)) != null && !plugin.isBundled();
    }

    protected static String findBucket(long value2, Function<Long, String> valueConverter, long ... ranges) {
        double[] dRanges = new double[ranges.length];
        for (int i = 0; i < dRanges.length; ++i) {
            dRanges[i] = ranges[i];
        }
        return UsagesCollector.findBucket((double)value2, (Double d) -> (String)valueConverter.apply(d.longValue()), dRanges);
    }

    protected static String findBucket(double value2, Function<Double, String> valueConverter, double ... ranges) {
        for (double range : ranges) {
            if (range != value2) continue;
            return valueConverter.apply(value2);
        }
        Pair<Double, Double> bucket = UsagesCollector.findBucket(value2, ranges);
        if (bucket.first == null) {
            return "(*, " + valueConverter.apply((Double)bucket.second) + ")";
        }
        if (bucket.second == null) {
            return "(" + valueConverter.apply((Double)bucket.first) + ", *)";
        }
        return "(" + valueConverter.apply((Double)bucket.first) + ", " + valueConverter.apply((Double)bucket.second) + ")";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/internal/statistic/UsagesCollector", "isNotBundledPluginClass"));
    }
}

