/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.utils;

import com.intellij.internal.statistic.beans.UsageDescriptor;
import com.intellij.util.containers.ObjectIntHashMap;
import gnu.trove.THashSet;
import gnu.trove.TObjectIntProcedure;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=2, d1={"\u0000<\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0010\n\u0002\b\u0007\u001a$\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0002\u001a\u0016\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000e\u001a$\u0010\u000f\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u00012\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00010\u0011\u001a\u001c\u0010\u0012\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\u00072\f\u0010\r\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0013\u001a\u0010\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0001H\u0002\u001a(\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\n0\t2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\n0\t2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\n0\t\u001a\u001a\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\n0\t2\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082D\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"kilo", "", "mega", "addAll", "", "result", "Lcom/intellij/util/containers/ObjectIntHashMap;", "", "usages", "", "Lcom/intellij/internal/statistic/beans/UsageDescriptor;", "getBooleanUsage", "key", "value", "", "getCountingUsage", "steps", "", "getEnumUsage", "", "humanize", "number", "merge", "first", "second", "toUsageDescriptors", "platform-impl"})
public final class StatisticsUtilKt {
    private static final int kilo = 1000;
    private static final int mega = 1000000;

    @NotNull
    public static final UsageDescriptor getBooleanUsage(@NotNull String key2, boolean value2) {
        Intrinsics.checkParameterIsNotNull((Object)key2, (String)"key");
        return new UsageDescriptor(key2 + (value2 ? ".enabled" : ".disabled"), 1);
    }

    @NotNull
    public static final UsageDescriptor getEnumUsage(@NotNull String key2, @Nullable Enum<?> value2) {
        String string;
        UsageDescriptor usageDescriptor;
        Intrinsics.checkParameterIsNotNull((Object)key2, (String)"key");
        UsageDescriptor usageDescriptor2 = usageDescriptor;
        UsageDescriptor usageDescriptor3 = usageDescriptor;
        StringBuilder stringBuilder = new StringBuilder().append(key2).append(".");
        Enum<?> enum_ = value2;
        if (enum_ != null && (enum_ = enum_.name()) != null) {
            Enum<?> enum_2 = enum_;
            StringBuilder stringBuilder2 = stringBuilder;
            UsageDescriptor usageDescriptor4 = usageDescriptor2;
            UsageDescriptor usageDescriptor5 = usageDescriptor3;
            Enum<?> enum_3 = enum_2;
            if (enum_3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string2 = ((String)((Object)enum_3)).toLowerCase();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.String).toLowerCase()");
            String string3 = string2;
            usageDescriptor3 = usageDescriptor5;
            usageDescriptor2 = usageDescriptor4;
            stringBuilder = stringBuilder2;
            string = string3;
        } else {
            string = null;
        }
        usageDescriptor2(stringBuilder.append(string).toString(), 1);
        return usageDescriptor3;
    }

    @NotNull
    public static final UsageDescriptor getCountingUsage(@NotNull String key2, int value2, @NotNull List<Integer> steps) {
        Intrinsics.checkParameterIsNotNull((Object)key2, (String)"key");
        Intrinsics.checkParameterIsNotNull(steps, (String)"steps");
        if (steps.isEmpty()) {
            return new UsageDescriptor("" + key2 + '.' + value2, 1);
        }
        if (value2 < ((Number)steps.get(0)).intValue()) {
            return new UsageDescriptor("" + key2 + ".<" + ((Number)steps.get(0)).intValue(), 1);
        }
        int index = CollectionsKt.binarySearch$default(steps, (Comparable)Integer.valueOf(value2), (int)0, (int)0, (int)6, null);
        int stepIndex = index == steps.size() ? ((Number)CollectionsKt.last(steps)).intValue() : (index >= 0 ? index : -index - 2);
        int step = ((Number)steps.get(stepIndex)).intValue();
        boolean addPlus = stepIndex == steps.size() - 1 || ((Number)steps.get(stepIndex + 1)).intValue() != step + 1;
        String maybePlus = addPlus ? "+" : "";
        return new UsageDescriptor("" + key2 + '.' + StatisticsUtilKt.humanize(step) + "" + maybePlus, 1);
    }

    private static final String humanize(int number) {
        if (number == 0) {
            return "0";
        }
        int m = number / mega;
        int k = number % mega / kilo;
        int r = number % kilo;
        String ms = m > 0 ? "" + m + 'M' : "";
        String ks = k > 0 ? "" + k + 'K' : "";
        String rs = r > 0 ? "" + r : "";
        return ms + ks + rs;
    }

    @NotNull
    public static final Set<UsageDescriptor> toUsageDescriptors(@NotNull ObjectIntHashMap<String> result2) {
        Intrinsics.checkParameterIsNotNull(result2, (String)"result");
        if (result2.isEmpty()) {
            return SetsKt.emptySet();
        }
        THashSet descriptors = new THashSet(result2.size());
        result2.forEachEntry((TObjectIntProcedure)new TObjectIntProcedure<String>(descriptors){
            final /* synthetic */ THashSet $descriptors;

            public final boolean execute(String key2, int value2) {
                this.$descriptors.add((Object)new UsageDescriptor(key2, value2));
                return true;
            }
            {
                this.$descriptors = tHashSet;
            }
        });
        return (Set)descriptors;
    }

    @NotNull
    public static final Set<UsageDescriptor> merge(@NotNull Set<UsageDescriptor> first, @NotNull Set<UsageDescriptor> second) {
        Intrinsics.checkParameterIsNotNull(first, (String)"first");
        Intrinsics.checkParameterIsNotNull(second, (String)"second");
        if (first.isEmpty()) {
            return second;
        }
        if (second.isEmpty()) {
            return first;
        }
        ObjectIntHashMap merged = new ObjectIntHashMap();
        StatisticsUtilKt.addAll((ObjectIntHashMap<String>)merged, first);
        StatisticsUtilKt.addAll((ObjectIntHashMap<String>)merged, second);
        return StatisticsUtilKt.toUsageDescriptors((ObjectIntHashMap<String>)merged);
    }

    private static final void addAll(ObjectIntHashMap<String> result2, Set<UsageDescriptor> usages) {
        for (UsageDescriptor usage : usages) {
            String key2 = usage.getKey();
            result2.put((Object)key2, result2.get((Object)key2, 0) + usage.getValue());
        }
    }

    static {
        kilo = 1000;
        mega = kilo * kilo;
    }
}

