/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.validation;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.wm.impl.FocusManagerImpl;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MacMessagesTest
extends AnAction {
    public void actionPerformed(AnActionEvent anActionEvent) {
        JDialog controlDialog = new JDialog();
        controlDialog.setTitle("Messages testing control panel");
        controlDialog.setModalExclusionType(Dialog.ModalExclusionType.APPLICATION_EXCLUDE);
        controlDialog.setModal(false);
        controlDialog.setFocusableWindowState(false);
        controlDialog.setDefaultCloseOperation(2);
        Container cp = controlDialog.getContentPane();
        cp.setLayout(new FlowLayout());
        JButton showDialogWrapperButton = new JButton("Show a dialog wrapper");
        showDialogWrapperButton.setFocusable(false);
        FocusManagerImpl fmi = FocusManagerImpl.getInstance();
        final Project p = fmi.getLastFocusedFrame().getProject();
        showDialogWrapperButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                SimpleDialogWrapper dw = new SimpleDialogWrapper(p);
                dw.setTitle(dw.getWindow().getName());
                dw.show();
            }
        });
        JButton showMessageButton = new JButton("Show a message");
        showDialogWrapperButton.setFocusable(false);
        showMessageButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                MacMessagesTest.showTestMessage(p);
            }
        });
        JButton showProgressIndicatorButton = new JButton("Show progress indicator");
        showProgressIndicatorButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Task.Modal task = new Task.Modal(null, "Test task", true){

                    public void run(@NotNull ProgressIndicator indicator) {
                        if (indicator == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        ApplicationManager.getApplication().invokeAndWait(() -> {
                            FocusManagerImpl fmi1 = FocusManagerImpl.getInstance();
                            Project p1 = fmi1.getLastFocusedFrame().getProject();
                            MacMessagesTest.showTestMessage(p1);
                        }, ModalityState.any());
                    }

                    public void onCancel() {
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/internal/validation/MacMessagesTest$3$1", "run"));
                    }
                };
                ProgressManager.getInstance().run((Task)task);
            }
        });
        cp.add(showDialogWrapperButton);
        cp.add(showMessageButton);
        cp.add(showProgressIndicatorButton);
        controlDialog.pack();
        controlDialog.setVisible(true);
    }

    private static void showTestMessage(Project p) {
        Messages.showDialog((Project)p, (String)"Test message", (String)"Test Title", (String[])new String[]{"Option one", "Option two", "Option three"}, (int)0, null);
    }

    private static class SimpleDialogWrapper
    extends DialogWrapper {
        private JTextArea jbTextField = new JTextArea(1, 30);

        SimpleDialogWrapper(@Nullable Project project2) {
            super(project2);
            this.setSize(500, 500);
            this.getWindow().setLocationRelativeTo(this.getWindow().getParent());
            this.init();
        }

        @Nullable
        public JComponent getPreferredFocusedComponent() {
            return this.jbTextField;
        }

        @Nullable
        protected JComponent createCenterPanel() {
            JPanel jPanel = new JPanel();
            jPanel.add(this.jbTextField);
            return jPanel;
        }
    }
}

