/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jarFinder;

import com.intellij.codeInsight.daemon.impl.quickfix.OrderEntryFix;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.components.JBList;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.download.DownloadableFileDescription;
import com.intellij.util.download.DownloadableFileService;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import org.cyberneko.html.parsers.DOMParser;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public abstract class FindJarFix<T extends PsiElement>
implements IntentionAction,
Iconable {
    private static final Logger LOG = Logger.getInstance(FindJarFix.class);
    private static final String CLASS_ROOT_URL = "http://findjar.com/class/";
    private static final String CLASS_PAGE_EXT = ".html";
    private static final String SERVICE_URL = "http://findjar.com";
    private static final String LINK_TAG_NAME = "a";
    private static final String LINK_ATTR_NAME = "href";
    protected final T myRef;
    protected final Module myModule;
    protected JComponent myEditorComponent;

    public FindJarFix(T ref) {
        this.myRef = ref;
        this.myModule = ModuleUtilCore.findModuleForPsiElement(ref);
    }

    @NotNull
    public String getText() {
        if ("Find JAR on web" == null) {
            FindJarFix.$$$reportNull$$$0(0);
        }
        return "Find JAR on web";
    }

    @NotNull
    public String getFamilyName() {
        if ("Family name" == null) {
            FindJarFix.$$$reportNull$$$0(1);
        }
        return "Family name";
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
        if (project2 == null) {
            FindJarFix.$$$reportNull$$$0(2);
        }
        return this.myRef.isValid() && JavaPsiFacade.getInstance((Project)project2).findClass("java.lang.Object", file2.getResolveScope()) != null && this.myModule != null && FindJarFix.isFqnsOk(project2, this.getPossibleFqns(this.myRef));
    }

    private static boolean isFqnsOk(Project project2, List<String> fqns) {
        if (fqns.isEmpty()) {
            return false;
        }
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project2);
        GlobalSearchScope scope = GlobalSearchScope.allScope((Project)project2);
        for (String fqn : fqns) {
            if (facade.findClass(fqn, scope) == null) continue;
            return false;
        }
        return true;
    }

    public void invoke(@NotNull Project project2, Editor editor, PsiFile file2) throws IncorrectOperationException {
        if (project2 == null) {
            FindJarFix.$$$reportNull$$$0(3);
        }
        List<String> fqns = this.getPossibleFqns(this.myRef);
        this.myEditorComponent = editor.getComponent();
        if (fqns.size() > 1) {
            JBList listOfFqns = new JBList(fqns);
            JBPopupFactory.getInstance().createListPopupBuilder((JList)listOfFqns).setTitle("Select Qualified Name").setItemChoosenCallback(() -> this.findJarsForFqn((String)listOfFqns.getSelectedValue(), editor)).createPopup().showInBestPositionFor(editor);
        } else if (fqns.size() == 1) {
            this.findJarsForFqn(fqns.get(0), editor);
        }
    }

    private void findJarsForFqn(final String fqn, final Editor editor) {
        final HashMap libs = new HashMap();
        final Runnable runnable2 = () -> {
            try {
                DOMParser parser = new DOMParser();
                parser.parse(CLASS_ROOT_URL + fqn.replace('.', '/') + CLASS_PAGE_EXT);
                Document doc = parser.getDocument();
                if (doc != null) {
                    NodeList links = doc.getElementsByTagName(LINK_TAG_NAME);
                    for (int i = 0; i < links.getLength(); ++i) {
                        String pathToJar;
                        Node href;
                        Node link = links.item(i);
                        String libName = link.getTextContent();
                        NamedNodeMap attributes = link.getAttributes();
                        if (attributes == null || (href = attributes.getNamedItem(LINK_ATTR_NAME)) == null || (pathToJar = href.getTextContent()) == null || !pathToJar.startsWith("/jar/") && !pathToJar.startsWith("/class/../")) continue;
                        libs.put(libName, SERVICE_URL + pathToJar);
                    }
                }
            }
            catch (IOException parser) {
            }
            catch (Exception e) {
                LOG.warn((Throwable)e);
            }
        };
        Task.Modal task = new Task.Modal(editor.getProject(), "Looking for Libraries", true){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                indicator.setIndeterminate(true);
                FindJarFix.runUncanceledRunnableWithProgress(runnable2, indicator);
            }

            public void onSuccess() {
                super.onSuccess();
                if (libs.isEmpty()) {
                    HintManager.getInstance().showInformationHint(editor, "No libraries found for '" + fqn + "'");
                } else {
                    JBList libNames = new JBList((Collection)ContainerUtil.sorted(libs.keySet()));
                    libNames.installCellRenderer(o -> new JLabel(o.toString(), PlatformIcons.JAR_ICON, 2));
                    if (libs.size() == 1) {
                        String jarName = (String)libs.keySet().iterator().next();
                        String url = (String)libs.get(jarName);
                        FindJarFix.this.initiateDownload(url, jarName);
                    } else {
                        JBPopupFactory.getInstance().createListPopupBuilder((JList)libNames).setTitle("Select a JAR file").setItemChoosenCallback(() -> {
                            String jarName = (String)libNames.getSelectedValue();
                            String url = (String)libs.get(jarName);
                            if (url != null) {
                                FindJarFix.this.initiateDownload(url, jarName);
                            }
                        }).createPopup().showInBestPositionFor(editor);
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/jarFinder/FindJarFix$1", "run"));
            }
        };
        ProgressManager.getInstance().run((Task)task);
    }

    private void initiateDownload(String url, String jarName) {
        DOMParser parser = new DOMParser();
        try {
            NodeList links;
            parser.parse(url);
            Document doc = parser.getDocument();
            if (doc != null && (links = doc.getElementsByTagName(LINK_TAG_NAME)) != null) {
                for (int i = 0; i < links.getLength(); ++i) {
                    String jarUrl;
                    Node link;
                    NamedNodeMap attributes;
                    Node item = links.item(i);
                    if (item == null || (attributes = item.getAttributes()) == null || (link = attributes.getNamedItem(LINK_ATTR_NAME)) == null || (jarUrl = link.getTextContent()) == null || !jarUrl.endsWith(jarName)) continue;
                    this.downloadJar(jarUrl, jarName);
                }
            }
        }
        catch (IOException | SAXException exception) {
            // empty catch block
        }
    }

    private static void runUncanceledRunnableWithProgress(Runnable run2, ProgressIndicator indicator) {
        Thread t = new Thread(run2, "FindJar download thread");
        t.setDaemon(true);
        t.start();
        try {
            while (t.isAlive()) {
                t.join(500L);
                indicator.checkCanceled();
            }
        }
        catch (InterruptedException e) {
            indicator.checkCanceled();
        }
    }

    private void downloadJar(String jarUrl, String jarName) {
        Project project2 = this.myModule.getProject();
        String dirPath = PropertiesComponent.getInstance((Project)project2).getValue("findjar.last.used.dir");
        VirtualFile toSelect2 = dirPath == null ? null : LocalFileSystem.getInstance().findFileByIoFile(new File(dirPath));
        FileChooserDescriptor descriptor2 = FileChooserDescriptorFactory.createSingleFolderDescriptor().withTitle("Select Path to Save Jar").withDescription("Choose where to save '" + jarName + "'");
        VirtualFile file2 = FileChooser.chooseFile((FileChooserDescriptor)descriptor2, (Project)project2, (VirtualFile)toSelect2);
        if (file2 != null) {
            PropertiesComponent.getInstance((Project)project2).setValue("findjar.last.used.dir", file2.getPath());
            DownloadableFileService downloader = DownloadableFileService.getInstance();
            DownloadableFileDescription description = downloader.createFileDescription(jarUrl, jarName);
            List jars = downloader.createDownloader(Collections.singletonList(description), jarName).downloadFilesWithProgress(file2.getPath(), project2, this.myEditorComponent);
            if (jars != null && jars.size() == 1) {
                WriteAction.run(() -> OrderEntryFix.addJarToRoots(((VirtualFile)jars.get(0)).getPresentableUrl(), this.myModule, this.myRef));
            }
        }
    }

    protected abstract Collection<String> getFqns(@NotNull T var1);

    protected List<String> getPossibleFqns(T ref) {
        Collection<String> fqns = this.getFqns(ref);
        ArrayList<String> res = new ArrayList<String>(fqns.size());
        for (String fqn : fqns) {
            String className;
            int index;
            if (fqn.startsWith("java.") || fqn.startsWith("javax.swing.") || (index = fqn.lastIndexOf(46)) == -1 || (className = fqn.substring(index + 1)).length() == 0 || Character.isLowerCase(className.charAt(0))) continue;
            res.add(fqn);
        }
        return res;
    }

    public boolean startInWriteAction() {
        return false;
    }

    public Icon getIcon(int flags) {
        return PlatformIcons.WEB_ICON;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jarFinder/FindJarFix";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jarFinder/FindJarFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

