/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jarFinder;

import com.intellij.jarFinder.FindJarFix;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiImportStatement;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiQualifiedReference;
import com.intellij.psi.PsiQualifiedReferenceElement;
import com.intellij.psi.impl.source.PsiImportStaticStatementImpl;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

public class JavaFindJarFix
extends FindJarFix<PsiQualifiedReferenceElement> {
    public JavaFindJarFix(PsiQualifiedReferenceElement ref) {
        super(ref);
    }

    @Override
    protected Collection<String> getFqns(@NotNull PsiQualifiedReferenceElement ref) {
        PsiImportList importList;
        PsiImportStatementBase importStatement;
        if (ref == null) {
            JavaFindJarFix.$$$reportNull$$$0(0);
        }
        if ((importStatement = (PsiImportStatementBase)PsiTreeUtil.getParentOfType((PsiElement)ref.getElement(), PsiImportStatementBase.class)) != null) {
            String importFQN;
            PsiJavaCodeReferenceElement classRef;
            if (importStatement instanceof PsiImportStatement) {
                String importFQN2 = ((PsiImportStatement)importStatement).getQualifiedName();
                if (importFQN2 != null && !importFQN2.endsWith("*")) {
                    return Collections.singleton(importFQN2);
                }
            } else if (importStatement instanceof PsiImportStaticStatementImpl && (classRef = ((PsiImportStaticStatementImpl)importStatement).getClassReference()) != null && (importFQN = classRef.getQualifiedName()) != null) {
                return Collections.singleton(importFQN);
            }
            return Collections.emptyList();
        }
        PsiElement qualifier = ref.getQualifier();
        if (qualifier instanceof PsiQualifiedReference) {
            return Collections.emptyList();
        }
        String className = ref.getReferenceName();
        PsiFile file2 = ref.getContainingFile().getOriginalFile();
        if (className != null && file2 instanceof PsiJavaFile && (importList = ((PsiJavaFile)file2).getImportList()) != null) {
            PsiImportStatementBase statement2 = importList.findSingleImportStatement(className);
            if (statement2 instanceof PsiImportStatement) {
                String importFQN = ((PsiImportStatement)statement2).getQualifiedName();
                if (importFQN != null) {
                    return Collections.singleton(importFQN);
                }
            } else {
                ArrayList<String> res = new ArrayList<String>();
                for (PsiImportStatementBase imp : importList.getAllImportStatements()) {
                    if (!imp.isOnDemand() || !(imp instanceof PsiImportStatement)) continue;
                    res.add(((PsiImportStatement)imp).getQualifiedName() + "." + className);
                }
                return res;
            }
        }
        return Collections.emptyList();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/jarFinder/JavaFindJarFix", "getFqns"));
    }
}

