/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jarFinder;

import com.intellij.jarFinder.SourceSearchException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.JdomKt;
import com.intellij.util.io.HttpRequests;
import java.io.IOException;
import java.io.Reader;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.jdom.Document;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SourceSearcher {
    private static final String MAVEN_POM_ENTRY_PREFIX = "META-INF/maven/";

    @Nullable
    protected String findSourceJar(@NotNull ProgressIndicator indicator, @NotNull String artifactId, @NotNull String version) throws SourceSearchException {
        if (indicator == null) {
            SourceSearcher.$$$reportNull$$$0(0);
        }
        if (artifactId == null) {
            SourceSearcher.$$$reportNull$$$0(1);
        }
        if (version == null) {
            SourceSearcher.$$$reportNull$$$0(2);
        }
        return null;
    }

    @Nullable
    protected String findSourceJar(@NotNull ProgressIndicator indicator, @NotNull String artifactId, @NotNull String version, @NotNull VirtualFile classesJar) throws SourceSearchException {
        if (indicator == null) {
            SourceSearcher.$$$reportNull$$$0(3);
        }
        if (artifactId == null) {
            SourceSearcher.$$$reportNull$$$0(4);
        }
        if (version == null) {
            SourceSearcher.$$$reportNull$$$0(5);
        }
        if (classesJar == null) {
            SourceSearcher.$$$reportNull$$$0(6);
        }
        return this.findSourceJar(indicator, artifactId, version);
    }

    @NotNull
    protected static Document readDocumentCancelable(final ProgressIndicator indicator, String url) throws IOException {
        Document document = (Document)HttpRequests.request((String)url).accept("application/xml").connect((HttpRequests.RequestProcessor)new HttpRequests.RequestProcessor<Document>(){

            public Document process(@NotNull HttpRequests.Request request) throws IOException {
                if (request == null) {
                    1.$$$reportNull$$$0(0);
                }
                return JdomKt.loadDocument((Reader)request.getReader(indicator));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/jarFinder/SourceSearcher$1", "process"));
            }
        });
        if (document == null) {
            SourceSearcher.$$$reportNull$$$0(7);
        }
        return document;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    protected static String findMavenGroupId(@NotNull VirtualFile classesJar, String artifactId) {
        if (classesJar == null) {
            SourceSearcher.$$$reportNull$$$0(8);
        }
        try {
            JarFile jarFile = new JarFile(VfsUtilCore.virtualToIoFile((VirtualFile)classesJar));
            try {
                JarEntry entry;
                String name2;
                Enumeration<JarEntry> entries = jarFile.entries();
                do {
                    if (!entries.hasMoreElements()) return null;
                } while (!StringUtil.startsWith((CharSequence)(name2 = (entry = entries.nextElement()).getName()), (CharSequence)MAVEN_POM_ENTRY_PREFIX) || !StringUtil.endsWith((CharSequence)name2, (CharSequence)("/" + artifactId + "/pom.xml")));
                int index = name2.indexOf(47, MAVEN_POM_ENTRY_PREFIX.length());
                String string = index != -1 ? name2.substring(MAVEN_POM_ENTRY_PREFIX.length(), index) : null;
                return string;
            }
            finally {
                try {
                    jarFile.close();
                }
                catch (IOException iOException) {}
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifactId";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classesJar";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jarFinder/SourceSearcher";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jarFinder/SourceSearcher";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "readDocumentCancelable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findSourceJar";
                break;
            }
            case 7: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findMavenGroupId";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

