/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jarRepository.services.nexus;

import com.intellij.jarRepository.RemoteRepositoryDescription;
import com.intellij.jarRepository.RepositoryArtifactDescription;
import com.intellij.jarRepository.services.MavenRepositoryService;
import com.intellij.jarRepository.services.nexus.ArtifactType;
import com.intellij.jarRepository.services.nexus.Endpoint;
import com.intellij.jarRepository.services.nexus.RepositoryType;
import com.intellij.jarRepository.services.nexus.SearchResults;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SmartList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.JAXBException;
import javax.xml.bind.UnmarshalException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NexusRepositoryService
extends MavenRepositoryService {
    @Nullable
    public static RemoteRepositoryDescription convertRepositoryInfo(@NotNull RepositoryType repo) {
        String id;
        if (repo == null) {
            NexusRepositoryService.$$$reportNull$$$0(0);
        }
        if ((id = repo.getId()) == null) {
            return null;
        }
        String name2 = repo.getName();
        if (name2 == null) {
            return null;
        }
        String uri = repo.getContentResourceURI();
        if (uri == null) {
            return null;
        }
        return new RemoteRepositoryDescription(id, name2, uri);
    }

    public static RepositoryArtifactDescription convertArtifactInfo(ArtifactType t) {
        return new RepositoryArtifactDescription(t.getGroupId(), t.getArtifactId(), t.getVersion(), t.getPackaging(), t.getClassifier(), null, t.getRepoId());
    }

    @Override
    @NotNull
    public String getDisplayName() {
        if ("Nexus" == null) {
            NexusRepositoryService.$$$reportNull$$$0(1);
        }
        return "Nexus";
    }

    @Override
    @NotNull
    public List<RemoteRepositoryDescription> getRepositories(@NotNull String url) throws IOException {
        SmartList smartList;
        if (url == null) {
            NexusRepositoryService.$$$reportNull$$$0(2);
        }
        try {
            List<RepositoryType> repos = new Endpoint.Repositories(url).getRepolistAsRepositories().getData().getRepositoriesItem();
            SmartList result2 = new SmartList();
            for (RepositoryType repo : repos) {
                RemoteRepositoryDescription desc;
                if (!"maven2".equals(repo.getProvider()) || (desc = NexusRepositoryService.convertRepositoryInfo(repo)) == null) continue;
                result2.add(desc);
            }
            smartList = result2;
        }
        catch (UnmarshalException e) {
            List<RemoteRepositoryDescription> list2 = Collections.emptyList();
            if (list2 == null) {
                NexusRepositoryService.$$$reportNull$$$0(4);
            }
            return list2;
        }
        catch (JAXBException e) {
            throw new IOException(e);
        }
        if (smartList == null) {
            NexusRepositoryService.$$$reportNull$$$0(3);
        }
        return smartList;
    }

    @Override
    @NotNull
    public List<RepositoryArtifactDescription> findArtifacts(@NotNull String url, @NotNull RepositoryArtifactDescription template) throws IOException {
        ArrayList<RepositoryArtifactDescription> arrayList;
        if (url == null) {
            NexusRepositoryService.$$$reportNull$$$0(5);
        }
        if (template == null) {
            NexusRepositoryService.$$$reportNull$$$0(6);
        }
        try {
            String packaging = StringUtil.notNullize((String)template.getPackaging());
            String name2 = StringUtil.join(Arrays.asList(template.getGroupId(), template.getArtifactId(), template.getVersion()), (String)":");
            SearchResults results = new Endpoint.DataIndex(url).getArtifactlistAsSearchResults(name2, template.getGroupId(), template.getArtifactId(), template.getVersion(), null, template.getClassNames());
            SearchResults.Data data = results.getData();
            ArrayList<RepositoryArtifactDescription> result2 = new ArrayList<RepositoryArtifactDescription>();
            if (data != null) {
                for (ArtifactType each : data.getArtifact()) {
                    if (!Comparing.equal((String)each.packaging, (String)packaging)) continue;
                    result2.add(NexusRepositoryService.convertArtifactInfo(each));
                }
            }
            arrayList = result2;
        }
        catch (UnmarshalException e) {
            List<RepositoryArtifactDescription> list2 = Collections.emptyList();
            if (list2 == null) {
                NexusRepositoryService.$$$reportNull$$$0(8);
            }
            return list2;
        }
        catch (JAXBException e) {
            throw new IOException(e);
        }
        if (arrayList == null) {
            NexusRepositoryService.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repo";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jarRepository/services/nexus/NexusRepositoryService";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "template";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jarRepository/services/nexus/NexusRepositoryService";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getRepositories";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "findArtifacts";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "convertRepositoryInfo";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 7: 
            case 8: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getRepositories";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findArtifacts";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

