/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jarRepository.settings;

import com.google.common.base.Strings;
import com.intellij.jarRepository.JarRepositoryManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.containers.JBIterable;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.utils.library.RepositoryLibraryDescription;
import org.jetbrains.idea.maven.utils.library.propertiesEditor.RepositoryLibraryPropertiesModel;

public class RepositoryLibraryPropertiesEditor {
    @NotNull
    private final Project project;
    State currentState;
    List<String> versions;
    @Nullable
    private VersionKind versionKind;
    private RepositoryLibraryPropertiesModel initialModel;
    private RepositoryLibraryPropertiesModel model;
    private RepositoryLibraryDescription repositoryLibraryDescription;
    private ComboBox versionKindSelector;
    private ComboBox versionSelector;
    private JPanel mainPanel;
    private JButton myReloadButton;
    private JBCheckBox downloadSourcesCheckBox;
    private JBCheckBox downloadJavaDocsCheckBox;
    private JBLabel mavenCoordinates;
    private JBCheckBox myIncludeTransitiveDepsCheckBox;
    private JPanel myPropertiesPanel;
    @NotNull
    private ModelChangeListener onChangeListener;

    public RepositoryLibraryPropertiesEditor(@Nullable Project project2, RepositoryLibraryPropertiesModel model, RepositoryLibraryDescription description) {
        this(project2, model, description, true, new ModelChangeListener(){

            @Override
            public void onChange(RepositoryLibraryPropertiesEditor editor) {
            }
        });
    }

    public RepositoryLibraryPropertiesEditor(@Nullable Project project2, final RepositoryLibraryPropertiesModel model, RepositoryLibraryDescription description, boolean allowExcludingTransitiveDependencies, final @NotNull ModelChangeListener onChangeListener) {
        if (onChangeListener == null) {
            RepositoryLibraryPropertiesEditor.$$$reportNull$$$0(0);
        }
        this.$$$setupUI$$$();
        this.initialModel = model.clone();
        this.model = model;
        this.project = project2 == null ? ProjectManager.getInstance().getDefaultProject() : project2;
        this.repositoryLibraryDescription = description;
        this.mavenCoordinates.setCopyable(true);
        this.myIncludeTransitiveDepsCheckBox.setVisible(allowExcludingTransitiveDependencies);
        this.myReloadButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RepositoryLibraryPropertiesEditor.this.reloadVersionsAsync();
            }
        });
        this.onChangeListener = new ModelChangeListener(){

            @Override
            public void onChange(RepositoryLibraryPropertiesEditor editor) {
                onChangeListener.onChange(editor);
                RepositoryLibraryPropertiesEditor.this.mavenCoordinates.setText(RepositoryLibraryPropertiesEditor.this.repositoryLibraryDescription.getMavenCoordinates(model.getVersion()));
            }
        };
        this.reloadVersionsAsync();
    }

    private static VersionKind getVersionKind(String version) {
        if (Strings.isNullOrEmpty((String)version)) {
            return VersionKind.Unselected;
        }
        if (version.equals("RELEASE")) {
            return VersionKind.Release;
        }
        if (version.equals("LATEST")) {
            return VersionKind.Latest;
        }
        return VersionKind.Select;
    }

    private static int getSelection(String selectedVersion, List<String> versions) {
        VersionKind versionKind = RepositoryLibraryPropertiesEditor.getVersionKind(selectedVersion);
        int releaseIndex = JBIterable.from(versions).takeWhile(version -> version.endsWith("-SNAPSHOT")).size();
        switch (versionKind) {
            case Unselected: {
                return -1;
            }
            case Release: {
                return releaseIndex == versions.size() ? -1 : releaseIndex;
            }
            case Latest: {
                return 0;
            }
            case Select: {
                if (versions.indexOf(selectedVersion) == -1) {
                    versions.add(0, selectedVersion);
                }
                return versions.indexOf(selectedVersion);
            }
        }
        return -1;
    }

    private void initVersionKindSelector() {
        List<String> versionKinds = Arrays.asList("Release", "Latest", "Select...");
        CollectionComboBoxModel versionKindSelectorModel = new CollectionComboBoxModel(versionKinds);
        this.versionKindSelector.setModel((ComboBoxModel)versionKindSelectorModel);
        this.versionKindSelector.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                VersionKind newVersionKind = RepositoryLibraryPropertiesEditor.this.getSelectedVersionKind();
                if (newVersionKind != RepositoryLibraryPropertiesEditor.this.versionKind) {
                    RepositoryLibraryPropertiesEditor.this.versionKind = newVersionKind;
                    RepositoryLibraryPropertiesEditor.this.versionKindChanged();
                }
            }
        });
        this.setSelectedVersionKind(RepositoryLibraryPropertiesEditor.getVersionKind(this.model.getVersion()));
    }

    private void versionKindChanged() {
        this.versionSelector.setEnabled(this.versionKind == VersionKind.Select);
        this.model.setVersion(this.getSelectedVersion());
        int selection = RepositoryLibraryPropertiesEditor.getSelection(this.model.getVersion(), this.versions);
        this.versionSelector.setSelectedIndex(selection);
        this.onChangeListener.onChange(this);
    }

    private VersionKind getSelectedVersionKind() {
        switch (this.versionKindSelector.getSelectedIndex()) {
            case 0: {
                return VersionKind.Release;
            }
            case 1: {
                return VersionKind.Latest;
            }
            case 2: {
                return VersionKind.Select;
            }
        }
        return VersionKind.Unselected;
    }

    private void setSelectedVersionKind(VersionKind versionKind) {
        this.versionSelector.setEnabled(versionKind == VersionKind.Select);
        switch (versionKind) {
            case Unselected: {
                this.versionKindSelector.setSelectedIndex(-1);
                break;
            }
            case Release: {
                this.versionKindSelector.setSelectedItem((Object)0);
                break;
            }
            case Latest: {
                this.versionKindSelector.setSelectedIndex(1);
                break;
            }
            case Select: {
                this.versionKindSelector.setSelectedIndex(2);
            }
        }
    }

    private void setState(State state) {
        this.currentState = state;
        ((CardLayout)this.myPropertiesPanel.getLayout()).show(this.myPropertiesPanel, state.name());
        this.onChangeListener.onChange(this);
    }

    private void reloadVersionsAsync() {
        this.setState(State.Loading);
        JarRepositoryManager.getAvailableVersionsAsync(this.project, this.repositoryLibraryDescription, result2 -> this.versionsLoaded(new ArrayList<String>((Collection<String>)result2)));
    }

    private void initVersionsPanel() {
        int selection = RepositoryLibraryPropertiesEditor.getSelection(this.model.getVersion(), this.versions);
        CollectionComboBoxModel versionSelectorModel = new CollectionComboBoxModel(this.versions);
        this.versionSelector.setModel((ComboBoxModel)versionSelectorModel);
        this.versionSelector.setSelectedIndex(selection);
        this.setState(State.Loaded);
        this.initVersionKindSelector();
        this.versionSelector.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                RepositoryLibraryPropertiesEditor.this.model.setVersion(RepositoryLibraryPropertiesEditor.this.getSelectedVersion());
                RepositoryLibraryPropertiesEditor.this.onChangeListener.onChange(RepositoryLibraryPropertiesEditor.this);
            }
        });
        this.downloadSourcesCheckBox.setSelected(this.model.isDownloadSources());
        this.downloadSourcesCheckBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                RepositoryLibraryPropertiesEditor.this.model.setDownloadSources(RepositoryLibraryPropertiesEditor.this.downloadSourcesCheckBox.isSelected());
                RepositoryLibraryPropertiesEditor.this.onChangeListener.onChange(RepositoryLibraryPropertiesEditor.this);
            }
        });
        this.downloadJavaDocsCheckBox.setSelected(this.model.isDownloadJavaDocs());
        this.downloadJavaDocsCheckBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                RepositoryLibraryPropertiesEditor.this.model.setDownloadJavaDocs(RepositoryLibraryPropertiesEditor.this.downloadJavaDocsCheckBox.isSelected());
                RepositoryLibraryPropertiesEditor.this.onChangeListener.onChange(RepositoryLibraryPropertiesEditor.this);
            }
        });
        this.myIncludeTransitiveDepsCheckBox.setSelected(this.model.isIncludeTransitiveDependencies());
        this.myIncludeTransitiveDepsCheckBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                RepositoryLibraryPropertiesEditor.this.model.setIncludeTransitiveDependencies(RepositoryLibraryPropertiesEditor.this.myIncludeTransitiveDepsCheckBox.isSelected());
                RepositoryLibraryPropertiesEditor.this.onChangeListener.onChange(RepositoryLibraryPropertiesEditor.this);
            }
        });
    }

    private void versionsLoaded(@Nullable List<String> versions) {
        this.versions = versions;
        if (versions == null || versions.isEmpty()) {
            this.versionsFailedToLoad();
            return;
        }
        ApplicationManager.getApplication().invokeLater(this::initVersionsPanel, ModalityState.any());
    }

    private void versionsFailedToLoad() {
        ApplicationManager.getApplication().invokeLater(() -> this.setState(State.FailedToLoad), ModalityState.any());
    }

    @Nullable
    public String getSelectedVersion() {
        if (this.versionKind == null) {
            return null;
        }
        switch (this.versionKind) {
            case Unselected: {
                return null;
            }
            case Release: {
                return "RELEASE";
            }
            case Latest: {
                return "LATEST";
            }
            case Select: {
                return (String)this.versionSelector.getSelectedItem();
            }
        }
        return null;
    }

    public JPanel getMainPanel() {
        return this.mainPanel;
    }

    public boolean isValid() {
        return this.currentState == State.Loaded;
    }

    public boolean hasChanges() {
        return !this.model.equals(this.initialModel);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "onChangeListener", "com/intellij/jarRepository/settings/RepositoryLibraryPropertiesEditor", "<init>"));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JButton jButton;
        JBCheckBox jBCheckBox;
        JBCheckBox jBCheckBox2;
        JBCheckBox jBCheckBox3;
        ComboBox comboBox;
        ComboBox comboBox2;
        JPanel jPanel;
        JBLabel jBLabel;
        JPanel jPanel2;
        this.mainPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.setMinimumSize(new Dimension(400, 128));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("Maven:");
        jPanel3.add((Component)jBLabel2, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel3.add((Component)spacer2, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.mavenCoordinates = jBLabel = new JBLabel();
        jBLabel.setOpaque(false);
        jBLabel.setRequestFocusEnabled(true);
        jBLabel.setText("");
        jPanel3.add((Component)jBLabel, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 3, null, null, null));
        this.myPropertiesPanel = jPanel = new JPanel();
        jPanel.setLayout(new CardLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel4, "Loaded");
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 5, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel5, new GridConstraints(0, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel5.add((Component)spacer3, new GridConstraints(0, 4, 1, 1, 0, 1, 6, 1, null, null, null));
        JBLabel jBLabel3 = new JBLabel();
        jBLabel3.setText("Version:");
        jBLabel3.setDisplayedMnemonic('V');
        jBLabel3.setDisplayedMnemonicIndex(0);
        jPanel5.add((Component)jBLabel3, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        this.versionSelector = comboBox2 = new ComboBox();
        jPanel5.add((Component)comboBox2, new GridConstraints(0, 2, 1, 1, 0, 0, 2, 0, null, null, null));
        this.versionKindSelector = comboBox = new ComboBox();
        jPanel5.add((Component)comboBox, new GridConstraints(0, 1, 1, 1, 0, 0, 2, 0, null, null, null));
        Spacer spacer4 = new Spacer();
        jPanel4.add((Component)spacer4, new GridConstraints(2, 0, 1, 2, 0, 2, 1, 6, null, null, null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel6, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.downloadSourcesCheckBox = jBCheckBox3 = new JBCheckBox();
        jBCheckBox3.setLabel("Download Sources");
        jBCheckBox3.setText("Download Sources");
        jBCheckBox3.setMnemonic('S');
        jBCheckBox3.setDisplayedMnemonicIndex(9);
        jPanel6.add((Component)jBCheckBox3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer5 = new Spacer();
        jPanel6.add((Component)spacer5, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        this.downloadJavaDocsCheckBox = jBCheckBox2 = new JBCheckBox();
        jBCheckBox2.setLabel("Download JavaDocs");
        jBCheckBox2.setText("Download JavaDocs");
        jBCheckBox2.setMnemonic('J');
        jBCheckBox2.setDisplayedMnemonicIndex(9);
        jPanel6.add((Component)jBCheckBox2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myIncludeTransitiveDepsCheckBox = jBCheckBox = new JBCheckBox();
        jBCheckBox.setText("Include transitive dependencies");
        jBCheckBox.setMnemonic('T');
        jBCheckBox.setDisplayedMnemonicIndex(8);
        jPanel6.add((Component)jBCheckBox, new GridConstraints(2, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel7, "Loading");
        JBLabel jBLabel4 = new JBLabel();
        jBLabel4.setInheritsPopupMenu(true);
        jBLabel4.setText("Loading available versions...");
        jBLabel4.setDisplayedMnemonic('L');
        jBLabel4.setDisplayedMnemonicIndex(0);
        jPanel7.add((Component)jBLabel4, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer6 = new Spacer();
        jPanel7.add((Component)spacer6, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        Spacer spacer7 = new Spacer();
        jPanel7.add((Component)spacer7, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout((LayoutManager)new GridLayoutManager(2, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel8, "FailedToLoad");
        JBLabel jBLabel5 = new JBLabel();
        jBLabel5.setText("Failed to load versions");
        jPanel8.add((Component)jBLabel5, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        Spacer spacer8 = new Spacer();
        jPanel8.add((Component)spacer8, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myReloadButton = jButton = new JButton();
        jButton.setText("Reload");
        jButton.setMnemonic('R');
        jButton.setDisplayedMnemonicIndex(0);
        jPanel8.add((Component)jButton, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        Spacer spacer9 = new Spacer();
        jPanel8.add((Component)spacer9, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        jBLabel3.setLabelFor((Component)comboBox);
        jBLabel4.setLabelFor((Component)comboBox2);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.mainPanel;
    }

    private static enum State {
        Loading,
        FailedToLoad,
        Loaded;

    }

    private static enum VersionKind {
        Unselected,
        Release,
        Latest,
        Select;

    }

    public static interface ModelChangeListener {
        public void onChange(RepositoryLibraryPropertiesEditor var1);
    }
}

