/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.json.surroundWith;

import com.intellij.json.JsonBundle;
import com.intellij.json.psi.JsonElementGenerator;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonPsiUtil;
import com.intellij.json.psi.JsonValue;
import com.intellij.lang.surroundWith.Surrounder;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonWithObjectLiteralSurrounder
implements Surrounder {
    public String getTemplateDescription() {
        return JsonBundle.message("surround.with.object.literal.desc", new Object[0]);
    }

    public boolean isApplicable(@NotNull PsiElement[] elements) {
        if (elements == null) {
            JsonWithObjectLiteralSurrounder.$$$reportNull$$$0(0);
        }
        return !JsonPsiUtil.isPropertyKey(elements[0]);
    }

    @Nullable
    public TextRange surroundElements(@NotNull Project project2, @NotNull Editor editor, @NotNull PsiElement[] elements) throws IncorrectOperationException {
        JsonValue newNameElement;
        if (project2 == null) {
            JsonWithObjectLiteralSurrounder.$$$reportNull$$$0(1);
        }
        if (editor == null) {
            JsonWithObjectLiteralSurrounder.$$$reportNull$$$0(2);
        }
        if (elements == null) {
            JsonWithObjectLiteralSurrounder.$$$reportNull$$$0(3);
        }
        if (!this.isApplicable(elements)) {
            return null;
        }
        JsonElementGenerator generator = new JsonElementGenerator(project2);
        PsiElement firstElement = elements[0];
        if (firstElement instanceof JsonValue) {
            assert (elements.length == 1) : "Only single JSON value can be wrapped in object literal";
            JsonObject replacement = (JsonObject)generator.createValue("{\n\"property\": " + firstElement.getText() + "\n}");
            replacement = (JsonObject)firstElement.replace((PsiElement)replacement);
            newNameElement = replacement.getPropertyList().get(0).getNameElement();
        } else {
            assert (firstElement instanceof JsonProperty);
            JsonProperty firstProperty = (JsonProperty)elements[0];
            JsonProperty lastProperty = (JsonProperty)elements[elements.length - 1];
            TextRange replacedRange = new TextRange(firstProperty.getTextOffset(), lastProperty.getTextRange().getEndOffset());
            String propertiesText = replacedRange.substring(firstProperty.getContainingFile().getText());
            if (firstProperty != lastProperty) {
                PsiElement parent = firstProperty.getParent();
                parent.deleteChildRange(firstProperty.getNextSibling(), (PsiElement)lastProperty);
            }
            JsonObject tempJsonObject = (JsonObject)generator.createValue("{\"property\": {\n" + propertiesText + "\n}}");
            JsonProperty replacement = tempJsonObject.getPropertyList().get(0);
            replacement = (JsonProperty)firstProperty.replace(replacement);
            newNameElement = replacement.getNameElement();
        }
        TextRange rangeWithQuotes = newNameElement.getTextRange();
        return new TextRange(rangeWithQuotes.getStartOffset() + 1, rangeWithQuotes.getEndOffset() - 1);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        objectArray2[1] = "com/intellij/json/surroundWith/JsonWithObjectLiteralSurrounder";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isApplicable";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "surroundElements";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

