/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.java.actions;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.lang.java.actions.CreateFieldActionBase;
import com.intellij.lang.java.actions.CreateFieldActionKt;
import com.intellij.lang.java.actions.JavaFieldRenderer;
import com.intellij.lang.jvm.actions.CreateFieldRequest;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.presentation.java.ClassPresentationUtil;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ%\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0096\u0002J$\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/lang/java/actions/CreateFieldAction;", "Lcom/intellij/lang/java/actions/CreateFieldActionBase;", "targetClass", "Lcom/intellij/psi/PsiClass;", "request", "Lcom/intellij/lang/jvm/actions/CreateFieldRequest;", "constantField", "", "(Lcom/intellij/psi/PsiClass;Lcom/intellij/lang/jvm/actions/CreateFieldRequest;Z)V", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "isAvailable", "java-impl"})
public final class CreateFieldAction
extends CreateFieldActionBase {
    private final boolean constantField;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isAvailable(@NotNull Project project2, @Nullable Editor editor, @Nullable PsiFile file2) {
        boolean canRender;
        boolean bl;
        boolean constantRequested;
        CreateFieldAction createFieldAction;
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        PsiClass psiClass = (PsiClass)this.getMyTargetClass().getElement();
        if (psiClass == null) return false;
        PsiClass targetClass = psiClass;
        if (!this.getMyRequest().isValid()) {
            return false;
        }
        String fieldName = this.getMyRequest().getFieldName();
        CreateFieldAction $receiver = createFieldAction = this;
        Collection requestedModifiers = $receiver.getMyRequest().getModifiers();
        boolean bl2 = constantRequested = $receiver.getMyRequest().getConstant() || targetClass.isInterface() || requestedModifiers.containsAll(CreateFieldActionKt.access$getConstantModifiers$p());
        if ($receiver.constantField) {
            if (!constantRequested) {
                String string;
                String string2 = string = fieldName;
                if (string2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string3 = string2.toUpperCase();
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).toUpperCase()");
                if (!Intrinsics.areEqual((Object)string3, (Object)fieldName)) return false;
            }
            bl = true;
        } else {
            if (constantRequested) return false;
            bl = true;
        }
        if (!(canRender = bl)) {
            return false;
        }
        String className = ClassPresentationUtil.getNameForClass(targetClass, false);
        this.setText(this.constantField ? QuickFixBundle.message("create.constant.from.usage.full.text", fieldName, className) : QuickFixBundle.message("create.field.from.usage.full.text", fieldName, className));
        return true;
    }

    public void invoke(@NotNull Project project2, @Nullable Editor editor, @Nullable PsiFile file2) {
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        PsiClass psiClass = (PsiClass)this.getMyTargetClass().getElement();
        if (psiClass == null) {
            return;
        }
        PsiClass targetClass = psiClass;
        boolean bl = this.getMyRequest().isValid();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        PsiClass psiClass2 = targetClass;
        Intrinsics.checkExpressionValueIsNotNull((Object)psiClass2, (String)"targetClass");
        new JavaFieldRenderer(project2, this.constantField, psiClass2, this.getMyRequest()).doRender();
    }

    public CreateFieldAction(@NotNull PsiClass targetClass, @NotNull CreateFieldRequest request, boolean constantField) {
        Intrinsics.checkParameterIsNotNull((Object)targetClass, (String)"targetClass");
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        super(targetClass, request);
        this.constantField = constantField;
    }
}

