/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.java.request;

import com.intellij.lang.java.actions.JvmPsiUtilKt;
import com.intellij.lang.java.request.CreateFieldFromJavaUsageRequest;
import com.intellij.lang.java.request.CreateFieldFromUsage;
import com.intellij.lang.java.request.CreateFromUsageUtilsKt;
import com.intellij.lang.jvm.JvmClass;
import com.intellij.lang.jvm.JvmModifier;
import com.intellij.lang.jvm.actions.CreateFieldRequest;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.psi.util.PsiUtil;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\rJ\b\u0010\u000e\u001a\u00020\u000fH\u0002J\n\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0002J\u0018\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u0011H\u0002J\b\u0010\u0018\u001a\u00020\u000fH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R*\u0010\u0007\u001a\u001e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bj\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/lang/java/request/CreateFieldRequests;", "", "myRef", "Lcom/intellij/psi/PsiReferenceExpression;", "(Lcom/intellij/psi/PsiReferenceExpression;)V", "getMyRef", "()Lcom/intellij/psi/PsiReferenceExpression;", "requests", "Ljava/util/LinkedHashMap;", "Lcom/intellij/lang/jvm/JvmClass;", "Lcom/intellij/lang/jvm/actions/CreateFieldRequest;", "Lkotlin/collections/LinkedHashMap;", "collectRequests", "", "doCollectRequests", "", "extractBaseClassFromSwitchStatement", "Lcom/intellij/psi/PsiClass;", "processClass", "target", "staticContext", "", "processHierarchy", "baseClass", "processOuterAndImported", "java-impl"})
final class CreateFieldRequests {
    private final LinkedHashMap<JvmClass, CreateFieldRequest> requests;
    @NotNull
    private final PsiReferenceExpression myRef;

    @NotNull
    public final Map<JvmClass, CreateFieldRequest> collectRequests() {
        this.doCollectRequests();
        return this.requests;
    }

    private final void doCollectRequests() {
        PsiExpression qualifier = this.myRef.getQualifierExpression();
        if (qualifier != null) {
            PsiClass instanceClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)qualifier.getType());
            if (instanceClass != null) {
                this.processHierarchy(instanceClass);
            } else {
                PsiClass staticClass;
                PsiExpression psiExpression = qualifier;
                if (!(psiExpression instanceof PsiJavaCodeReferenceElement)) {
                    psiExpression = null;
                }
                PsiJavaCodeReferenceElement psiJavaCodeReferenceElement = (PsiJavaCodeReferenceElement)psiExpression;
                Object object = psiJavaCodeReferenceElement != null ? psiJavaCodeReferenceElement.resolve() : null;
                if (!(object instanceof PsiClass)) {
                    object = null;
                }
                if ((staticClass = (PsiClass)object) != null) {
                    this.processClass((JvmClass)staticClass, true);
                }
            }
        } else {
            PsiClass baseClass = this.extractBaseClassFromSwitchStatement();
            if (baseClass != null) {
                this.processHierarchy(baseClass);
            } else {
                this.processOuterAndImported();
            }
        }
    }

    private final PsiClass extractBaseClassFromSwitchStatement() {
        PsiElement psiElement = this.myRef.getParent();
        if (!(psiElement instanceof PsiSwitchLabelStatement)) {
            psiElement = null;
        }
        PsiSwitchLabelStatement psiSwitchLabelStatement = (PsiSwitchLabelStatement)psiElement;
        if (psiSwitchLabelStatement == null) {
            return null;
        }
        PsiSwitchLabelStatement parent = psiSwitchLabelStatement;
        PsiElement $receiver$iv = (PsiElement)parent;
        PsiSwitchStatement psiSwitchStatement = (PsiSwitchStatement)PsiTreeUtilKt.parentOfType($receiver$iv, Reflection.getOrCreateKotlinClass(PsiSwitchStatement.class));
        if (psiSwitchStatement == null) {
            return null;
        }
        PsiSwitchStatement switchStatement = psiSwitchStatement;
        PsiExpression psiExpression = switchStatement.getExpression();
        return PsiUtil.resolveClassInClassTypeOnly((PsiType)(psiExpression != null ? psiExpression.getType() : null));
    }

    private final void processHierarchy(PsiClass baseClass) {
        for (PsiClass clazz : CreateFromUsageUtilsKt.hierarchy(baseClass)) {
            this.processClass((JvmClass)clazz, false);
        }
    }

    private final void processOuterAndImported() {
        boolean inStaticContext = CreateFromUsageUtilsKt.isInStaticContext((PsiExpression)this.myRef);
        for (PsiClass outerClass : CreateFromUsageUtilsKt.collectOuterClasses((PsiElement)this.myRef)) {
            this.processClass((JvmClass)outerClass, inStaticContext);
        }
        for (JvmClass imported : CreateFieldFromUsage.access$collectOnDemandImported((PsiElement)this.myRef)) {
            this.processClass(imported, true);
        }
    }

    private final void processClass(JvmClass target2, boolean staticContext) {
        JvmModifier jvmModifier;
        Collection collection;
        if (!staticContext && ArraysKt.contains((Object[])CreateFieldFromUsage.access$getSTATIC_ONLY$p(), (Object)target2.getClassKind())) {
            return;
        }
        Set modifiers = new LinkedHashSet();
        if (staticContext) {
            collection = modifiers;
            jvmModifier = JvmModifier.STATIC;
            collection.add(jvmModifier);
        }
        if (CreateFieldFromUsage.access$shouldCreateFinalField(this.myRef, target2)) {
            collection = modifiers;
            jvmModifier = JvmModifier.FINAL;
            collection.add(jvmModifier);
        }
        PsiElement $receiver$iv = (PsiElement)this.myRef;
        PsiClass ownerClass = (PsiClass)PsiTreeUtilKt.parentOfType($receiver$iv, Reflection.getOrCreateKotlinClass(PsiClass.class));
        Project project2 = this.myRef.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"myRef.project");
        JvmModifier visibility = CreateFromUsageUtilsKt.computeVisibility(project2, ownerClass, target2);
        if (visibility != null) {
            Collection $i$f$parentOfType = modifiers;
            $i$f$parentOfType.add(visibility);
        }
        boolean bl = false;
        boolean bl2 = Intrinsics.areEqual((Object)JvmPsiUtilKt.toJavaClassOrNull(target2), (Object)ownerClass);
        PsiReferenceExpression psiReferenceExpression = this.myRef;
        Collection collection2 = modifiers;
        CreateFieldFromJavaUsageRequest request = new CreateFieldFromJavaUsageRequest(psiReferenceExpression, collection2, bl, bl2);
        Map map = this.requests;
        CreateFieldFromJavaUsageRequest createFieldFromJavaUsageRequest = request;
        map.put(target2, createFieldFromJavaUsageRequest);
    }

    @NotNull
    public final PsiReferenceExpression getMyRef() {
        return this.myRef;
    }

    public CreateFieldRequests(@NotNull PsiReferenceExpression myRef) {
        Intrinsics.checkParameterIsNotNull((Object)myRef, (String)"myRef");
        this.myRef = myRef;
        this.requests = new LinkedHashMap();
    }
}

