/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.java.request;

import com.intellij.lang.java.actions.JvmPsiUtilKt;
import com.intellij.lang.jvm.JvmClass;
import com.intellij.lang.jvm.JvmClassKind;
import com.intellij.lang.jvm.JvmModifier;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.JavaCodeStyleSettings;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=2, d1={"\u00004\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0016\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u001a$\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\u00022\u0006\u0010\n\u001a\u00020\u000bH\u0000\u001a\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\r\u001a\u00020\u0002H\u0000\u001a\f\u0010\u000e\u001a\u00020\u000f*\u00020\u0010H\u0000\u001a\f\u0010\u0011\u001a\u00020\u000f*\u00020\u0010H\u0000\u001a\f\u0010\u0012\u001a\u00020\u000f*\u00020\u0010H\u0000\u00a8\u0006\u0013"}, d2={"collectOuterClasses", "", "Lcom/intellij/psi/PsiClass;", "place", "Lcom/intellij/psi/PsiElement;", "computeVisibility", "Lcom/intellij/lang/jvm/JvmModifier;", "project", "Lcom/intellij/openapi/project/Project;", "ownerClass", "targetClass", "Lcom/intellij/lang/jvm/JvmClass;", "hierarchy", "clazz", "isInStaticContext", "", "Lcom/intellij/psi/PsiExpression;", "isWithinConstructorCall", "isWithinStaticMember", "java-impl"})
public final class CreateFromUsageUtilsKt {
    public static final boolean isInStaticContext(@NotNull PsiExpression $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return CreateFromUsageUtilsKt.isWithinStaticMember($receiver) || CreateFromUsageUtilsKt.isWithinConstructorCall($receiver);
    }

    public static final boolean isWithinStaticMember(@NotNull PsiExpression $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        PsiElement $receiver$iv = (PsiElement)$receiver;
        PsiMember psiMember = (PsiMember)PsiTreeUtilKt.parentOfType($receiver$iv, Reflection.getOrCreateKotlinClass(PsiMember.class));
        return psiMember != null ? psiMember.hasModifierProperty("static") : false;
    }

    public static final boolean isWithinConstructorCall(@NotNull PsiExpression $receiver) {
        Object v3;
        Object v2;
        block8: {
            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
            PsiElement $receiver$iv = (PsiElement)$receiver;
            Object t = PsiTreeUtilKt.parentOfType($receiver$iv, Reflection.getOrCreateKotlinClass(PsiModifierListOwner.class));
            if (!(t instanceof PsiMethod)) {
                t = null;
            }
            PsiMethod psiMethod = (PsiMethod)t;
            if (psiMethod == null) {
                return false;
            }
            PsiMethod owner2 = psiMethod;
            if (!owner2.isConstructor()) {
                return false;
            }
            Sequence<PsiElement> $receiver$iv2 = PsiTreeUtilKt.parents((PsiElement)$receiver);
            for (Object element$iv : $receiver$iv2) {
                PsiElement it = (PsiElement)element$iv;
                if (!(!(it instanceof PsiExpression))) continue;
                v2 = element$iv;
                break block8;
            }
            v2 = v3 = null;
        }
        if (!(v2 instanceof PsiExpressionList)) {
            v3 = null;
        }
        PsiExpressionList psiExpressionList = v3;
        if (psiExpressionList == null) {
            return false;
        }
        PsiExpressionList parent = psiExpressionList;
        PsiElement psiElement = parent.getParent();
        if (!(psiElement instanceof PsiMethodCallExpression)) {
            psiElement = null;
        }
        PsiMethodCallExpression psiMethodCallExpression = (PsiMethodCallExpression)psiElement;
        if (psiMethodCallExpression == null) {
            return false;
        }
        PsiMethodCallExpression grandParent = psiMethodCallExpression;
        String calleText = grandParent.getMethodExpression().getText();
        return Intrinsics.areEqual((Object)calleText, (Object)"super") || Intrinsics.areEqual((Object)calleText, (Object)"this");
    }

    @Nullable
    public static final JvmModifier computeVisibility(@NotNull Project project2, @Nullable PsiClass ownerClass, @NotNull JvmClass targetClass) {
        String string;
        String setting;
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)targetClass, (String)"targetClass");
        if (Intrinsics.areEqual((Object)targetClass.getClassKind(), (Object)JvmClassKind.INTERFACE) || Intrinsics.areEqual((Object)targetClass.getClassKind(), (Object)JvmClassKind.ANNOTATION)) {
            return JvmModifier.PUBLIC;
        }
        if (ownerClass != null) {
            PsiClass psiClass;
            PsiClass javaClass;
            PsiClass psiClass2 = JvmPsiUtilKt.toJavaClassOrNull(targetClass);
            if (psiClass2 != null && (Intrinsics.areEqual((Object)(javaClass = (psiClass = psiClass2)), (Object)ownerClass) || PsiTreeUtil.isAncestor((PsiElement)((PsiElement)javaClass), (PsiElement)((PsiElement)ownerClass), (boolean)false))) {
                return JvmModifier.PRIVATE;
            }
        }
        if (Intrinsics.areEqual((Object)(setting = ((JavaCodeStyleSettings)CodeStyleSettingsManager.getSettings((Project)project2).getCustomSettings(JavaCodeStyleSettings.class)).VISIBILITY), (Object)"EscalateVisible")) {
            return null;
        }
        if (Intrinsics.areEqual((Object)setting, (Object)"packageLocal")) {
            return JvmModifier.PACKAGE_LOCAL;
        }
        String string2 = string = setting;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.toUpperCase();
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).toUpperCase()");
        return JvmModifier.valueOf((String)string3);
    }

    @NotNull
    public static final List<PsiClass> collectOuterClasses(@NotNull PsiElement place) {
        Intrinsics.checkParameterIsNotNull((Object)place, (String)"place");
        ArrayList<PsiClass> result2 = new ArrayList<PsiClass>();
        PsiElement $receiver$iv = place;
        for (PsiClass clazz : PsiTreeUtilKt.parentsOfType($receiver$iv, PsiClass.class)) {
            result2.add(clazz);
            if (!clazz.hasModifierProperty("static")) continue;
            break;
        }
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<PsiClass> hierarchy(@NotNull PsiClass clazz) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Collection collection;
        Intrinsics.checkParameterIsNotNull((Object)clazz, (String)"clazz");
        LinkedHashSet<PsiClass> result2 = new LinkedHashSet<PsiClass>();
        LinkedList<PsiClass> queue2 = new LinkedList<PsiClass>();
        queue2.add(clazz);
        while (!(collection = (Collection)queue2).isEmpty()) {
            PsiClass current = (PsiClass)queue2.removeFirst();
            if (!result2.add(current)) continue;
            Collection collection2 = queue2;
            PsiClass[] psiClassArray = current.getSupers();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiClassArray, (String)"current.supers");
            CollectionsKt.addAll((Collection)collection2, (Object[])psiClassArray);
        }
        Iterable iterable = $receiver$iv = (Iterable)result2;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            PsiClass it = (PsiClass)element$iv$iv;
            if (!(!(it instanceof PsiTypeParameter))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }
}

