/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem.impl;

import com.intellij.openapi.actionSystem.ex.ActionButtonLook;
import com.intellij.ui.Gray;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.geom.Path2D;
import javax.swing.JComponent;
import javax.swing.UIManager;

public class Win10ActionButtonLook
extends ActionButtonLook {
    @Override
    public void paintBackground(Graphics g, JComponent component, int state) {
        if (state != 0) {
            Rectangle rect = new Rectangle(component.getSize());
            JBInsets.removeFrom((Rectangle)rect, (Insets)component.getInsets());
            g.setColor(Win10ActionButtonLook.getBackgroundColorForState(state));
            g.fillRect(rect.x, rect.y, rect.width, rect.height);
        }
    }

    private static Color getBackgroundColorForState(int state) {
        switch (state) {
            case 1: {
                return Gray.xE8;
            }
            case -1: 
            case 2: {
                return Gray.xDB;
            }
        }
        return UIManager.getColor("Button.background");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintBorder(Graphics g, JComponent component, int state) {
        if (state != 0) {
            Graphics2D g2 = (Graphics2D)g.create();
            try {
                g2.setColor(Win10ActionButtonLook.getBorderColorForState(state));
                Rectangle outerRect = new Rectangle(component.getSize());
                JBInsets.removeFrom((Rectangle)outerRect, (Insets)JBUI.insets((int)1));
                Rectangle innerRect = new Rectangle(outerRect);
                JBInsets.removeFrom((Rectangle)innerRect, (Insets)JBUI.insets((int)1));
                Path2D.Double border = new Path2D.Double(0);
                border.append(outerRect, false);
                border.append(innerRect, false);
                g2.fill(border);
            }
            finally {
                g2.dispose();
            }
        }
    }

    @Override
    public Insets getInsets() {
        return JBUI.insets((int)2, (int)1);
    }

    private static Color getBorderColorForState(int state) {
        switch (state) {
            case 1: {
                return Gray.xCC;
            }
            case -1: 
            case 2: {
                return Gray.xC4;
            }
        }
        return UIManager.getColor("Button.intellij.native.borderColor");
    }
}

