/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl;

import com.intellij.codeStyle.CodeStyleFacade;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diff.DiffContent;
import com.intellij.openapi.diff.DiffContentUtil;
import com.intellij.openapi.diff.DiffViewer;
import com.intellij.openapi.diff.impl.fragments.Fragment;
import com.intellij.openapi.diff.impl.fragments.LineFragment;
import com.intellij.openapi.diff.impl.string.DiffString;
import com.intellij.openapi.diff.impl.util.FocusDiffSide;
import com.intellij.openapi.diff.impl.util.TextDiffType;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorKind;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.FrameWrapper;
import com.intellij.util.ImageLoader;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Graphics2D;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DiffUtil {
    private DiffUtil() {
    }

    public static void initDiffFrame(Project project2, @NotNull FrameWrapper frameWrapper, @NotNull DiffViewer diffPanel, JComponent mainComponent) {
        if (frameWrapper == null) {
            DiffUtil.$$$reportNull$$$0(0);
        }
        if (diffPanel == null) {
            DiffUtil.$$$reportNull$$$0(1);
        }
        frameWrapper.setComponent(mainComponent);
        frameWrapper.setProject(project2);
        frameWrapper.setImage(ImageLoader.loadFromResource((String)"/diff/Diff.png"));
        frameWrapper.setPreferredFocusedComponent(diffPanel.getPreferredFocusedComponent());
        frameWrapper.closeOnEsc();
    }

    @Nullable
    public static FocusDiffSide getFocusDiffSide(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            DiffUtil.$$$reportNull$$$0(2);
        }
        return (FocusDiffSide)FocusDiffSide.DATA_KEY.getData(dataContext);
    }

    @NotNull
    public static DiffString[] convertToLines(@NotNull String text2) {
        if (text2 == null) {
            DiffUtil.$$$reportNull$$$0(3);
        }
        DiffString[] diffStringArray = DiffString.create((String)text2).tokenize();
        if (diffStringArray == null) {
            DiffUtil.$$$reportNull$$$0(4);
        }
        return diffStringArray;
    }

    @NotNull
    public static FileType[] chooseContentTypes(@NotNull DiffContent[] contents) {
        if (contents == null) {
            DiffUtil.$$$reportNull$$$0(5);
        }
        LanguageFileType commonType = FileTypes.PLAIN_TEXT;
        for (DiffContent content : contents) {
            FileType contentType = content.getContentType();
            if (!DiffContentUtil.isTextType((FileType)contentType)) continue;
            commonType = contentType;
        }
        FileType[] result2 = new FileType[contents.length];
        for (int i = 0; i < contents.length; ++i) {
            FileType contentType = contents[i].getContentType();
            result2[i] = DiffContentUtil.isTextType((FileType)contentType) ? contentType : commonType;
        }
        if (result2 == null) {
            DiffUtil.$$$reportNull$$$0(6);
        }
        return result2;
    }

    public static boolean isWritable(@NotNull DiffContent content) {
        Document document;
        if (content == null) {
            DiffUtil.$$$reportNull$$$0(7);
        }
        return (document = content.getDocument()) != null && document.isWritable();
    }

    public static EditorEx createEditor(Document document, Project project2, boolean isViewer) {
        return DiffUtil.createEditor(document, project2, isViewer, null);
    }

    public static EditorEx createEditor(Document document, Project project2, boolean isViewer, @Nullable FileType fileType) {
        EditorFactory factory = EditorFactory.getInstance();
        EditorKind kind2 = EditorKind.DIFF;
        EditorEx editor = (EditorEx)(isViewer ? factory.createViewer(document, project2, kind2) : factory.createEditor(document, project2, kind2));
        editor.getGutterComponentEx().revalidateMarkup();
        if (fileType != null && project2 != null && !project2.isDisposed()) {
            CodeStyleFacade codeStyleFacade = CodeStyleFacade.getInstance((Project)project2);
            editor.getSettings().setTabSize(codeStyleFacade.getTabSize(fileType));
            editor.getSettings().setUseTabCharacter(codeStyleFacade.useTabCharacter(fileType));
        }
        return editor;
    }

    public static void drawBoldDottedFramingLines(@NotNull Graphics2D g, int startX, int endX, int startY, int bottomY, @NotNull Color color) {
        if (g == null) {
            DiffUtil.$$$reportNull$$$0(8);
        }
        if (color == null) {
            DiffUtil.$$$reportNull$$$0(9);
        }
        UIUtil.drawBoldDottedLine((Graphics2D)g, (int)startX, (int)endX, (int)startY, null, (Color)color, (boolean)false);
        UIUtil.drawBoldDottedLine((Graphics2D)g, (int)startX, (int)endX, (int)bottomY, null, (Color)color, (boolean)false);
    }

    public static void drawDoubleShadowedLine(@NotNull Graphics2D g, int startX, int endX, int y, @NotNull Color color) {
        if (g == null) {
            DiffUtil.$$$reportNull$$$0(10);
        }
        if (color == null) {
            DiffUtil.$$$reportNull$$$0(11);
        }
        UIUtil.drawLine((Graphics2D)g, (int)startX, (int)y, (int)endX, (int)y, null, (Color)DiffUtil.getFramingColor(color));
        UIUtil.drawLine((Graphics2D)g, (int)startX, (int)(y + 1), (int)endX, (int)(y + 1), null, (Color)color);
    }

    @Nullable
    public static Color getFramingColor(@Nullable Color backgroundColor) {
        return backgroundColor != null ? backgroundColor.darker() : null;
    }

    @NotNull
    public static TextDiffType makeTextDiffType(@NotNull LineFragment fragment) {
        if (fragment == null) {
            DiffUtil.$$$reportNull$$$0(12);
        }
        TextDiffType type2 = TextDiffType.create(fragment.getType());
        if (DiffUtil.isInlineWrapper((Fragment)fragment)) {
            TextDiffType textDiffType = TextDiffType.deriveInstanceForInlineWrapperFragment(type2);
            if (textDiffType == null) {
                DiffUtil.$$$reportNull$$$0(13);
            }
            return textDiffType;
        }
        TextDiffType textDiffType = type2;
        if (textDiffType == null) {
            DiffUtil.$$$reportNull$$$0(14);
        }
        return textDiffType;
    }

    public static boolean isInlineWrapper(@NotNull Fragment fragment) {
        if (fragment == null) {
            DiffUtil.$$$reportNull$$$0(15);
        }
        return fragment instanceof LineFragment && ((LineFragment)fragment).getChildrenIterator() != null;
    }

    private static boolean isUnknownFileType(@NotNull DiffContent diffContent) {
        if (diffContent == null) {
            DiffUtil.$$$reportNull$$$0(16);
        }
        return FileTypes.UNKNOWN.equals(diffContent.getContentType());
    }

    private static boolean isEmptyFileType(@NotNull DiffContent diffContent) {
        if (diffContent == null) {
            DiffUtil.$$$reportNull$$$0(17);
        }
        return diffContent.getContentType() == null;
    }

    public static boolean oneIsUnknown(@Nullable DiffContent content1, @Nullable DiffContent content2) {
        if (content1 == null && content2 == null) {
            return true;
        }
        if (content1 != null && content2 != null) {
            return DiffUtil.isUnknownFileType(content1) || DiffUtil.isUnknownFileType(content2) || DiffUtil.isEmptyFileType(content1) && DiffUtil.isEmptyFileType(content2);
        }
        if (content1 != null) {
            return DiffUtil.isUnknownFileType(content1) || DiffUtil.isEmptyFileType(content1);
        }
        return DiffUtil.isUnknownFileType(content2) || DiffUtil.isEmptyFileType(content2);
    }

    public static boolean isDiffEditor(@NotNull Editor editor) {
        if (editor == null) {
            DiffUtil.$$$reportNull$$$0(18);
        }
        return editor.getEditorKind() == EditorKind.DIFF;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: 
            case 13: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 6: 
            case 13: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frameWrapper";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "diffPanel";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 4: 
            case 6: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/diff/impl/DiffUtil";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contents";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "color";
                break;
            }
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fragment";
                break;
            }
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "diffContent";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/diff/impl/DiffUtil";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "convertToLines";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "chooseContentTypes";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "makeTextDiffType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "initDiffFrame";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getFocusDiffSide";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "convertToLines";
                break;
            }
            case 4: 
            case 6: 
            case 13: 
            case 14: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "chooseContentTypes";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isWritable";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "drawBoldDottedFramingLines";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "drawDoubleShadowedLine";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "makeTextDiffType";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isInlineWrapper";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isUnknownFileType";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isEmptyFileType";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isDiffEditor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 6: 
            case 13: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

