/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.incrementalMerge;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.impl.DiffLineMarkerRenderer;
import com.intellij.openapi.diff.impl.incrementalMerge.ChangeSide;
import com.intellij.openapi.diff.impl.incrementalMerge.ChangeType;
import com.intellij.openapi.diff.impl.util.GutterActionRenderer;
import com.intellij.openapi.diff.impl.util.TextDiffType;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.LineMarkerRenderer;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import java.awt.Color;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ChangeHighlighterHolder {
    private static final Logger LOG = Logger.getInstance(ChangeHighlighterHolder.class);
    static final int APPLIED_CHANGE_TRANSPARENCY = 30;
    private Editor myEditor;
    private final ArrayList<RangeHighlighter> myHighlighters = new ArrayList(3);
    private RangeHighlighter myMainHighlighter = null;
    private AnAction[] myActions;
    private RangeHighlighter[] myActionHighlighters = RangeHighlighter.EMPTY_ARRAY;

    ChangeHighlighterHolder() {
    }

    public void highlight(ChangeSide changeSide, Editor editor, ChangeType type2) {
        LOG.assertTrue(this.myEditor == null || editor == this.myEditor);
        this.removeHighlighters();
        this.myEditor = editor;
        this.setHighlighter(changeSide, type2);
    }

    private MarkupModel getMarkupModel() {
        return this.myEditor.getMarkupModel();
    }

    private void highlighterCreated(RangeHighlighter highlighter, TextAttributes attrs, boolean applied) {
        if (attrs != null) {
            Color color = attrs.getErrorStripeColor();
            if (color != null && applied) {
                color = ChangeHighlighterHolder.makeColorForApplied(color);
            }
            highlighter.setErrorStripeMarkColor(color);
        }
        this.myHighlighters.add(highlighter);
    }

    @NotNull
    private static Color makeColorForApplied(@NotNull Color color) {
        if (color == null) {
            ChangeHighlighterHolder.$$$reportNull$$$0(0);
        }
        Color color2 = new Color(color.getRed(), color.getGreen(), color.getBlue(), 30);
        if (color2 == null) {
            ChangeHighlighterHolder.$$$reportNull$$$0(1);
        }
        return color2;
    }

    @Nullable
    public RangeHighlighter addLineHighlighter(int line, int layer, TextDiffType diffType, boolean applied) {
        if (this.myEditor.getDocument().getTextLength() == 0) {
            return null;
        }
        RangeHighlighter highlighter = this.getMarkupModel().addLineHighlighter(line, layer, null);
        highlighter.setLineSeparatorColor(diffType.getTextBackground(this.myEditor));
        this.highlighterCreated(highlighter, diffType.getTextAttributes(this.myEditor), applied);
        highlighter.setLineMarkerRenderer((LineMarkerRenderer)DiffLineMarkerRenderer.createInstance(diffType));
        return highlighter;
    }

    @Nullable
    public RangeHighlighter addRangeHighlighter(int start, int end, int layer, TextDiffType type2, HighlighterTargetArea targetArea, boolean applied) {
        if (this.getMarkupModel().getDocument().getTextLength() == 0) {
            return null;
        }
        TextAttributes attributes = type2.getTextAttributes(this.myEditor);
        RangeHighlighter highlighter = this.getMarkupModel().addRangeHighlighter(start, end, layer, attributes, targetArea);
        this.highlighterCreated(highlighter, attributes, applied);
        highlighter.setLineMarkerRenderer((LineMarkerRenderer)DiffLineMarkerRenderer.createInstance(type2));
        return highlighter;
    }

    private void setHighlighter(ChangeSide changeSide, ChangeType type2) {
        this.myMainHighlighter = type2.addMarker(changeSide, this);
        this.updateActions();
    }

    public Editor getEditor() {
        return this.myEditor;
    }

    public void removeHighlighters() {
        if (this.myEditor == null) {
            LOG.assertTrue(this.myHighlighters.isEmpty());
            LOG.assertTrue(this.myMainHighlighter == null);
            return;
        }
        for (RangeHighlighter highlighter : this.myHighlighters) {
            highlighter.dispose();
        }
        this.myHighlighters.clear();
        this.removeActionHighlighters();
        this.myMainHighlighter = null;
    }

    private void removeActionHighlighters() {
        for (RangeHighlighter actionHighlighter : this.myActionHighlighters) {
            actionHighlighter.dispose();
        }
        this.myActionHighlighters = RangeHighlighter.EMPTY_ARRAY;
    }

    public void setActions(AnAction[] action) {
        this.myActions = action;
        this.updateActions();
    }

    private void updateActions() {
        this.removeActionHighlighters();
        if (this.myMainHighlighter != null && this.myActions != null && this.myActions.length > 0) {
            this.myActionHighlighters = new RangeHighlighter[this.myActions.length];
            for (int i = 0; i < this.myActionHighlighters.length; ++i) {
                RangeHighlighterEx highlighter = (RangeHighlighterEx)this.cloneMainHighlighter(this.myMainHighlighter);
                highlighter.setGutterIconRenderer(new GutterActionRenderer(this.myActions[i]));
                this.myActionHighlighters[i] = highlighter;
            }
        }
    }

    private RangeHighlighter cloneMainHighlighter(@NotNull RangeHighlighter mainHighlighter) {
        if (mainHighlighter == null) {
            ChangeHighlighterHolder.$$$reportNull$$$0(2);
        }
        return this.myEditor.getMarkupModel().addRangeHighlighter(mainHighlighter.getStartOffset(), mainHighlighter.getEndOffset(), mainHighlighter.getLayer(), null, mainHighlighter.getTargetArea());
    }

    public void updateHighlighter(ChangeSide changeSide, ChangeType type2) {
        LOG.assertTrue(this.myEditor != null);
        this.removeHighlighters();
        this.setHighlighter(changeSide, type2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "color";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/diff/impl/incrementalMerge/ChangeHighlighterHolder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mainHighlighter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/diff/impl/incrementalMerge/ChangeHighlighterHolder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "makeColorForApplied";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "makeColorForApplied";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "cloneMainHighlighter";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

