/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.incrementalMerge;

import com.intellij.openapi.diff.ex.DiffFragment;
import com.intellij.openapi.diff.impl.DiffUtil;
import com.intellij.openapi.diff.impl.incrementalMerge.ChangeHighlighterHolder;
import com.intellij.openapi.diff.impl.incrementalMerge.ChangeSide;
import com.intellij.openapi.diff.impl.util.TextDiffType;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.LineSeparatorRenderer;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.SeparatorPlacement;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChangeType {
    private static final int LAYER = 5999;
    private static final ChangeType INSERT = new ChangeType(TextDiffType.INSERT, false);
    private static final ChangeType DELETED = new ChangeType(TextDiffType.DELETED, false);
    private static final ChangeType CHANGE = new ChangeType(TextDiffType.CHANGED, false);
    static final ChangeType CONFLICT = new ChangeType(TextDiffType.CONFLICT, false);
    private final TextDiffType myDiffType;
    private final boolean myApplied;

    private ChangeType(TextDiffType diffType, boolean applied) {
        this.myApplied = applied;
        this.myDiffType = applied ? TextDiffType.deriveApplied(diffType) : diffType;
    }

    public boolean isApplied() {
        return this.myApplied;
    }

    @NotNull
    public static ChangeType deriveApplied(ChangeType type2) {
        ChangeType changeType = new ChangeType(type2.myDiffType, true);
        if (changeType == null) {
            ChangeType.$$$reportNull$$$0(0);
        }
        return changeType;
    }

    @Nullable
    public RangeHighlighter addMarker(ChangeSide changeSide, ChangeHighlighterHolder markup) {
        CharSequence text2 = changeSide.getText();
        if (text2 != null && text2.length() > 0) {
            return this.addBlock(text2, changeSide, markup, this.myDiffType);
        }
        return this.addLine(markup, changeSide.getStartLine(), this.myDiffType, SeparatorPlacement.TOP);
    }

    @NotNull
    public TextDiffType getTypeKey() {
        TextDiffType textDiffType = this.myDiffType;
        if (textDiffType == null) {
            ChangeType.$$$reportNull$$$0(1);
        }
        return textDiffType;
    }

    @NotNull
    public TextDiffType getTextDiffType() {
        TextDiffType textDiffType = this.getTypeKey();
        if (textDiffType == null) {
            ChangeType.$$$reportNull$$$0(2);
        }
        return textDiffType;
    }

    @Nullable
    private RangeHighlighter addBlock(CharSequence text2, ChangeSide changeSide, final ChangeHighlighterHolder markup, TextDiffType diffType) {
        EditorColorsScheme colorScheme = markup.getEditor().getColorsScheme();
        Color separatorColor = this.getSeparatorColor(diffType.getLegendColor(colorScheme));
        int length = text2.length();
        int start = changeSide.getStart();
        int end = start + length;
        RangeHighlighter highlighter = markup.addRangeHighlighter(start, end, 5999, diffType, HighlighterTargetArea.EXACT_RANGE, this.myApplied);
        LineSeparatorRenderer lineSeparatorRenderer = new LineSeparatorRenderer(){

            public void drawLine(Graphics g, int x1, int x2, int y) {
                Graphics2D g2 = (Graphics2D)g;
                Color color = ChangeType.this.myDiffType.getPolygonColor(markup.getEditor());
                if (color != null) {
                    if (ChangeType.this.myApplied) {
                        Rectangle bounds = g.getClipBounds();
                        if ((x1 = Math.max(x1, bounds.x)) >= x2) {
                            return;
                        }
                        UIUtil.drawBoldDottedLine((Graphics2D)g2, (int)x1, (int)x2, (int)y, null, (Color)color, (boolean)false);
                    } else {
                        UIUtil.drawLine((Graphics2D)g2, (int)x1, (int)y, (int)x2, (int)y, null, (Color)DiffUtil.getFramingColor(color));
                    }
                }
            }
        };
        if (highlighter != null) {
            highlighter.setLineSeparatorPlacement(SeparatorPlacement.TOP);
            highlighter.setLineSeparatorColor(separatorColor);
            highlighter.setLineSeparatorRenderer(lineSeparatorRenderer);
        }
        if (text2.charAt(length - 1) == '\n') {
            --end;
        }
        if ((highlighter = markup.addRangeHighlighter(start, end, 5999, TextDiffType.NONE, HighlighterTargetArea.EXACT_RANGE, this.myApplied)) != null) {
            highlighter.setLineSeparatorPlacement(SeparatorPlacement.BOTTOM);
            highlighter.setLineSeparatorColor(separatorColor);
            highlighter.setLineSeparatorRenderer(lineSeparatorRenderer);
        }
        return highlighter;
    }

    @Nullable
    private RangeHighlighter addLine(final ChangeHighlighterHolder markup, int line, final TextDiffType type2, SeparatorPlacement placement) {
        RangeHighlighter highlighter = markup.addLineHighlighter(line, 5999, type2, this.myApplied);
        if (highlighter == null) {
            return null;
        }
        highlighter.setLineSeparatorPlacement(placement);
        highlighter.setLineSeparatorRenderer(new LineSeparatorRenderer(){

            public void drawLine(Graphics g, int x1, int x2, int y) {
                Graphics2D g2 = (Graphics2D)g;
                Color color = ChangeType.this.myDiffType.getPolygonColor(markup.getEditor());
                if (color != null) {
                    if (type2.isApplied()) {
                        Rectangle bounds = g.getClipBounds();
                        if ((x1 = Math.max(x1, bounds.x)) >= x2) {
                            return;
                        }
                        UIUtil.drawBoldDottedLine((Graphics2D)g2, (int)x1, (int)x2, (int)y, null, (Color)color, (boolean)false);
                    } else {
                        DiffUtil.drawDoubleShadowedLine(g2, x1, x2, y, color);
                    }
                }
            }
        });
        return highlighter;
    }

    @NotNull
    static ChangeType fromDiffFragment(DiffFragment fragment) {
        if (fragment.getText1() == null) {
            ChangeType changeType = INSERT;
            if (changeType == null) {
                ChangeType.$$$reportNull$$$0(3);
            }
            return changeType;
        }
        if (fragment.getText2() == null) {
            ChangeType changeType = DELETED;
            if (changeType == null) {
                ChangeType.$$$reportNull$$$0(4);
            }
            return changeType;
        }
        ChangeType changeType = CHANGE;
        if (changeType == null) {
            ChangeType.$$$reportNull$$$0(5);
        }
        return changeType;
    }

    @NotNull
    static ChangeType fromRanges(@NotNull TextRange left, @NotNull TextRange right) {
        if (left == null) {
            ChangeType.$$$reportNull$$$0(6);
        }
        if (right == null) {
            ChangeType.$$$reportNull$$$0(7);
        }
        if (left.getLength() == 0) {
            ChangeType changeType = INSERT;
            if (changeType == null) {
                ChangeType.$$$reportNull$$$0(8);
            }
            return changeType;
        }
        if (right.getLength() == 0) {
            ChangeType changeType = DELETED;
            if (changeType == null) {
                ChangeType.$$$reportNull$$$0(9);
            }
            return changeType;
        }
        ChangeType changeType = CHANGE;
        if (changeType == null) {
            ChangeType.$$$reportNull$$$0(10);
        }
        return changeType;
    }

    public String toString() {
        return this.myDiffType.getDisplayName();
    }

    @NotNull
    public Color getSeparatorColor(@Nullable Color highlightColor) {
        if (this.myApplied) {
            Color color = highlightColor == null ? Color.DARK_GRAY : highlightColor.darker();
            if (color == null) {
                ChangeType.$$$reportNull$$$0(11);
            }
            return color;
        }
        Color color = Color.GRAY;
        if (color == null) {
            ChangeType.$$$reportNull$$$0(12);
        }
        return color;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 6: 
            case 7: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 6: 
            case 7: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/diff/impl/incrementalMerge/ChangeType";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "left";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "right";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "deriveApplied";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeKey";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextDiffType";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "fromDiffFragment";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/diff/impl/incrementalMerge/ChangeType";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "fromRanges";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getSeparatorColor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "fromRanges";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 6: 
            case 7: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

