/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.util;

import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.diff.DiffColors;
import com.intellij.openapi.diff.ex.DiffStatusBar;
import com.intellij.openapi.diff.impl.util.TextDiffTypeEnum;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.util.containers.Convertor;
import java.awt.Color;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextDiffType
implements DiffStatusBar.LegendTypeDescriptor {
    public static final TextDiffType INSERT = new TextDiffType(TextDiffTypeEnum.INSERT, DiffBundle.message((String)"diff.type.inserted.name", (Object[])new Object[0]), DiffColors.DIFF_INSERTED);
    public static final TextDiffType CHANGED = new TextDiffType(TextDiffTypeEnum.CHANGED, DiffBundle.message((String)"diff.type.changed.name", (Object[])new Object[0]), DiffColors.DIFF_MODIFIED);
    public static final TextDiffType DELETED = new TextDiffType(TextDiffTypeEnum.DELETED, DiffBundle.message((String)"diff.type.deleted.name", (Object[])new Object[0]), DiffColors.DIFF_DELETED);
    public static final TextDiffType CONFLICT = new TextDiffType(TextDiffTypeEnum.CONFLICT, DiffBundle.message((String)"diff.type.conflict.name", (Object[])new Object[0]), DiffColors.DIFF_CONFLICT);
    public static final TextDiffType NONE = new TextDiffType(TextDiffTypeEnum.NONE, DiffBundle.message((String)"diff.type.none.name", (Object[])new Object[0]), null);
    public static final List<TextDiffType> DIFF_TYPES = Arrays.asList(DELETED, CHANGED, INSERT);
    public static final List<TextDiffType> MERGE_TYPES = Arrays.asList(DELETED, CHANGED, INSERT, CONFLICT);
    public static final Convertor<TextDiffType, TextAttributesKey> ATTRIBUTES_KEY = textDiffType -> textDiffType.getAttributesKey();
    private static final double MIDDLE_COLOR_FACTOR = 0.6;
    private final TextDiffTypeEnum myType;
    private final TextAttributesKey myAttributesKey;
    private final String myDisplayName;
    private final boolean myApplied;
    private final boolean myInlineWrapper;

    public boolean isApplied() {
        return this.myApplied;
    }

    public boolean isInlineWrapper() {
        return this.myInlineWrapper;
    }

    @NotNull
    public static TextDiffType create(@Nullable TextDiffTypeEnum type2) {
        if (TextDiffTypeEnum.INSERT.equals((Object)type2)) {
            TextDiffType textDiffType = INSERT;
            if (textDiffType == null) {
                TextDiffType.$$$reportNull$$$0(0);
            }
            return textDiffType;
        }
        if (TextDiffTypeEnum.CHANGED.equals((Object)type2)) {
            TextDiffType textDiffType = CHANGED;
            if (textDiffType == null) {
                TextDiffType.$$$reportNull$$$0(1);
            }
            return textDiffType;
        }
        if (TextDiffTypeEnum.DELETED.equals((Object)type2)) {
            TextDiffType textDiffType = DELETED;
            if (textDiffType == null) {
                TextDiffType.$$$reportNull$$$0(2);
            }
            return textDiffType;
        }
        if (TextDiffTypeEnum.CONFLICT.equals((Object)type2)) {
            TextDiffType textDiffType = CONFLICT;
            if (textDiffType == null) {
                TextDiffType.$$$reportNull$$$0(3);
            }
            return textDiffType;
        }
        TextDiffType textDiffType = NONE;
        if (textDiffType == null) {
            TextDiffType.$$$reportNull$$$0(4);
        }
        return textDiffType;
    }

    @NotNull
    public static TextDiffType deriveApplied(@NotNull TextDiffType source) {
        if (source == null) {
            TextDiffType.$$$reportNull$$$0(5);
        }
        TextDiffType textDiffType = new TextDiffType(source.myType, source.myDisplayName, source.myAttributesKey, true, false);
        if (textDiffType == null) {
            TextDiffType.$$$reportNull$$$0(6);
        }
        return textDiffType;
    }

    public static TextDiffType deriveInstanceForInlineWrapperFragment(@NotNull TextDiffType source) {
        if (source == null) {
            TextDiffType.$$$reportNull$$$0(7);
        }
        return new TextDiffType(source.myType, source.myDisplayName, source.myAttributesKey, source.myApplied, true);
    }

    private TextDiffType(TextDiffTypeEnum type2, String displayName, TextAttributesKey attributesKey) {
        this(type2, displayName, attributesKey, false, false);
    }

    private TextDiffType(TextDiffTypeEnum type2, String displayName, TextAttributesKey attributesKey, boolean applied, boolean inlineWrapper) {
        this.myType = type2;
        this.myAttributesKey = attributesKey;
        this.myDisplayName = displayName;
        this.myApplied = applied;
        this.myInlineWrapper = inlineWrapper;
    }

    @Override
    public String getDisplayName() {
        return this.myDisplayName;
    }

    @Override
    @Nullable
    public Color getLegendColor(EditorColorsScheme colorScheme) {
        TextAttributes attributes = colorScheme.getAttributes(this.myAttributesKey);
        return attributes != null ? attributes.getBackgroundColor() : null;
    }

    public TextAttributesKey getAttributesKey() {
        return this.myAttributesKey;
    }

    @Nullable
    public TextAttributes getTextAttributes(@NotNull EditorColorsScheme scheme2) {
        if (scheme2 == null) {
            TextDiffType.$$$reportNull$$$0(8);
        }
        return scheme2.getAttributes(this.myAttributesKey);
    }

    @Nullable
    public Color getPolygonColor(Editor editor) {
        if (this.isApplied()) {
            return this.getLegendColor(editor.getColorsScheme());
        }
        if (this.isInlineWrapper()) {
            return this.getBgColorForFragmentContainingInlines((EditorEx)editor);
        }
        TextAttributes attributes = this.getTextAttributes(editor);
        return attributes == null ? null : attributes.getBackgroundColor();
    }

    @Nullable
    public TextAttributes getTextAttributes(@NotNull Editor editor) {
        TextAttributes originalAttrs;
        if (editor == null) {
            TextDiffType.$$$reportNull$$$0(9);
        }
        if ((originalAttrs = this.getTextAttributes(editor.getColorsScheme())) == null) {
            return null;
        }
        TextAttributes overridingAttributes = new TextAttributes();
        if (this.myApplied) {
            overridingAttributes.setBackgroundColor(((EditorEx)editor).getBackgroundColor());
        } else if (this.myInlineWrapper) {
            overridingAttributes.setBackgroundColor(this.getBgColorForFragmentContainingInlines((EditorEx)editor));
        }
        return TextAttributes.merge((TextAttributes)originalAttrs, (TextAttributes)overridingAttributes);
    }

    @Nullable
    public Color getTextBackground(Editor editor) {
        TextAttributes attributes = this.getTextAttributes(editor);
        return attributes != null ? attributes.getBackgroundColor() : null;
    }

    public String toString() {
        return this.myApplied ? this.myDisplayName + "_applied" : this.myDisplayName;
    }

    public TextDiffTypeEnum getType() {
        return this.myType;
    }

    @Nullable
    private Color getBgColorForFragmentContainingInlines(@NotNull EditorEx editor) {
        TextAttributes originalAttrs;
        if (editor == null) {
            TextDiffType.$$$reportNull$$$0(10);
        }
        if ((originalAttrs = this.getTextAttributes(editor.getColorsScheme())) == null) {
            return null;
        }
        Color fg = originalAttrs.getBackgroundColor();
        if (fg == null) {
            return null;
        }
        Color bg = editor.getBackgroundColor();
        return TextDiffType.getMiddleColor(fg, bg, 0.6);
    }

    @NotNull
    private static Color getMiddleColor(Color fg, Color bg, double factor) {
        int red = TextDiffType.avg(fg.getRed(), bg.getRed(), factor);
        int green = TextDiffType.avg(fg.getGreen(), bg.getGreen(), factor);
        int blue = TextDiffType.avg(fg.getBlue(), bg.getBlue(), factor);
        Color color = new Color(red, green, blue);
        if (color == null) {
            TextDiffType.$$$reportNull$$$0(11);
        }
        return color;
    }

    private static int avg(int fg, int bg, double factor) {
        return (int)((long)fg + Math.round(factor * (double)(bg - fg)));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/diff/impl/util/TextDiffType";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scheme";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/diff/impl/util/TextDiffType";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "deriveApplied";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getMiddleColor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "deriveApplied";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "deriveInstanceForInlineWrapperFragment";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getTextAttributes";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getBgColorForFragmentContainingInlines";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

