/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.find.FindManager;
import com.intellij.find.FindModel;
import com.intellij.find.FindResult;
import com.intellij.find.FindUtil;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.actionSystem.EditorAction;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actions.SelectOccurrencesActionHandler;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SelectNextOccurrenceAction
extends EditorAction {
    protected SelectNextOccurrenceAction() {
        super((EditorActionHandler)new Handler());
    }

    static class Handler
    extends SelectOccurrencesActionHandler {
        Handler() {
        }

        public boolean isEnabledForCaret(@NotNull Editor editor, @NotNull Caret caret, DataContext dataContext) {
            if (editor == null) {
                Handler.$$$reportNull$$$0(0);
            }
            if (caret == null) {
                Handler.$$$reportNull$$$0(1);
            }
            return editor.getProject() != null && editor.getCaretModel().supportsMultipleCarets();
        }

        public void doExecute(@NotNull Editor editor, @Nullable Caret c, DataContext dataContext) {
            if (editor == null) {
                Handler.$$$reportNull$$$0(2);
            }
            Caret caret = c == null ? editor.getCaretModel().getPrimaryCaret() : c;
            TextRange wordSelectionRange = Handler.getSelectionRange(editor, caret);
            boolean notFoundPreviously = Handler.getAndResetNotFoundStatus(editor);
            boolean wholeWordSearch = Handler.isWholeWordSearch(editor);
            if (caret.hasSelection()) {
                Project project2 = editor.getProject();
                String selectedText = caret.getSelectedText();
                if (project2 == null || selectedText == null) {
                    return;
                }
                FindManager findManager = FindManager.getInstance((Project)project2);
                FindModel model = Handler.getFindModel(selectedText, wholeWordSearch);
                findManager.setSelectNextOccurrenceWasPerformed();
                findManager.setFindNextModel(model);
                int searchStartOffset = notFoundPreviously ? 0 : caret.getSelectionEnd();
                FindResult findResult = findManager.findString(editor.getDocument().getCharsSequence(), searchStartOffset, model);
                if (findResult.isStringFound()) {
                    boolean caretAdded = FindUtil.selectSearchResultInEditor(editor, findResult, caret.getOffset() - caret.getSelectionStart());
                    if (!caretAdded && notFoundPreviously) {
                        Handler.setNotFoundStatus(editor);
                    }
                } else {
                    Handler.setNotFoundStatus(editor);
                    Handler.showHint(editor);
                }
            } else {
                if (wordSelectionRange == null) {
                    return;
                }
                Handler.setSelection(editor, caret, wordSelectionRange);
                Handler.setWholeWordSearch(editor, true);
            }
            editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "caret";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/editor/actions/SelectNextOccurrenceAction$Handler";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isEnabledForCaret";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "doExecute";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

