/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.colors.impl;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.configurationStore.BundledSchemeEP;
import com.intellij.configurationStore.LazySchemeProcessor;
import com.intellij.configurationStore.SchemeDataHolder;
import com.intellij.configurationStore.SchemeExtensionProvider;
import com.intellij.ide.WelcomeWizardUtil;
import com.intellij.ide.ui.LafManager;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.impl.ApplicationImpl;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.EditorColorsListener;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.colors.ex.DefaultColorSchemesManager;
import com.intellij.openapi.editor.colors.impl.AbstractColorsScheme;
import com.intellij.openapi.editor.colors.impl.AdditionalTextAttributesEP;
import com.intellij.openapi.editor.colors.impl.DefaultColorsScheme;
import com.intellij.openapi.editor.colors.impl.EditorColorSchemesComparator;
import com.intellij.openapi.editor.colors.impl.EditorColorsSchemeImpl;
import com.intellij.openapi.editor.colors.impl.ReadOnlyColorsScheme;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.options.SchemeManager;
import com.intellij.openapi.options.SchemeManagerFactory;
import com.intellij.openapi.options.SchemeState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ComponentTreeEventDispatcher;
import com.intellij.util.JdomKt;
import com.intellij.util.io.URLUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.xmlb.annotations.OptionTag;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@com.intellij.openapi.components.State(name="EditorColorsManagerImpl", storages={@Storage(value="colors.scheme.xml")}, additionalExportFile="colors")
public class EditorColorsManagerImpl
extends EditorColorsManager
implements PersistentStateComponent<State> {
    private static final Logger LOG = Logger.getInstance(EditorColorsManagerImpl.class);
    private static final ExtensionPointName<BundledSchemeEP> BUNDLED_EP_NAME = ExtensionPointName.create((String)"com.intellij.bundledColorScheme");
    private final ComponentTreeEventDispatcher<EditorColorsListener> myTreeDispatcher;
    private final DefaultColorSchemesManager myDefaultColorSchemeManager;
    private final SchemeManager<EditorColorsScheme> mySchemeManager;
    static final String FILE_SPEC = "colors";
    private State myState;

    public EditorColorsManagerImpl(@NotNull DefaultColorSchemesManager defaultColorSchemeManager, @NotNull SchemeManagerFactory schemeManagerFactory) {
        if (defaultColorSchemeManager == null) {
            EditorColorsManagerImpl.$$$reportNull$$$0(0);
        }
        if (schemeManagerFactory == null) {
            EditorColorsManagerImpl.$$$reportNull$$$0(1);
        }
        this.myTreeDispatcher = ComponentTreeEventDispatcher.create(EditorColorsListener.class);
        this.myState = new State();
        this.myDefaultColorSchemeManager = defaultColorSchemeManager;
        class EditorColorSchemeProcessor
        extends LazySchemeProcessor<EditorColorsScheme, EditorColorsSchemeImpl>
        implements SchemeExtensionProvider {
            EditorColorSchemeProcessor() {
            }

            @Override
            @NotNull
            public EditorColorsSchemeImpl createScheme(@NotNull SchemeDataHolder<? super EditorColorsSchemeImpl> dataHolder, @NotNull String name2, @NotNull Function<String, String> attributeProvider2, boolean isBundled) {
                if (dataHolder == null) {
                    EditorColorSchemeProcessor.$$$reportNull$$$0(0);
                }
                if (name2 == null) {
                    EditorColorSchemeProcessor.$$$reportNull$$$0(1);
                }
                if (attributeProvider2 == null) {
                    EditorColorSchemeProcessor.$$$reportNull$$$0(2);
                }
                EditorColorsSchemeImpl scheme2 = isBundled ? new BundledScheme() : new EditorColorsSchemeImpl(null);
                scheme2.readExternal(dataHolder.read());
                if (isBundled) {
                    scheme2.optimizeAttributeMap();
                }
                EditorColorsSchemeImpl editorColorsSchemeImpl = scheme2;
                if (editorColorsSchemeImpl == null) {
                    EditorColorSchemeProcessor.$$$reportNull$$$0(3);
                }
                return editorColorsSchemeImpl;
            }

            @Override
            @NotNull
            public SchemeState getState(@NotNull EditorColorsScheme scheme2) {
                if (scheme2 == null) {
                    EditorColorSchemeProcessor.$$$reportNull$$$0(4);
                }
                SchemeState schemeState = scheme2 instanceof ReadOnlyColorsScheme ? SchemeState.NON_PERSISTENT : SchemeState.POSSIBLY_CHANGED;
                if (schemeState == null) {
                    EditorColorSchemeProcessor.$$$reportNull$$$0(5);
                }
                return schemeState;
            }

            @Override
            public void onCurrentSchemeSwitched(@Nullable EditorColorsScheme oldScheme, @Nullable EditorColorsScheme newScheme) {
                LafManager.getInstance().updateUI();
                EditorColorsManagerImpl.this.schemeChangedOrSwitched(newScheme);
            }

            @Override
            @NotNull
            @NonNls
            public String getSchemeExtension() {
                if (".icls" == null) {
                    EditorColorSchemeProcessor.$$$reportNull$$$0(6);
                }
                return ".icls";
            }

            @Override
            public boolean isSchemeEqualToBundled(@NotNull EditorColorsSchemeImpl scheme2) {
                if (scheme2 == null) {
                    EditorColorSchemeProcessor.$$$reportNull$$$0(7);
                }
                if (!scheme2.getName().startsWith("_@user_")) {
                    return false;
                }
                AbstractColorsScheme bundledScheme = (AbstractColorsScheme)EditorColorsManagerImpl.this.mySchemeManager.findSchemeByName(scheme2.getName().substring("_@user_".length()));
                if (bundledScheme == null) {
                    return false;
                }
                return scheme2.settingsEqual(bundledScheme);
            }

            @Override
            public void reloaded(@NotNull SchemeManager<EditorColorsScheme> schemeManager2, @NotNull Collection<? extends EditorColorsScheme> schemes) {
                if (schemeManager2 == null) {
                    EditorColorSchemeProcessor.$$$reportNull$$$0(8);
                }
                if (schemes == null) {
                    EditorColorSchemeProcessor.$$$reportNull$$$0(9);
                }
                EditorColorsManagerImpl.this.initEditableDefaultSchemesCopies();
                EditorColorsManagerImpl.this.initEditableBundledSchemesCopies();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 3: 
                    case 5: 
                    case 6: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 3: 
                    case 5: 
                    case 6: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "dataHolder";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "name";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "attributeProvider";
                        break;
                    }
                    case 3: 
                    case 5: 
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/openapi/editor/colors/impl/EditorColorsManagerImpl$1EditorColorSchemeProcessor";
                        break;
                    }
                    case 4: 
                    case 7: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "scheme";
                        break;
                    }
                    case 8: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "schemeManager";
                        break;
                    }
                    case 9: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "schemes";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/openapi/editor/colors/impl/EditorColorsManagerImpl$1EditorColorSchemeProcessor";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createScheme";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getState";
                        break;
                    }
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getSchemeExtension";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "createScheme";
                        break;
                    }
                    case 3: 
                    case 5: 
                    case 6: {
                        break;
                    }
                    case 4: {
                        objectArray = objectArray;
                        objectArray[2] = "getState";
                        break;
                    }
                    case 7: {
                        objectArray = objectArray;
                        objectArray[2] = "isSchemeEqualToBundled";
                        break;
                    }
                    case 8: 
                    case 9: {
                        objectArray = objectArray;
                        objectArray[2] = "reloaded";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 3: 
                    case 5: 
                    case 6: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }
        this.mySchemeManager = schemeManagerFactory.create(FILE_SPEC, new EditorColorSchemeProcessor());
        this.initDefaultSchemes();
        this.loadBundledSchemes();
        this.mySchemeManager.loadSchemes();
        String wizardEditorScheme = WelcomeWizardUtil.getWizardEditorScheme();
        EditorColorsScheme scheme2 = null;
        if (wizardEditorScheme != null) {
            scheme2 = this.getScheme(wizardEditorScheme);
            LOG.assertTrue(scheme2 != null, (Object)("Wizard scheme " + wizardEditorScheme + " not found"));
        }
        this.initEditableDefaultSchemesCopies();
        this.initEditableBundledSchemesCopies();
        this.resolveLinksToBundledSchemes();
        this.setGlobalSchemeInner(scheme2 == null ? this.getDefaultScheme() : scheme2);
    }

    private void initDefaultSchemes() {
        for (DefaultColorsScheme defaultScheme : this.myDefaultColorSchemeManager.getAllSchemes()) {
            this.mySchemeManager.addScheme(defaultScheme);
        }
        this.loadAdditionalTextAttributes();
    }

    private void initEditableDefaultSchemesCopies() {
        for (DefaultColorsScheme defaultScheme : this.myDefaultColorSchemeManager.getAllSchemes()) {
            if (!defaultScheme.hasEditableCopy()) continue;
            this.createEditableCopy(defaultScheme, defaultScheme.getEditableCopyName());
        }
    }

    private void loadBundledSchemes() {
        if (!EditorColorsManagerImpl.isUnitTestOrHeadlessMode()) {
            for (BundledSchemeEP ep : (BundledSchemeEP[])BUNDLED_EP_NAME.getExtensions()) {
                this.mySchemeManager.loadBundledScheme(ep.getPath() + ".xml", (Object)ep);
            }
        }
    }

    private void initEditableBundledSchemesCopies() {
        for (EditorColorsScheme scheme2 : this.mySchemeManager.getAllSchemes()) {
            if (!(scheme2 instanceof BundledScheme)) continue;
            this.createEditableCopy((BundledScheme)scheme2, "_@user_" + scheme2.getName());
        }
    }

    private void resolveLinksToBundledSchemes() {
        for (EditorColorsScheme scheme2 : this.mySchemeManager.getAllSchemes()) {
            if (!(scheme2 instanceof AbstractColorsScheme) || scheme2 instanceof ReadOnlyColorsScheme) continue;
            try {
                ((AbstractColorsScheme)scheme2).resolveParent(name2 -> this.mySchemeManager.findSchemeByName((String)name2));
            }
            catch (InvalidDataException e) {
                String message2 = "Color scheme '" + scheme2.getName() + "' points to incorrect or non-existent default (base) scheme " + e.getMessage();
                Notifications.Bus.notify((Notification)new Notification("System Messages", "Incompatible color scheme", message2, NotificationType.ERROR));
            }
        }
    }

    private void createEditableCopy(@NotNull AbstractColorsScheme initialScheme, @NotNull String editableCopyName) {
        AbstractColorsScheme editableCopy;
        if (initialScheme == null) {
            EditorColorsManagerImpl.$$$reportNull$$$0(2);
        }
        if (editableCopyName == null) {
            EditorColorsManagerImpl.$$$reportNull$$$0(3);
        }
        if ((editableCopy = (AbstractColorsScheme)this.getScheme(editableCopyName)) == null) {
            editableCopy = (AbstractColorsScheme)initialScheme.clone();
            editableCopy.setName(editableCopyName);
            this.mySchemeManager.addScheme(editableCopy);
        }
        editableCopy.setCanBeDeleted(false);
    }

    @Deprecated
    public static void schemeChangedOrSwitched() {
        EditorColorsManagerImpl manager = (EditorColorsManagerImpl)EditorColorsManagerImpl.getInstance();
        manager.schemeChangedOrSwitched(manager.getGlobalScheme());
    }

    public void schemeChangedOrSwitched(@Nullable EditorColorsScheme newScheme) {
        for (Project project2 : ProjectManager.getInstance().getOpenProjects()) {
            DaemonCodeAnalyzer.getInstance((Project)project2).restart();
        }
        ((EditorColorsListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(TOPIC)).globalSchemeChange(newScheme);
        ((EditorColorsListener)this.myTreeDispatcher.getMulticaster()).globalSchemeChange(newScheme);
    }

    private static boolean isUnitTestOrHeadlessMode() {
        return ApplicationManager.getApplication().isUnitTestMode() || ApplicationManager.getApplication().isHeadlessEnvironment();
    }

    public TextAttributes getDefaultAttributes(TextAttributesKey key2) {
        boolean dark = UIUtil.isUnderDarcula() && this.getScheme("Darcula") != null;
        return this.getScheme(dark ? "Darcula" : "Default").getAttributes(key2);
    }

    private void loadAdditionalTextAttributes() {
        for (AdditionalTextAttributesEP attributesEP : (AdditionalTextAttributesEP[])AdditionalTextAttributesEP.EP_NAME.getExtensions()) {
            EditorColorsScheme editorColorsScheme = this.mySchemeManager.findSchemeByName(attributesEP.scheme);
            if (editorColorsScheme == null) {
                if (EditorColorsManagerImpl.isUnitTestOrHeadlessMode()) continue;
                LOG.warn("Cannot find scheme: " + attributesEP.scheme + " from plugin: " + attributesEP.getPluginDescriptor().getPluginId());
                continue;
            }
            URL resource = attributesEP.getLoaderForClass().getResource(attributesEP.file);
            if (resource == null) {
                LOG.warn("resource not found: " + attributesEP.file);
                continue;
            }
            try {
                ((AbstractColorsScheme)editorColorsScheme).readAttributes(JdomKt.loadElement((InputStream)URLUtil.openStream((URL)resource)));
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }
    }

    public void addColorsScheme(@NotNull EditorColorsScheme scheme2) {
        if (scheme2 == null) {
            EditorColorsManagerImpl.$$$reportNull$$$0(4);
        }
        if (!this.isDefaultScheme(scheme2) && !StringUtil.isEmpty((String)scheme2.getName())) {
            this.mySchemeManager.addScheme(scheme2);
        }
    }

    public void removeAllSchemes() {
    }

    public void setSchemes(@NotNull List<EditorColorsScheme> schemes) {
        if (schemes == null) {
            EditorColorsManagerImpl.$$$reportNull$$$0(5);
        }
        this.mySchemeManager.setSchemes(schemes);
    }

    @NotNull
    public EditorColorsScheme[] getAllSchemes() {
        EditorColorsScheme[] result2 = EditorColorsManagerImpl.getAllVisibleSchemes(this.mySchemeManager.getAllSchemes());
        Arrays.sort(result2, EditorColorSchemesComparator.INSTANCE);
        if (result2 == null) {
            EditorColorsManagerImpl.$$$reportNull$$$0(6);
        }
        return result2;
    }

    private static EditorColorsScheme[] getAllVisibleSchemes(@NotNull Collection<EditorColorsScheme> schemes) {
        if (schemes == null) {
            EditorColorsManagerImpl.$$$reportNull$$$0(7);
        }
        ArrayList<EditorColorsScheme> visibleSchemes = new ArrayList<EditorColorsScheme>(schemes.size() - 1);
        for (EditorColorsScheme scheme2 : schemes) {
            if (!AbstractColorsScheme.isVisible(scheme2)) continue;
            visibleSchemes.add(scheme2);
        }
        return visibleSchemes.toArray(new EditorColorsScheme[visibleSchemes.size()]);
    }

    public void setGlobalScheme(@Nullable EditorColorsScheme scheme2) {
        Application application = ApplicationManager.getApplication();
        boolean notify = application instanceof ApplicationImpl && ((ApplicationImpl)application).isLoaded();
        this.mySchemeManager.setCurrent(scheme2 == null ? this.getDefaultScheme() : scheme2, notify);
    }

    private void setGlobalSchemeInner(@Nullable EditorColorsScheme scheme2) {
        this.mySchemeManager.setCurrent(scheme2 == null ? this.getDefaultScheme() : scheme2, false);
    }

    @NotNull
    private EditorColorsScheme getDefaultScheme() {
        DefaultColorsScheme defaultScheme = this.myDefaultColorSchemeManager.getFirstScheme();
        String editableCopyName = defaultScheme.getEditableCopyName();
        EditorColorsScheme editableCopy = this.getScheme(editableCopyName);
        assert (editableCopy != null) : "An editable copy of " + defaultScheme.getName() + " has not been initialized.";
        EditorColorsScheme editorColorsScheme = editableCopy;
        if (editorColorsScheme == null) {
            EditorColorsManagerImpl.$$$reportNull$$$0(8);
        }
        return editorColorsScheme;
    }

    @NotNull
    public EditorColorsScheme getGlobalScheme() {
        EditorColorsScheme editableCopy;
        EditorColorsScheme scheme2 = this.mySchemeManager.getCurrentScheme();
        String editableCopyName = null;
        if (scheme2 instanceof DefaultColorsScheme && ((DefaultColorsScheme)scheme2).hasEditableCopy()) {
            editableCopyName = ((DefaultColorsScheme)scheme2).getEditableCopyName();
        } else if (scheme2 instanceof BundledScheme) {
            editableCopyName = "_@user_" + scheme2.getName();
        }
        if (editableCopyName != null && (editableCopy = this.getScheme(editableCopyName)) != null) {
            EditorColorsScheme editorColorsScheme = editableCopy;
            if (editorColorsScheme == null) {
                EditorColorsManagerImpl.$$$reportNull$$$0(9);
            }
            return editorColorsScheme;
        }
        EditorColorsScheme editorColorsScheme = scheme2 == null ? this.getDefaultScheme() : scheme2;
        if (editorColorsScheme == null) {
            EditorColorsManagerImpl.$$$reportNull$$$0(10);
        }
        return editorColorsScheme;
    }

    public EditorColorsScheme getScheme(@NotNull String schemeName) {
        if (schemeName == null) {
            EditorColorsManagerImpl.$$$reportNull$$$0(11);
        }
        return this.mySchemeManager.findSchemeByName(schemeName);
    }

    public void setUseOnlyMonospacedFonts(boolean value2) {
        this.myState.USE_ONLY_MONOSPACED_FONTS = value2;
    }

    public boolean isUseOnlyMonospacedFonts() {
        return this.myState.USE_ONLY_MONOSPACED_FONTS;
    }

    @Nullable
    public State getState() {
        String currentSchemeName = this.mySchemeManager.getCurrentSchemeName();
        if (currentSchemeName != null) {
            this.myState.colorScheme = "Default".equals(currentSchemeName) || "_@user_Default".equals(currentSchemeName) ? null : currentSchemeName;
        }
        return this.myState;
    }

    public void loadState(State state) {
        this.myState = state;
        this.setGlobalSchemeInner(this.myState.colorScheme == null ? this.getDefaultScheme() : this.mySchemeManager.findSchemeByName(this.myState.colorScheme));
    }

    public boolean isDefaultScheme(EditorColorsScheme scheme2) {
        return scheme2 instanceof DefaultColorsScheme;
    }

    @NotNull
    public EditorColorsScheme getSchemeForCurrentUITheme() {
        EditorColorsScheme editableCopy;
        String schemeName = UIUtil.isUnderDarcula() ? "Darcula" : "Default";
        EditorColorsScheme scheme2 = this.myDefaultColorSchemeManager.getScheme(schemeName);
        assert (scheme2 != null) : "The default scheme '" + schemeName + "' not found, available schemes: " + Arrays.toString(this.myDefaultColorSchemeManager.listNames());
        if (((DefaultColorsScheme)scheme2).hasEditableCopy() && (editableCopy = this.getScheme(((DefaultColorsScheme)scheme2).getEditableCopyName())) != null) {
            EditorColorsScheme editorColorsScheme = editableCopy;
            if (editorColorsScheme == null) {
                EditorColorsManagerImpl.$$$reportNull$$$0(12);
            }
            return editorColorsScheme;
        }
        EditorColorsScheme editorColorsScheme = scheme2;
        if (editorColorsScheme == null) {
            EditorColorsManagerImpl.$$$reportNull$$$0(13);
        }
        return editorColorsScheme;
    }

    @NotNull
    public SchemeManager<EditorColorsScheme> getSchemeManager() {
        SchemeManager<EditorColorsScheme> schemeManager2 = this.mySchemeManager;
        if (schemeManager2 == null) {
            EditorColorsManagerImpl.$$$reportNull$$$0(14);
        }
        return schemeManager2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultColorSchemeManager";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schemeManagerFactory";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initialScheme";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editableCopyName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scheme";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schemes";
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/colors/impl/EditorColorsManagerImpl";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schemeName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/colors/impl/EditorColorsManagerImpl";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllSchemes";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultScheme";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getGlobalScheme";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getSchemeForCurrentUITheme";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getSchemeManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createEditableCopy";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addColorsScheme";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setSchemes";
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getAllVisibleSchemes";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getScheme";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class State {
        public boolean USE_ONLY_MONOSPACED_FONTS = true;
        @OptionTag(tag="global_color_scheme", nameAttribute="", valueAttribute="name")
        public String colorScheme;

        State() {
        }
    }

    static class BundledScheme
    extends EditorColorsSchemeImpl
    implements ReadOnlyColorsScheme {
        public BundledScheme() {
            super(null);
        }

        @Override
        public boolean isVisible() {
            return false;
        }
    }
}

