/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.highlighter;

import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.util.LexerEditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighterFactory;
import com.intellij.openapi.fileTypes.EditorHighlighterProvider;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeEditorHighlighterProviders;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.PlainSyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.LanguageSubstitutors;
import com.intellij.testFramework.LightVirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditorHighlighterFactoryImpl
extends EditorHighlighterFactory {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.editor.highlighter.EditorHighlighterFactoryImpl");

    @NotNull
    public EditorHighlighter createEditorHighlighter(SyntaxHighlighter highlighter, @NotNull EditorColorsScheme colors) {
        if (colors == null) {
            EditorHighlighterFactoryImpl.$$$reportNull$$$0(0);
        }
        if (highlighter == null) {
            highlighter = new PlainSyntaxHighlighter();
        }
        LexerEditorHighlighter lexerEditorHighlighter = new LexerEditorHighlighter(highlighter, colors);
        if (lexerEditorHighlighter == null) {
            EditorHighlighterFactoryImpl.$$$reportNull$$$0(1);
        }
        return lexerEditorHighlighter;
    }

    @NotNull
    public EditorHighlighter createEditorHighlighter(@NotNull FileType fileType, @NotNull EditorColorsScheme settings, Project project2) {
        if (fileType == null) {
            EditorHighlighterFactoryImpl.$$$reportNull$$$0(2);
        }
        if (settings == null) {
            EditorHighlighterFactoryImpl.$$$reportNull$$$0(3);
        }
        if (fileType instanceof LanguageFileType) {
            EditorHighlighter editorHighlighter = ((EditorHighlighterProvider)FileTypeEditorHighlighterProviders.INSTANCE.forFileType(fileType)).getEditorHighlighter(project2, fileType, null, settings);
            if (editorHighlighter == null) {
                EditorHighlighterFactoryImpl.$$$reportNull$$$0(4);
            }
            return editorHighlighter;
        }
        SyntaxHighlighter highlighter = SyntaxHighlighterFactory.getSyntaxHighlighter((FileType)fileType, (Project)project2, null);
        EditorHighlighter editorHighlighter = this.createEditorHighlighter(highlighter, settings);
        if (editorHighlighter == null) {
            EditorHighlighterFactoryImpl.$$$reportNull$$$0(5);
        }
        return editorHighlighter;
    }

    @NotNull
    public EditorHighlighter createEditorHighlighter(Project project2, @NotNull FileType fileType) {
        if (fileType == null) {
            EditorHighlighterFactoryImpl.$$$reportNull$$$0(6);
        }
        EditorHighlighter editorHighlighter = this.createEditorHighlighter(fileType, EditorColorsManager.getInstance().getGlobalScheme(), project2);
        if (editorHighlighter == null) {
            EditorHighlighterFactoryImpl.$$$reportNull$$$0(7);
        }
        return editorHighlighter;
    }

    @NotNull
    public EditorHighlighter createEditorHighlighter(@NotNull VirtualFile vFile, @NotNull EditorColorsScheme settings, @Nullable Project project2) {
        FileType fileType;
        if (vFile == null) {
            EditorHighlighterFactoryImpl.$$$reportNull$$$0(8);
        }
        if (settings == null) {
            EditorHighlighterFactoryImpl.$$$reportNull$$$0(9);
        }
        if ((fileType = vFile.getFileType()) instanceof LanguageFileType) {
            EditorHighlighter editorHighlighter;
            LanguageFileType substFileType = EditorHighlighterFactoryImpl.substituteFileType(((LanguageFileType)fileType).getLanguage(), vFile, project2);
            if (substFileType != null) {
                boolean isPlain;
                EditorHighlighterProvider provider = (EditorHighlighterProvider)FileTypeEditorHighlighterProviders.INSTANCE.forFileType((FileType)substFileType);
                EditorHighlighter editorHighlighter2 = provider.getEditorHighlighter(project2, (FileType)substFileType, vFile, settings);
                boolean bl = isPlain = editorHighlighter2.getClass() == LexerEditorHighlighter.class && ((LexerEditorHighlighter)editorHighlighter2).isPlain();
                if (!isPlain) {
                    EditorHighlighter editorHighlighter3 = editorHighlighter2;
                    if (editorHighlighter3 == null) {
                        EditorHighlighterFactoryImpl.$$$reportNull$$$0(10);
                    }
                    return editorHighlighter3;
                }
            }
            try {
                editorHighlighter = ((EditorHighlighterProvider)FileTypeEditorHighlighterProviders.INSTANCE.forFileType(fileType)).getEditorHighlighter(project2, fileType, vFile, settings);
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
            if (editorHighlighter == null) {
                EditorHighlighterFactoryImpl.$$$reportNull$$$0(11);
            }
            return editorHighlighter;
        }
        SyntaxHighlighter highlighter = SyntaxHighlighterFactory.getSyntaxHighlighter((FileType)fileType, (Project)project2, (VirtualFile)vFile);
        EditorHighlighter editorHighlighter = this.createEditorHighlighter(highlighter, settings);
        if (editorHighlighter == null) {
            EditorHighlighterFactoryImpl.$$$reportNull$$$0(12);
        }
        return editorHighlighter;
    }

    @Nullable
    private static LanguageFileType substituteFileType(Language language, VirtualFile vFile, Project project2) {
        Language substLanguage;
        LanguageFileType fileType = null;
        if (vFile != null && project2 != null && (substLanguage = LanguageSubstitutors.INSTANCE.substituteLanguage(language, vFile, project2)) != language) {
            fileType = substLanguage.getAssociatedFileType();
        }
        return fileType;
    }

    @NotNull
    public EditorHighlighter createEditorHighlighter(Project project2, @NotNull VirtualFile file2) {
        if (file2 == null) {
            EditorHighlighterFactoryImpl.$$$reportNull$$$0(13);
        }
        EditorHighlighter editorHighlighter = this.createEditorHighlighter(file2, EditorColorsManager.getInstance().getGlobalScheme(), project2);
        if (editorHighlighter == null) {
            EditorHighlighterFactoryImpl.$$$reportNull$$$0(14);
        }
        return editorHighlighter;
    }

    @NotNull
    public EditorHighlighter createEditorHighlighter(Project project2, @NotNull String fileName) {
        if (fileName == null) {
            EditorHighlighterFactoryImpl.$$$reportNull$$$0(15);
        }
        EditorHighlighter editorHighlighter = this.createEditorHighlighter(EditorColorsManager.getInstance().getGlobalScheme(), fileName, project2);
        if (editorHighlighter == null) {
            EditorHighlighterFactoryImpl.$$$reportNull$$$0(16);
        }
        return editorHighlighter;
    }

    @NotNull
    public EditorHighlighter createEditorHighlighter(@NotNull EditorColorsScheme settings, @NotNull String fileName, @Nullable Project project2) {
        if (settings == null) {
            EditorHighlighterFactoryImpl.$$$reportNull$$$0(17);
        }
        if (fileName == null) {
            EditorHighlighterFactoryImpl.$$$reportNull$$$0(18);
        }
        EditorHighlighter editorHighlighter = this.createEditorHighlighter((VirtualFile)new LightVirtualFile(fileName), settings, project2);
        if (editorHighlighter == null) {
            EditorHighlighterFactoryImpl.$$$reportNull$$$0(19);
        }
        return editorHighlighter;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 16: 
            case 19: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 16: 
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "colors";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/highlighter/EditorHighlighterFactoryImpl";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 3: 
            case 9: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vFile";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/highlighter/EditorHighlighterFactoryImpl";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 16: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditorHighlighter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createEditorHighlighter";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 16: 
            case 19: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 16: 
            case 19: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

