/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project;

import com.intellij.openapi.externalSystem.model.project.ProjectCoordinate;
import com.intellij.openapi.externalSystem.model.project.ProjectId;
import com.intellij.openapi.externalSystem.service.project.AbstractIdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.ExternalProjectsWorkspaceImpl;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import gnu.trove.TObjectHashingStrategy;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public class ModifiableWorkspace {
    private final Map<ProjectCoordinate, String> myModuleMappingById = ContainerUtil.newTroveMap((TObjectHashingStrategy)new TObjectHashingStrategy<ProjectCoordinate>(){

        public int computeHashCode(ProjectCoordinate object) {
            String groupId = object.getGroupId();
            String artifactId = object.getArtifactId();
            String version = object.getVersion();
            int result2 = groupId != null ? groupId.hashCode() : 0;
            result2 = 31 * result2 + (artifactId != null ? artifactId.hashCode() : 0);
            result2 = 31 * result2 + (version != null ? version.hashCode() : 0);
            return result2;
        }

        public boolean equals(ProjectCoordinate o1, ProjectCoordinate o2) {
            if (o1.getGroupId() != null ? !o1.getGroupId().equals(o2.getGroupId()) : o2.getGroupId() != null) {
                return false;
            }
            if (o1.getArtifactId() != null ? !o1.getArtifactId().equals(o2.getArtifactId()) : o2.getArtifactId() != null) {
                return false;
            }
            return !(o1.getVersion() != null ? !o1.getVersion().equals(o2.getVersion()) : o2.getVersion() != null);
        }
    });
    private final AbstractIdeModifiableModelsProvider myModelsProvider;
    private final ExternalProjectsWorkspaceImpl.State myState;
    private MultiMap<String, String> mySubstitutions = MultiMap.createSet();
    private Map<String, String> myNamesMap = ContainerUtil.newHashMap();

    public ModifiableWorkspace(ExternalProjectsWorkspaceImpl.State state, AbstractIdeModifiableModelsProvider modelsProvider) {
        this.myModelsProvider = modelsProvider;
        HashSet existingModules = ContainerUtil.newHashSet();
        for (Module module2 : modelsProvider.getModules()) {
            this.register(module2, modelsProvider);
            existingModules.add(module2.getName());
        }
        this.myState = state;
        if (this.myState.names != null) {
            for (Map.Entry entry : this.myState.names.entrySet()) {
                if (!existingModules.contains(entry.getKey())) continue;
                this.myNamesMap.put((String)entry.getKey(), (String)entry.getValue());
            }
        }
        if (this.myState.substitutions != null) {
            for (Map.Entry entry : this.myState.substitutions.entrySet()) {
                if (!existingModules.contains(entry.getKey())) continue;
                this.mySubstitutions.put(entry.getKey(), (Collection)entry.getValue());
            }
        }
    }

    public void commit() {
        HashSet existingModules = ContainerUtil.newHashSet();
        Arrays.stream(this.myModelsProvider.getModules()).map(Module::getName).forEach(existingModules::add);
        this.myState.names = new HashMap<String, String>();
        this.myNamesMap.forEach((module2, lib) -> {
            if (existingModules.contains(module2)) {
                this.myState.names.put((String)module2, (String)lib);
            }
        });
        this.myState.substitutions = new HashMap<String, Set<String>>();
        for (Map.Entry entry : this.mySubstitutions.entrySet()) {
            Collection value2;
            if (!existingModules.contains(entry.getKey()) || (value2 = (Collection)entry.getValue()) == null || value2.isEmpty()) continue;
            this.myState.substitutions.put((String)entry.getKey(), new TreeSet(value2));
        }
    }

    public void addSubstitution(String ownerModuleName, String moduleName, String libraryName, DependencyScope scope) {
        this.myNamesMap.put(moduleName, libraryName);
        this.mySubstitutions.putValue((Object)ownerModuleName, (Object)(moduleName + '_' + scope.getDisplayName()));
    }

    public void removeSubstitution(String ownerModuleName, String moduleName, String libraryName, DependencyScope scope) {
        this.mySubstitutions.remove((Object)ownerModuleName, (Object)(moduleName + '_' + scope.getDisplayName()));
        Collection substitutions = this.mySubstitutions.values();
        for (DependencyScope dependencyScope : DependencyScope.values()) {
            if (!substitutions.contains(moduleName + '_' + dependencyScope.getDisplayName())) continue;
            return;
        }
        this.myNamesMap.remove(moduleName, libraryName);
    }

    public boolean isSubstitution(String moduleOwner, String substitutionModule, DependencyScope scope) {
        return this.mySubstitutions.get((Object)moduleOwner).contains(substitutionModule + '_' + scope.getDisplayName());
    }

    public boolean isSubstituted(String libraryName) {
        return this.myNamesMap.values().contains(libraryName);
    }

    public String getSubstitutedLibrary(String moduleName) {
        return this.myNamesMap.get(moduleName);
    }

    @Nullable
    public String findModule(@NotNull ProjectCoordinate id) {
        if (id == null) {
            ModifiableWorkspace.$$$reportNull$$$0(0);
        }
        if (StringUtil.isEmpty((String)id.getArtifactId())) {
            return null;
        }
        String result2 = this.myModuleMappingById.get(id);
        return result2 == null && id.getVersion() != null ? this.myModuleMappingById.get(new ProjectId(id.getGroupId(), id.getArtifactId(), null)) : result2;
    }

    public void register(@NotNull ProjectCoordinate id, @NotNull Module module2) {
        if (id == null) {
            ModifiableWorkspace.$$$reportNull$$$0(1);
        }
        if (module2 == null) {
            ModifiableWorkspace.$$$reportNull$$$0(2);
        }
        this.myModuleMappingById.put(id, module2.getName());
        this.myModuleMappingById.put((ProjectCoordinate)new ProjectId(id.getGroupId(), id.getArtifactId(), null), module2.getName());
    }

    private void register(@NotNull Module module2, AbstractIdeModifiableModelsProvider modelsProvider) {
        if (module2 == null) {
            ModifiableWorkspace.$$$reportNull$$$0(3);
        }
        Arrays.stream(ExternalProjectsWorkspaceImpl.EP_NAME.getExtensions()).map(contributor -> {
            if (module2 == null) {
                ModifiableWorkspace.$$$reportNull$$$0(5);
            }
            return contributor.findProjectId(module2, modelsProvider);
        }).filter(Objects::nonNull).findFirst().ifPresent(id -> {
            if (module2 == null) {
                ModifiableWorkspace.$$$reportNull$$$0(4);
            }
            this.register((ProjectCoordinate)id, module2);
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/externalSystem/service/project/ModifiableWorkspace";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "findModule";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "register";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$register$2";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$register$1";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

