/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project.manage;

import com.intellij.ide.projectView.ProjectView;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.ExternalSystemModulePropertyManager;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalSystemDataKeys;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ContentRootData;
import com.intellij.openapi.externalSystem.model.project.ExternalSystemSourceType;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.manage.AbstractModuleDataService;
import com.intellij.openapi.externalSystem.service.project.manage.AbstractProjectDataService;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemSettings;
import com.intellij.openapi.externalSystem.settings.ExternalProjectSettings;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.externalSystem.util.Order;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.containers.MultiMap;
import gnu.trove.THashSet;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;
import org.jetbrains.jps.model.java.JavaResourceRootType;
import org.jetbrains.jps.model.java.JavaSourceRootProperties;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

@Order(value=-2147483645)
public class ContentRootDataService
extends AbstractProjectDataService<ContentRootData, ContentEntry> {
    public static final com.intellij.openapi.util.Key<Boolean> CREATE_EMPTY_DIRECTORIES = com.intellij.openapi.util.Key.create((String)"createEmptyDirectories");
    private static final Logger LOG = Logger.getInstance(ContentRootDataService.class);

    @NotNull
    public Key<ContentRootData> getTargetDataKey() {
        Key key2 = ProjectKeys.CONTENT_ROOT;
        if (key2 == null) {
            ContentRootDataService.$$$reportNull$$$0(0);
        }
        return key2;
    }

    public void importData(@NotNull Collection<DataNode<ContentRootData>> toImport, @Nullable ProjectData projectData, @NotNull Project project2, @NotNull IdeModifiableModelsProvider modelsProvider) {
        if (toImport == null) {
            ContentRootDataService.$$$reportNull$$$0(1);
        }
        if (project2 == null) {
            ContentRootDataService.$$$reportNull$$$0(2);
        }
        if (modelsProvider == null) {
            ContentRootDataService.$$$reportNull$$$0(3);
        }
        if (toImport.isEmpty()) {
            return;
        }
        boolean isNewlyImportedProject = project2.getUserData(ExternalSystemDataKeys.NEWLY_IMPORTED_PROJECT) == Boolean.TRUE;
        boolean forceDirectoriesCreation = false;
        DataNode projectDataNode = ExternalSystemApiUtil.findParent(toImport.iterator().next(), (Key)ProjectKeys.PROJECT);
        if (projectDataNode != null) {
            forceDirectoriesCreation = projectDataNode.getUserData(CREATE_EMPTY_DIRECTORIES) == Boolean.TRUE;
        }
        THashSet modulesToExpand = ContainerUtil.newTroveSet();
        MultiMap byModule = ExternalSystemApiUtil.groupBy(toImport, ModuleData.class);
        for (Map.Entry entry : byModule.entrySet()) {
            Module module2 = (Module)((DataNode)entry.getKey()).getUserData(AbstractModuleDataService.MODULE_KEY);
            Module module3 = module2 = module2 != null ? module2 : modelsProvider.findIdeModule((ModuleData)((DataNode)entry.getKey()).getData());
            if (module2 == null) {
                LOG.warn(String.format("Can't import content roots. Reason: target module (%s) is not found at the ide. Content roots: %s", entry.getKey(), entry.getValue()));
                continue;
            }
            ContentRootDataService.importData(modelsProvider, (Collection)entry.getValue(), module2, forceDirectoriesCreation);
            if (!forceDirectoriesCreation && (!isNewlyImportedProject || projectData == null || !projectData.getLinkedExternalProjectPath().equals(ExternalSystemApiUtil.getExternalProjectPath((Module)module2)))) continue;
            modulesToExpand.add(module2);
        }
        if (!ApplicationManager.getApplication().isHeadlessEnvironment() && !modulesToExpand.isEmpty()) {
            for (Module module4 : modulesToExpand) {
                VirtualFile[] roots;
                String productionModuleName = modelsProvider.getProductionModuleName(module4);
                if (productionModuleName != null && modulesToExpand.contains(modelsProvider.findIdeModule(productionModuleName)) || (roots = modelsProvider.getModifiableRootModel(module4).getContentRoots()).length <= 0) continue;
                VirtualFile virtualFile = roots[0];
                ExternalSystemUtil.invokeLater(project2, ModalityState.NON_MODAL, () -> {
                    if (project2 == null) {
                        ContentRootDataService.$$$reportNull$$$0(21);
                    }
                    ProjectView projectView = ProjectView.getInstance(project2);
                    projectView.changeViewCB("ProjectPane", null).doWhenProcessed(() -> projectView.selectCB(null, virtualFile, false));
                });
            }
        }
    }

    private static void importData(@NotNull IdeModifiableModelsProvider modelsProvider, @NotNull Collection<DataNode<ContentRootData>> data, @NotNull Module module2, boolean forceDirectoriesCreation) {
        if (modelsProvider == null) {
            ContentRootDataService.$$$reportNull$$$0(4);
        }
        if (data == null) {
            ContentRootDataService.$$$reportNull$$$0(5);
        }
        if (module2 == null) {
            ContentRootDataService.$$$reportNull$$$0(6);
        }
        ModifiableRootModel modifiableRootModel = modelsProvider.getModifiableRootModel(module2);
        ContentEntry[] contentEntries = modifiableRootModel.getContentEntries();
        HashMap contentEntriesMap = ContainerUtilRt.newHashMap();
        for (ContentEntry contentEntry : contentEntries) {
            contentEntriesMap.put(contentEntry.getUrl(), contentEntry);
        }
        boolean createEmptyContentRootDirectories = forceDirectoriesCreation;
        if (!forceDirectoriesCreation && !data.isEmpty()) {
            ProjectSystemId projectSystemId = ((ContentRootData)data.iterator().next().getData()).getOwner();
            AbstractExternalSystemSettings externalSystemSettings = ExternalSystemApiUtil.getSettings((Project)module2.getProject(), (ProjectSystemId)projectSystemId);
            String path = ExternalSystemModulePropertyManager.getInstance((Module)module2).getRootProjectPath();
            if (path != null) {
                ExternalProjectSettings projectSettings = externalSystemSettings.getLinkedProjectSettings(path);
                createEmptyContentRootDirectories = projectSettings != null && projectSettings.isCreateEmptyContentRootDirectories();
            }
        }
        THashSet importedContentEntries = ContainerUtil.newIdentityTroveSet();
        for (DataNode<ContentRootData> node : data) {
            ContentRootData contentRoot = (ContentRootData)node.getData();
            ContentEntry contentEntry = ContentRootDataService.findOrCreateContentRoot(modifiableRootModel, contentRoot.getRootPath());
            if (!importedContentEntries.contains(contentEntry)) {
                contentEntry.clearSourceFolders();
                importedContentEntries.add(contentEntry);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("Importing content root '%s' for module '%s'", contentRoot.getRootPath(), module2.getName()));
            }
            for (ContentRootData.SourceRoot path : contentRoot.getPaths(ExternalSystemSourceType.SOURCE)) {
                ContentRootDataService.createSourceRootIfAbsent(contentEntry, path, module2.getName(), JavaSourceRootType.SOURCE, false, createEmptyContentRootDirectories);
            }
            for (ContentRootData.SourceRoot path : contentRoot.getPaths(ExternalSystemSourceType.TEST)) {
                ContentRootDataService.createSourceRootIfAbsent(contentEntry, path, module2.getName(), JavaSourceRootType.TEST_SOURCE, false, createEmptyContentRootDirectories);
            }
            for (ContentRootData.SourceRoot path : contentRoot.getPaths(ExternalSystemSourceType.SOURCE_GENERATED)) {
                ContentRootDataService.createSourceRootIfAbsent(contentEntry, path, module2.getName(), JavaSourceRootType.SOURCE, true, createEmptyContentRootDirectories);
            }
            for (ContentRootData.SourceRoot path : contentRoot.getPaths(ExternalSystemSourceType.TEST_GENERATED)) {
                ContentRootDataService.createSourceRootIfAbsent(contentEntry, path, module2.getName(), JavaSourceRootType.TEST_SOURCE, true, createEmptyContentRootDirectories);
            }
            for (ContentRootData.SourceRoot path : contentRoot.getPaths(ExternalSystemSourceType.RESOURCE)) {
                ContentRootDataService.createSourceRootIfAbsent(contentEntry, path, module2.getName(), JavaResourceRootType.RESOURCE, false, createEmptyContentRootDirectories);
            }
            for (ContentRootData.SourceRoot path : contentRoot.getPaths(ExternalSystemSourceType.TEST_RESOURCE)) {
                ContentRootDataService.createSourceRootIfAbsent(contentEntry, path, module2.getName(), JavaResourceRootType.TEST_RESOURCE, false, createEmptyContentRootDirectories);
            }
            for (ContentRootData.SourceRoot path : contentRoot.getPaths(ExternalSystemSourceType.EXCLUDED)) {
                ContentRootDataService.createExcludedRootIfAbsent(contentEntry, path, module2.getName(), module2.getProject());
            }
            contentEntriesMap.remove(contentEntry.getUrl());
        }
        for (ContentEntry contentEntry : contentEntriesMap.values()) {
            modifiableRootModel.removeContentEntry(contentEntry);
        }
    }

    @NotNull
    private static ContentEntry findOrCreateContentRoot(@NotNull ModifiableRootModel model, @NotNull String path) {
        ContentEntry[] entries;
        if (model == null) {
            ContentRootDataService.$$$reportNull$$$0(7);
        }
        if (path == null) {
            ContentRootDataService.$$$reportNull$$$0(8);
        }
        for (ContentEntry entry : entries = model.getContentEntries()) {
            VirtualFile file2 = entry.getFile();
            if (file2 == null || !ExternalSystemApiUtil.getLocalFileSystemPath((VirtualFile)file2).equals(path)) continue;
            ContentEntry contentEntry = entry;
            if (contentEntry == null) {
                ContentRootDataService.$$$reportNull$$$0(9);
            }
            return contentEntry;
        }
        ContentEntry contentEntry = model.addContentEntry(ContentRootDataService.toVfsUrl(path));
        if (contentEntry == null) {
            ContentRootDataService.$$$reportNull$$$0(10);
        }
        return contentEntry;
    }

    private static void createSourceRootIfAbsent(@NotNull ContentEntry entry, @NotNull ContentRootData.SourceRoot root, @NotNull String moduleName, @NotNull JpsModuleSourceRootType<?> sourceRootType, boolean generated, boolean createEmptyContentRootDirectories) {
        JavaSourceRootProperties properties;
        SourceFolder[] folders;
        if (entry == null) {
            ContentRootDataService.$$$reportNull$$$0(11);
        }
        if (root == null) {
            ContentRootDataService.$$$reportNull$$$0(12);
        }
        if (moduleName == null) {
            ContentRootDataService.$$$reportNull$$$0(13);
        }
        if (sourceRootType == null) {
            ContentRootDataService.$$$reportNull$$$0(14);
        }
        for (SourceFolder folder : folders = entry.getSourceFolders()) {
            VirtualFile file2 = folder.getFile();
            if (file2 == null || !ExternalSystemApiUtil.getLocalFileSystemPath((VirtualFile)file2).equals(root.getPath())) continue;
            JpsModuleSourceRootType folderRootType = folder.getRootType();
            if (JavaSourceRootType.SOURCE.equals(folderRootType) || sourceRootType.equals((Object)folderRootType)) {
                return;
            }
            if (JavaSourceRootType.TEST_SOURCE.equals(folderRootType) && JavaResourceRootType.TEST_RESOURCE.equals(sourceRootType)) {
                return;
            }
            entry.removeSourceFolder(folder);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("Importing %s for content root '%s' of module '%s'", root, entry.getUrl(), moduleName));
        }
        SourceFolder sourceFolder = entry.addSourceFolder(ContentRootDataService.toVfsUrl(root.getPath()), sourceRootType);
        if (!StringUtil.isEmpty((String)root.getPackagePrefix())) {
            sourceFolder.setPackagePrefix(root.getPackagePrefix());
        }
        if (generated && (properties = (JavaSourceRootProperties)sourceFolder.getJpsElement().getProperties(JavaModuleSourceRootTypes.SOURCES)) != null) {
            properties.setForGeneratedSources(true);
        }
        if (createEmptyContentRootDirectories) {
            ExternalSystemApiUtil.doWriteAction(() -> {
                if (root == null) {
                    ContentRootDataService.$$$reportNull$$$0(20);
                }
                try {
                    VfsUtil.createDirectoryIfMissing((String)root.getPath());
                }
                catch (IOException e) {
                    LOG.warn(String.format("Unable to create directory for the path: %s", root.getPath()), (Throwable)e);
                }
            });
        }
    }

    private static void createExcludedRootIfAbsent(@NotNull ContentEntry entry, @NotNull ContentRootData.SourceRoot root, @NotNull String moduleName, @NotNull Project project2) {
        if (entry == null) {
            ContentRootDataService.$$$reportNull$$$0(15);
        }
        if (root == null) {
            ContentRootDataService.$$$reportNull$$$0(16);
        }
        if (moduleName == null) {
            ContentRootDataService.$$$reportNull$$$0(17);
        }
        if (project2 == null) {
            ContentRootDataService.$$$reportNull$$$0(18);
        }
        String rootPath = root.getPath();
        for (VirtualFile file2 : entry.getExcludeFolderFiles()) {
            if (!ExternalSystemApiUtil.getLocalFileSystemPath((VirtualFile)file2).equals(rootPath)) continue;
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("Importing excluded root '%s' for content root '%s' of module '%s'", root, entry.getUrl(), moduleName));
        }
        entry.addExcludeFolder(ContentRootDataService.toVfsUrl(rootPath));
        if (!Registry.is((String)"ide.hide.excluded.files")) {
            ChangeListManager.getInstance((Project)project2).addDirectoryToIgnoreImplicitly(rootPath);
        }
    }

    private static String toVfsUrl(@NotNull String path) {
        if (path == null) {
            ContentRootDataService.$$$reportNull$$$0(19);
        }
        return "file://" + path;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/service/project/manage/ContentRootDataService";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toImport";
                break;
            }
            case 2: 
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelsProvider";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 8: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entry";
                break;
            }
            case 12: 
            case 16: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 13: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleName";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceRootType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetDataKey";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/service/project/manage/ContentRootDataService";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "findOrCreateContentRoot";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "importData";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findOrCreateContentRoot";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createSourceRootIfAbsent";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "createExcludedRootIfAbsent";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "toVfsUrl";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createSourceRootIfAbsent$2";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "lambda$importData$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

