/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project.manage;

import com.intellij.ide.highlighter.ArchiveFileType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.LibraryData;
import com.intellij.openapi.externalSystem.model.project.LibraryPathType;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.ExternalLibraryPathTypeMapper;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.IdeUIModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.manage.AbstractProjectDataService;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemConstants;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.externalSystem.util.Order;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.RootPolicy;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.NotNullFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Order(value=-2147483646)
public class LibraryDataService
extends AbstractProjectDataService<LibraryData, Library> {
    private static final Logger LOG = Logger.getInstance(LibraryDataService.class);
    @NotNull
    public static final NotNullFunction<String, File> PATH_TO_FILE = path -> new File((String)path);
    @NotNull
    private final ExternalLibraryPathTypeMapper myLibraryPathTypeMapper;

    public LibraryDataService(@NotNull ExternalLibraryPathTypeMapper mapper) {
        if (mapper == null) {
            LibraryDataService.$$$reportNull$$$0(0);
        }
        this.myLibraryPathTypeMapper = mapper;
    }

    @NotNull
    public Key<LibraryData> getTargetDataKey() {
        Key key2 = ProjectKeys.LIBRARY;
        if (key2 == null) {
            LibraryDataService.$$$reportNull$$$0(1);
        }
        return key2;
    }

    public void importData(@NotNull Collection<DataNode<LibraryData>> toImport, @Nullable ProjectData projectData, @NotNull Project project2, @NotNull IdeModifiableModelsProvider modelsProvider) {
        if (toImport == null) {
            LibraryDataService.$$$reportNull$$$0(2);
        }
        if (project2 == null) {
            LibraryDataService.$$$reportNull$$$0(3);
        }
        if (modelsProvider == null) {
            LibraryDataService.$$$reportNull$$$0(4);
        }
        for (DataNode<LibraryData> dataNode : toImport) {
            this.importLibrary((LibraryData)dataNode.getData(), modelsProvider);
        }
    }

    private void importLibrary(@NotNull LibraryData toImport, @NotNull IdeModifiableModelsProvider modelsProvider) {
        if (toImport == null) {
            LibraryDataService.$$$reportNull$$$0(5);
        }
        if (modelsProvider == null) {
            LibraryDataService.$$$reportNull$$$0(6);
        }
        Map<OrderRootType, Collection<File>> libraryFiles = this.prepareLibraryFiles(toImport);
        String libraryName = toImport.getInternalName();
        Library library = modelsProvider.getLibraryByName(libraryName);
        if (library != null) {
            this.syncPaths(toImport, library, modelsProvider);
            return;
        }
        library = modelsProvider.createLibrary(libraryName, ExternalSystemApiUtil.toExternalSource((ProjectSystemId)toImport.getOwner()));
        Library.ModifiableModel libraryModel = modelsProvider.getModifiableLibraryModel(library);
        LibraryDataService.registerPaths(toImport.isUnresolved(), libraryFiles, libraryModel, libraryName);
    }

    @NotNull
    public Map<OrderRootType, Collection<File>> prepareLibraryFiles(@NotNull LibraryData data) {
        if (data == null) {
            LibraryDataService.$$$reportNull$$$0(7);
        }
        HashMap result2 = ContainerUtilRt.newHashMap();
        for (LibraryPathType pathType : LibraryPathType.values()) {
            Set paths = data.getPaths(pathType);
            if (paths.isEmpty()) continue;
            result2.put(this.myLibraryPathTypeMapper.map(pathType), ContainerUtil.map((Collection)paths, PATH_TO_FILE));
        }
        HashMap hashMap = result2;
        if (hashMap == null) {
            LibraryDataService.$$$reportNull$$$0(8);
        }
        return hashMap;
    }

    static void registerPaths(boolean unresolved, @NotNull Map<OrderRootType, Collection<File>> libraryFiles, @NotNull Library.ModifiableModel model, @NotNull String libraryName) {
        if (libraryFiles == null) {
            LibraryDataService.$$$reportNull$$$0(9);
        }
        if (model == null) {
            LibraryDataService.$$$reportNull$$$0(10);
        }
        if (libraryName == null) {
            LibraryDataService.$$$reportNull$$$0(11);
        }
        for (Map.Entry<OrderRootType, Collection<File>> entry : libraryFiles.entrySet()) {
            for (File file2 : entry.getValue()) {
                VirtualFile virtualFile;
                VirtualFile virtualFile2 = virtualFile = unresolved ? null : ExternalSystemUtil.refreshAndFindFileByIoFile(file2);
                if (virtualFile == null) {
                    String[] urls;
                    String url;
                    if (!unresolved && ExternalSystemConstants.VERBOSE_PROCESSING && entry.getKey() == OrderRootType.CLASSES) {
                        LOG.warn(String.format("Can't find %s of the library '%s' at path '%s'", entry.getKey(), libraryName, file2.getAbsolutePath()));
                    }
                    if (ArrayUtil.contains((String)(url = VfsUtil.getUrlForLibraryRoot((File)file2)), (String[])(urls = model.getUrls(entry.getKey())))) continue;
                    model.addRoot(url, entry.getKey());
                    continue;
                }
                if (virtualFile.isDirectory()) {
                    Object[] files = model.getFiles(entry.getKey());
                    if (ArrayUtil.contains((Object)virtualFile, (Object[])files)) continue;
                    model.addRoot(virtualFile, entry.getKey());
                    continue;
                }
                VirtualFile root = virtualFile;
                if (virtualFile.getFileType() instanceof ArchiveFileType && (root = JarFileSystem.getInstance().getJarRootForLocalFile(virtualFile)) == null) {
                    LOG.warn(String.format("Can't parse contents of the JAR file at path '%s' for the library '%s''", file2.getAbsolutePath(), libraryName));
                    continue;
                }
                Object[] files = model.getFiles(entry.getKey());
                if (ArrayUtil.contains((Object)root, (Object[])files)) continue;
                model.addRoot(root, entry.getKey());
            }
        }
    }

    public void postProcess(@NotNull Collection<DataNode<LibraryData>> toImport, @Nullable ProjectData projectData, @NotNull Project project2, @NotNull IdeModifiableModelsProvider modelsProvider) {
        if (toImport == null) {
            LibraryDataService.$$$reportNull$$$0(12);
        }
        if (project2 == null) {
            LibraryDataService.$$$reportNull$$$0(13);
        }
        if (modelsProvider == null) {
            LibraryDataService.$$$reportNull$$$0(14);
        }
        if (projectData == null) {
            return;
        }
        if (modelsProvider instanceof IdeUIModifiableModelsProvider) {
            return;
        }
        List orphanIdeLibraries = ContainerUtil.newSmartList();
        LibraryTable.ModifiableModel librariesModel = modelsProvider.getModifiableProjectLibrariesModel();
        for (Library library : librariesModel.getLibraries()) {
            if (!ExternalSystemApiUtil.isExternalSystemLibrary((Library)library, (ProjectSystemId)projectData.getOwner()) || !LibraryDataService.isOrphanProjectLibrary(library, modelsProvider) || modelsProvider.isSubstituted(library.getName())) continue;
            orphanIdeLibraries.add(library);
        }
        for (Library library : orphanIdeLibraries) {
            Library libraryToRemove;
            String libraryName = library.getName();
            if (libraryName == null || (libraryToRemove = librariesModel.getLibraryByName(libraryName)) == null) continue;
            librariesModel.removeLibrary(libraryToRemove);
        }
    }

    private void syncPaths(@NotNull LibraryData externalLibrary, @NotNull Library ideLibrary, @NotNull IdeModifiableModelsProvider modelsProvider) {
        if (externalLibrary == null) {
            LibraryDataService.$$$reportNull$$$0(15);
        }
        if (ideLibrary == null) {
            LibraryDataService.$$$reportNull$$$0(16);
        }
        if (modelsProvider == null) {
            LibraryDataService.$$$reportNull$$$0(17);
        }
        if (externalLibrary.isUnresolved()) {
            return;
        }
        HashMap toRemove2 = ContainerUtilRt.newHashMap();
        HashMap toAdd = ContainerUtilRt.newHashMap();
        for (LibraryPathType pathType : LibraryPathType.values()) {
            OrderRootType ideType = this.myLibraryPathTypeMapper.map(pathType);
            HashSet toAddPerType = ContainerUtilRt.newHashSet((Iterable)externalLibrary.getPaths(pathType));
            toAdd.put(ideType, toAddPerType);
            HashSet toRemovePerType = ContainerUtilRt.newHashSet();
            toRemove2.put(ideType, toRemovePerType);
            for (VirtualFile ideFile : ideLibrary.getFiles(ideType)) {
                String idePath = ExternalSystemApiUtil.getLocalFileSystemPath((VirtualFile)ideFile);
                if (toAddPerType.remove(idePath)) continue;
                toRemovePerType.add(ideFile.getUrl());
            }
        }
        if (toRemove2.isEmpty() && toAdd.isEmpty()) {
            return;
        }
        Library.ModifiableModel libraryModel = modelsProvider.getModifiableLibraryModel(ideLibrary);
        for (Map.Entry entry : toRemove2.entrySet()) {
            for (String path : (Set)entry.getValue()) {
                libraryModel.removeRoot(path, (OrderRootType)entry.getKey());
            }
        }
        for (Map.Entry entry : toAdd.entrySet()) {
            HashMap roots = ContainerUtilRt.newHashMap();
            roots.put(entry.getKey(), ContainerUtil.map((Collection)((Collection)entry.getValue()), PATH_TO_FILE));
            LibraryDataService.registerPaths(externalLibrary.isUnresolved(), roots, libraryModel, externalLibrary.getInternalName());
        }
    }

    private static boolean isOrphanProjectLibrary(final @NotNull Library library, @NotNull IdeModifiableModelsProvider modelsProvider) {
        if (library == null) {
            LibraryDataService.$$$reportNull$$$0(18);
        }
        if (modelsProvider == null) {
            LibraryDataService.$$$reportNull$$$0(19);
        }
        RootPolicy<Boolean> visitor = new RootPolicy<Boolean>(){

            public Boolean visitLibraryOrderEntry(@NotNull LibraryOrderEntry ideDependency, Boolean value2) {
                if (ideDependency == null) {
                    1.$$$reportNull$$$0(0);
                }
                return !ideDependency.isModuleLevel() && (library == ideDependency.getLibrary() || ideDependency.getLibrary() == null && StringUtil.equals((CharSequence)library.getName(), (CharSequence)ideDependency.getLibraryName()));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ideDependency", "com/intellij/openapi/externalSystem/service/project/manage/LibraryDataService$1", "visitLibraryOrderEntry"));
            }
        };
        for (Module module2 : modelsProvider.getModules()) {
            for (OrderEntry entry : modelsProvider.getOrderEntries(module2)) {
                if (!((Boolean)entry.accept((RootPolicy)visitor, (Object)false)).booleanValue()) continue;
                return false;
            }
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapper";
                break;
            }
            case 1: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/service/project/manage/LibraryDataService";
                break;
            }
            case 2: 
            case 5: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toImport";
                break;
            }
            case 3: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 6: 
            case 14: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelsProvider";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryFiles";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryName";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalLibrary";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ideLibrary";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "library";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/service/project/manage/LibraryDataService";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetDataKey";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareLibraryFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 8: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "importData";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "importLibrary";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "prepareLibraryFiles";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "registerPaths";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "postProcess";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "syncPaths";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isOrphanProjectLibrary";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

