/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project.manage;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.project.LibraryData;
import com.intellij.openapi.externalSystem.model.project.LibraryDependencyData;
import com.intellij.openapi.externalSystem.model.project.LibraryPathType;
import com.intellij.openapi.externalSystem.model.project.OrderAware;
import com.intellij.openapi.externalSystem.model.project.ProjectCoordinate;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.manage.AbstractDependencyDataService;
import com.intellij.openapi.externalSystem.service.project.manage.LibraryDataService;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.Order;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.ModuleLibraryOrderEntryImpl;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Order(value=-2147483645)
public class LibraryDependencyDataService
extends AbstractDependencyDataService<LibraryDependencyData, LibraryOrderEntry> {
    private static final Logger LOG = Logger.getInstance(LibraryDependencyDataService.class);
    @NotNull
    private final LibraryDataService myLibraryManager;

    public LibraryDependencyDataService(@NotNull LibraryDataService libraryManager) {
        if (libraryManager == null) {
            LibraryDependencyDataService.$$$reportNull$$$0(0);
        }
        this.myLibraryManager = libraryManager;
    }

    @NotNull
    public Key<LibraryDependencyData> getTargetDataKey() {
        Key key2 = ProjectKeys.LIBRARY_DEPENDENCY;
        if (key2 == null) {
            LibraryDependencyDataService.$$$reportNull$$$0(1);
        }
        return key2;
    }

    @Override
    @NotNull
    public Class<LibraryOrderEntry> getOrderEntryType() {
        if (LibraryOrderEntry.class == null) {
            LibraryDependencyDataService.$$$reportNull$$$0(2);
        }
        return LibraryOrderEntry.class;
    }

    @Override
    protected Map<OrderEntry, OrderAware> importData(@NotNull Collection<DataNode<LibraryDependencyData>> nodesToImport, @NotNull Module module2, @NotNull IdeModifiableModelsProvider modelsProvider) {
        if (nodesToImport == null) {
            LibraryDependencyDataService.$$$reportNull$$$0(3);
        }
        if (module2 == null) {
            LibraryDependencyDataService.$$$reportNull$$$0(4);
        }
        if (modelsProvider == null) {
            LibraryDependencyDataService.$$$reportNull$$$0(5);
        }
        HashMap moduleLibrariesToImport = ContainerUtilRt.newHashMap();
        HashMap projectLibrariesToImport = ContainerUtilRt.newHashMap();
        LinkedHashSet toImport = ContainerUtilRt.newLinkedHashSet();
        LinkedHashMap orderEntryDataMap = ContainerUtil.newLinkedHashMap();
        boolean hasUnresolved = false;
        for (DataNode<LibraryDependencyData> dependencyNode : nodesToImport) {
            LibraryDependencyData dependencyData = (LibraryDependencyData)dependencyNode.getData();
            LibraryData libraryData = (LibraryData)dependencyData.getTarget();
            hasUnresolved |= libraryData.isUnresolved();
            switch (dependencyData.getLevel()) {
                case MODULE: {
                    HashSet paths = ContainerUtilRt.newHashSet();
                    for (String path : libraryData.getPaths(LibraryPathType.BINARY)) {
                        paths.add(ExternalSystemApiUtil.toCanonicalPath((String)path) + dependencyData.getScope().name());
                    }
                    moduleLibrariesToImport.put(paths, dependencyData);
                    toImport.add(dependencyData);
                    break;
                }
                case PROJECT: {
                    projectLibrariesToImport.put(libraryData.getInternalName() + dependencyData.getScope().name(), dependencyData);
                    toImport.add(dependencyData);
                }
            }
        }
        boolean finalHasUnresolved = hasUnresolved;
        ModifiableRootModel modifiableRootModel = modelsProvider.getModifiableRootModel(module2);
        LibraryTable moduleLibraryTable = modifiableRootModel.getModuleLibraryTable();
        this.syncExistingAndRemoveObsolete(modelsProvider, moduleLibrariesToImport, projectLibrariesToImport, toImport, orderEntryDataMap, modifiableRootModel, finalHasUnresolved);
        if (!toImport.isEmpty()) {
            this.importMissing(modelsProvider, toImport, orderEntryDataMap, modifiableRootModel, moduleLibraryTable, module2);
        }
        return orderEntryDataMap;
    }

    private void importMissing(@NotNull IdeModifiableModelsProvider modelsProvider, @NotNull Set<LibraryDependencyData> toImport, @NotNull Map<OrderEntry, OrderAware> orderEntryDataMap, @NotNull ModifiableRootModel moduleRootModel, @NotNull LibraryTable moduleLibraryTable, @NotNull Module module2) {
        if (modelsProvider == null) {
            LibraryDependencyDataService.$$$reportNull$$$0(6);
        }
        if (toImport == null) {
            LibraryDependencyDataService.$$$reportNull$$$0(7);
        }
        if (orderEntryDataMap == null) {
            LibraryDependencyDataService.$$$reportNull$$$0(8);
        }
        if (moduleRootModel == null) {
            LibraryDependencyDataService.$$$reportNull$$$0(9);
        }
        if (moduleLibraryTable == null) {
            LibraryDependencyDataService.$$$reportNull$$$0(10);
        }
        if (module2 == null) {
            LibraryDependencyDataService.$$$reportNull$$$0(11);
        }
        for (LibraryDependencyData dependencyData : toImport) {
            LibraryData libraryData = (LibraryData)dependencyData.getTarget();
            String libraryName = libraryData.getInternalName();
            switch (dependencyData.getLevel()) {
                case MODULE: {
                    Library moduleLib = libraryName.isEmpty() ? moduleLibraryTable.createLibrary() : moduleLibraryTable.createLibrary(libraryName);
                    LibraryOrderEntry existingLibraryDependency = this.syncExistingLibraryDependency(modelsProvider, dependencyData, moduleLib, moduleRootModel, module2);
                    orderEntryDataMap.put((OrderEntry)existingLibraryDependency, (OrderAware)dependencyData);
                    break;
                }
                case PROJECT: {
                    Library projectLib = modelsProvider.getLibraryByName(libraryName);
                    if (projectLib == null) {
                        LibraryOrderEntry existingProjectLibraryDependency = this.syncExistingLibraryDependency(modelsProvider, dependencyData, moduleLibraryTable.createLibrary(libraryName), moduleRootModel, module2);
                        orderEntryDataMap.put((OrderEntry)existingProjectLibraryDependency, (OrderAware)dependencyData);
                        break;
                    }
                    LibraryOrderEntry orderEntry = moduleRootModel.addLibraryEntry(projectLib);
                    LibraryDependencyDataService.setLibraryScope(orderEntry, projectLib, module2, dependencyData);
                    ModuleOrderEntry substitutionEntry = modelsProvider.trySubstitute(module2, orderEntry, (ProjectCoordinate)libraryData);
                    if (substitutionEntry != null) {
                        orderEntryDataMap.put((OrderEntry)substitutionEntry, (OrderAware)dependencyData);
                        break;
                    }
                    orderEntryDataMap.put((OrderEntry)orderEntry, (OrderAware)dependencyData);
                }
            }
        }
    }

    private static void setLibraryScope(@NotNull LibraryOrderEntry orderEntry, @NotNull Library lib, @NotNull Module module2, @NotNull LibraryDependencyData dependencyData) {
        if (orderEntry == null) {
            LibraryDependencyDataService.$$$reportNull$$$0(12);
        }
        if (lib == null) {
            LibraryDependencyDataService.$$$reportNull$$$0(13);
        }
        if (module2 == null) {
            LibraryDependencyDataService.$$$reportNull$$$0(14);
        }
        if (dependencyData == null) {
            LibraryDependencyDataService.$$$reportNull$$$0(15);
        }
        orderEntry.setExported(dependencyData.isExported());
        orderEntry.setScope(dependencyData.getScope());
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("Configuring library '%s' of module '%s' to be%s exported and have scope %s", lib, module2.getName(), dependencyData.isExported() ? " not" : "", dependencyData.getScope()));
        }
    }

    private void syncExistingAndRemoveObsolete(@NotNull IdeModifiableModelsProvider modelsProvider, @NotNull Map<Set<String>, LibraryDependencyData> moduleLibrariesToImport, @NotNull Map<String, LibraryDependencyData> projectLibrariesToImport, @NotNull Set<LibraryDependencyData> toImport, @NotNull Map<OrderEntry, OrderAware> orderEntryDataMap, @NotNull ModifiableRootModel moduleRootModel, boolean hasUnresolvedLibraries) {
        if (modelsProvider == null) {
            LibraryDependencyDataService.$$$reportNull$$$0(16);
        }
        if (moduleLibrariesToImport == null) {
            LibraryDependencyDataService.$$$reportNull$$$0(17);
        }
        if (projectLibrariesToImport == null) {
            LibraryDependencyDataService.$$$reportNull$$$0(18);
        }
        if (toImport == null) {
            LibraryDependencyDataService.$$$reportNull$$$0(19);
        }
        if (orderEntryDataMap == null) {
            LibraryDependencyDataService.$$$reportNull$$$0(20);
        }
        if (moduleRootModel == null) {
            LibraryDependencyDataService.$$$reportNull$$$0(21);
        }
        for (OrderEntry entry : moduleRootModel.getOrderEntries()) {
            if (entry instanceof ModuleLibraryOrderEntryImpl) {
                ModuleLibraryOrderEntryImpl moduleLibraryOrderEntry = (ModuleLibraryOrderEntryImpl)entry;
                Library library = moduleLibraryOrderEntry.getLibrary();
                if (library == null) {
                    LOG.warn("Skipping module-level library entry because it doesn't have backing Library object. Entry: " + entry);
                    continue;
                }
                VirtualFile[] libraryFiles = library.getFiles(OrderRootType.CLASSES);
                HashSet moduleLibraryKey = ContainerUtilRt.newHashSet((int)libraryFiles.length);
                for (VirtualFile file2 : libraryFiles) {
                    moduleLibraryKey.add(ExternalSystemApiUtil.getLocalFileSystemPath((VirtualFile)file2) + moduleLibraryOrderEntry.getScope().name());
                }
                LibraryDependencyData existing = moduleLibrariesToImport.remove(moduleLibraryKey);
                if (existing == null || !StringUtil.equals((CharSequence)StringUtil.nullize((String)existing.getInternalName()), (CharSequence)library.getName())) {
                    moduleRootModel.removeOrderEntry(entry);
                    continue;
                }
                orderEntryDataMap.put(entry, (OrderAware)existing);
                this.syncExistingLibraryDependency(modelsProvider, existing, library, moduleRootModel, moduleLibraryOrderEntry.getOwnerModule());
                toImport.remove(existing);
                continue;
            }
            if (!(entry instanceof LibraryOrderEntry)) continue;
            LibraryOrderEntry libraryOrderEntry = (LibraryOrderEntry)entry;
            String libraryName = libraryOrderEntry.getLibraryName();
            LibraryDependencyData existing = projectLibrariesToImport.remove(libraryName + libraryOrderEntry.getScope().name());
            if (existing != null) {
                String module2 = modelsProvider.findModuleByPublication((ProjectCoordinate)existing.getTarget());
                if (module2 == null) {
                    toImport.remove(existing);
                    orderEntryDataMap.put(entry, (OrderAware)existing);
                    libraryOrderEntry.setExported(existing.isExported());
                    libraryOrderEntry.setScope(existing.getScope());
                    continue;
                }
                moduleRootModel.removeOrderEntry(entry);
                continue;
            }
            if (hasUnresolvedLibraries) continue;
            moduleRootModel.removeOrderEntry(entry);
        }
    }

    private LibraryOrderEntry syncExistingLibraryDependency(@NotNull IdeModifiableModelsProvider modelsProvider, @NotNull LibraryDependencyData libraryDependencyData, @NotNull Library library, @NotNull ModifiableRootModel moduleRootModel, @NotNull Module module2) {
        if (modelsProvider == null) {
            LibraryDependencyDataService.$$$reportNull$$$0(22);
        }
        if (libraryDependencyData == null) {
            LibraryDependencyDataService.$$$reportNull$$$0(23);
        }
        if (library == null) {
            LibraryDependencyDataService.$$$reportNull$$$0(24);
        }
        if (moduleRootModel == null) {
            LibraryDependencyDataService.$$$reportNull$$$0(25);
        }
        if (module2 == null) {
            LibraryDependencyDataService.$$$reportNull$$$0(26);
        }
        Library.ModifiableModel libraryModel = modelsProvider.getModifiableLibraryModel(library);
        String libraryName = libraryDependencyData.getInternalName();
        LibraryData libraryDependencyDataTarget = (LibraryData)libraryDependencyData.getTarget();
        Map<OrderRootType, Collection<File>> files = this.myLibraryManager.prepareLibraryFiles(libraryDependencyDataTarget);
        LibraryDataService.registerPaths(libraryDependencyDataTarget.isUnresolved(), files, libraryModel, libraryName);
        LibraryOrderEntry orderEntry = LibraryDependencyDataService.findLibraryOrderEntry(moduleRootModel, library, libraryDependencyData.getScope());
        assert (orderEntry != null);
        LibraryDependencyDataService.setLibraryScope(orderEntry, library, module2, libraryDependencyData);
        return orderEntry;
    }

    @Nullable
    private static LibraryOrderEntry findLibraryOrderEntry(@NotNull ModifiableRootModel moduleRootModel, @NotNull Library library, @NotNull DependencyScope scope) {
        if (moduleRootModel == null) {
            LibraryDependencyDataService.$$$reportNull$$$0(27);
        }
        if (library == null) {
            LibraryDependencyDataService.$$$reportNull$$$0(28);
        }
        if (scope == null) {
            LibraryDependencyDataService.$$$reportNull$$$0(29);
        }
        LibraryOrderEntry candidate = null;
        for (OrderEntry orderEntry : moduleRootModel.getOrderEntries()) {
            if (!(orderEntry instanceof LibraryOrderEntry)) continue;
            LibraryOrderEntry libraryOrderEntry = (LibraryOrderEntry)orderEntry;
            if (library == libraryOrderEntry.getLibrary()) {
                return libraryOrderEntry;
            }
            if (!library.equals(libraryOrderEntry.getLibrary())) continue;
            if (libraryOrderEntry.getScope() == scope) {
                return libraryOrderEntry;
            }
            candidate = libraryOrderEntry;
        }
        return candidate;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryManager";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/service/project/manage/LibraryDependencyDataService";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodesToImport";
                break;
            }
            case 4: 
            case 11: 
            case 14: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 5: 
            case 6: 
            case 16: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelsProvider";
                break;
            }
            case 7: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toImport";
                break;
            }
            case 8: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "orderEntryDataMap";
                break;
            }
            case 9: 
            case 21: 
            case 25: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleRootModel";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleLibraryTable";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "orderEntry";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lib";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependencyData";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleLibrariesToImport";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectLibrariesToImport";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryDependencyData";
                break;
            }
            case 24: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "library";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/service/project/manage/LibraryDependencyDataService";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetDataKey";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrderEntryType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "importData";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "importMissing";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "setLibraryScope";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "syncExistingAndRemoveObsolete";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "syncExistingLibraryDependency";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "findLibraryOrderEntry";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

