/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project.settings;

import com.intellij.openapi.externalSystem.model.project.settings.ConfigurationData;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.settings.ConfigurationHandler;
import com.intellij.openapi.project.Project;
import com.intellij.psi.codeStyle.CodeStyleScheme;
import com.intellij.psi.codeStyle.CodeStyleSchemes;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/openapi/externalSystem/service/project/settings/CodeStyleConfigurationHandler;", "Lcom/intellij/openapi/externalSystem/service/project/settings/ConfigurationHandler;", "()V", "apply", "", "project", "Lcom/intellij/openapi/project/Project;", "modelsProvider", "Lcom/intellij/openapi/externalSystem/service/project/IdeModifiableModelsProvider;", "configuration", "Lcom/intellij/openapi/externalSystem/model/project/settings/ConfigurationData;", "external-system-impl"})
public final class CodeStyleConfigurationHandler
implements ConfigurationHandler {
    public void apply(@NotNull Project project2, @NotNull IdeModifiableModelsProvider modelsProvider, @NotNull ConfigurationData configuration) {
        CommonCodeStyleSettings.IndentOptions indentOptions;
        Object v;
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)modelsProvider, (String)"modelsProvider");
        Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
        String importedSchemeName = "Gradle Imported";
        Object object = configuration.find("codeStyle");
        if (!(object instanceof Map)) {
            object = null;
        }
        Map map = (Map)object;
        if (map == null) {
            return;
        }
        Map codeStyleSettings = map;
        CodeStyleSchemes schemes = CodeStyleSchemes.getInstance();
        CodeStyleScheme existingScheme = schemes.findPreferredScheme(importedSchemeName);
        if (Intrinsics.areEqual((Object)existingScheme.getName(), (Object)importedSchemeName)) {
            schemes.deleteScheme(existingScheme);
        }
        CodeStyleScheme importedScheme = schemes.createNewScheme(importedSchemeName, schemes.getDefaultScheme());
        Object v2 = codeStyleSettings.get("indent");
        if (v2 != null) {
            Object indentType = v = v2;
            CommonCodeStyleSettings.IndentOptions indentOptions2 = importedScheme.getCodeStyleSettings().getIndentOptions();
            if (indentOptions2 == null) {
            } else {
                indentOptions = indentOptions2;
                Object v3 = indentType;
                if (Intrinsics.areEqual(v3, (Object)"tabs")) {
                    indentOptions.USE_TAB_CHARACTER = true;
                } else if (Intrinsics.areEqual(v3, (Object)"spaces")) {
                    indentOptions.USE_TAB_CHARACTER = false;
                }
            }
        }
        Object v4 = codeStyleSettings.get("indentSize");
        if (v4 != null) {
            Object it = v = v4;
            CommonCodeStyleSettings.IndentOptions indentOptions3 = importedScheme.getCodeStyleSettings().getIndentOptions();
            if (indentOptions3 == null) {
            } else {
                indentOptions = indentOptions3;
                if (it instanceof Number) {
                    indentOptions.INDENT_SIZE = ((Number)it).intValue();
                }
            }
        }
        schemes.setCurrentScheme(importedScheme);
    }
}

