/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.task;

import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.execution.ExternalTaskPojo;
import com.intellij.openapi.externalSystem.model.project.ExternalConfigPathAware;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.task.TaskData;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalSystemKeymapExtension;
import com.intellij.openapi.externalSystem.service.task.AbstractToolWindowService;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemLocalSettings;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.Order;
import com.intellij.openapi.project.Project;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

@Order(value=-2147483644)
public class ToolWindowTaskService
extends AbstractToolWindowService<TaskData> {
    @NotNull
    public static final Function<DataNode<TaskData>, ExternalTaskPojo> MAPPER = node -> ExternalTaskPojo.from((TaskData)((TaskData)node.getData()));
    public static final NullableFunction<DataNode<TaskData>, ExternalConfigPathAware> TASK_HOLDER_RETRIEVAL_STRATEGY = node -> {
        ModuleData moduleData = (ModuleData)node.getData(ProjectKeys.MODULE);
        return moduleData == null ? (ExternalConfigPathAware)node.getData(ProjectKeys.PROJECT) : moduleData;
    };

    @NotNull
    public Key<TaskData> getTargetDataKey() {
        Key key2 = ProjectKeys.TASK;
        if (key2 == null) {
            ToolWindowTaskService.$$$reportNull$$$0(0);
        }
        return key2;
    }

    @Override
    protected void processData(@NotNull Collection<DataNode<TaskData>> nodes, @NotNull Project project2) {
        if (nodes == null) {
            ToolWindowTaskService.$$$reportNull$$$0(1);
        }
        if (project2 == null) {
            ToolWindowTaskService.$$$reportNull$$$0(2);
        }
        if (nodes.isEmpty()) {
            return;
        }
        ProjectSystemId externalSystemId = ((TaskData)nodes.iterator().next().getData()).getOwner();
        ExternalSystemManager manager = ExternalSystemApiUtil.getManager((ProjectSystemId)externalSystemId);
        assert (manager != null);
        ExternalSystemKeymapExtension.updateActions(project2, nodes);
        MultiMap grouped = ContainerUtil.groupBy(nodes, TASK_HOLDER_RETRIEVAL_STRATEGY);
        HashMap data = ContainerUtilRt.newHashMap();
        for (Map.Entry entry : grouped.entrySet()) {
            data.put(((ExternalConfigPathAware)entry.getKey()).getLinkedExternalProjectPath(), ContainerUtilRt.map2List((Collection)((Collection)entry.getValue()), MAPPER));
        }
        AbstractExternalSystemLocalSettings settings = (AbstractExternalSystemLocalSettings)manager.getLocalSettingsProvider().fun((Object)project2);
        HashMap availableTasks = ContainerUtilRt.newHashMap((Map)settings.getAvailableTasks());
        availableTasks.putAll(data);
        settings.setAvailableTasks((Map)availableTasks);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/service/task/ToolWindowTaskService";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodes";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetDataKey";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/service/task/ToolWindowTaskService";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "processData";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

