/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.view;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemSettings;
import com.intellij.openapi.externalSystem.settings.ExternalProjectSettings;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.view.ExternalProjectsView;
import com.intellij.openapi.externalSystem.view.ExternalSystemNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectNode
extends ExternalSystemNode<ProjectData> {
    private String myTooltipCache;
    private boolean singleModuleProject = false;

    public ProjectNode(ExternalProjectsView externalProjectsView, DataNode<ProjectData> projectDataNode) {
        super(externalProjectsView, null, projectDataNode);
        this.updateProject();
    }

    protected void update(PresentationData presentation) {
        super.update(presentation);
        presentation.setIcon(this.getUiAware().getProjectIcon());
    }

    public ExternalSystemNode getGroup() {
        return (ExternalSystemNode)this.getParent();
    }

    @Override
    @NotNull
    protected List<? extends ExternalSystemNode> doBuildChildren() {
        List<ExternalSystemNode> children2 = super.doBuildChildren();
        List visibleChildren = ContainerUtil.filter(children2, node -> node.isVisible());
        if (visibleChildren.size() == 1 && ((ExternalSystemNode)visibleChildren.get(0)).getName().equals(this.getName())) {
            this.singleModuleProject = true;
            List<ExternalSystemNode> list2 = ((ExternalSystemNode)visibleChildren.get(0)).doBuildChildren();
            if (list2 == null) {
                ProjectNode.$$$reportNull$$$0(0);
            }
            return list2;
        }
        this.singleModuleProject = false;
        List list3 = visibleChildren;
        if (list3 == null) {
            ProjectNode.$$$reportNull$$$0(1);
        }
        return list3;
    }

    public boolean isSingleModuleProject() {
        this.getChildren();
        return this.singleModuleProject;
    }

    void updateProject() {
        this.myTooltipCache = this.makeDescription();
        this.getStructure().updateFrom(this.getParent());
    }

    public String getName() {
        ProjectData projectData = (ProjectData)this.getData();
        return projectData != null ? projectData.getExternalName() : "unspecified";
    }

    @Override
    protected void doUpdate() {
        AbstractExternalSystemSettings externalSystemSettings;
        ExternalProjectSettings projectSettings;
        String autoImportHint = null;
        ProjectData projectData = (ProjectData)this.getData();
        if (projectData != null && (projectSettings = (externalSystemSettings = ExternalSystemApiUtil.getSettings((Project)this.getExternalProjectsView().getProject(), (ProjectSystemId)((ProjectData)this.getData()).getOwner())).getLinkedProjectSettings(projectData.getLinkedExternalProjectPath())) != null && projectSettings.isUseAutoImport()) {
            autoImportHint = "auto-import enabled";
        }
        this.setNameAndTooltip(this.getName(), this.myTooltipCache, autoImportHint);
    }

    protected SimpleTextAttributes getPlainAttributes() {
        return super.getPlainAttributes();
    }

    private String makeDescription() {
        StringBuilder desc = new StringBuilder();
        ProjectData projectData = (ProjectData)this.getData();
        desc.append("<table><tr><td nowrap><table><tr><td nowrap>Project:</td><td nowrap>").append(this.getName()).append("</td></tr>").append(projectData != null ? "<tr><td nowrap>Location:</td><td nowrap>" + projectData.getLinkedExternalProjectPath() + "</td></tr>" : "").append(projectData != null && !StringUtil.isEmptyOrSpaces((String)projectData.getDescription()) ? "<tr><td colspan='2' nowrap><hr align='center' width='90%' />" + projectData.getDescription() + "</td></tr>" : "").append("</td></tr></table></td></tr>");
        this.appendProblems(desc);
        desc.append("</table>");
        return desc.toString();
    }

    private void appendProblems(StringBuilder desc) {
    }

    @Override
    protected void setNameAndTooltip(String name2, @Nullable String tooltip, SimpleTextAttributes attributes) {
        super.setNameAndTooltip(name2, tooltip, attributes);
    }

    @Override
    @Nullable
    @NonNls
    protected String getMenuId() {
        return "ExternalSystemView.ProjectMenu";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/view/ProjectNode", "doBuildChildren"));
    }
}

