/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.ex.FileEditorProviderManager;
import com.intellij.openapi.fileEditor.ex.IdeDocumentHistory;
import com.intellij.openapi.fileEditor.impl.EditorWindowHolder;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.fileEditor.impl.FileEditorProviderManagerImpl;
import com.intellij.openapi.fileEditor.impl.IdeDocumentHistoryImpl;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NullUtils;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Weighted;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.FocusWatcher;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.JBColor;
import com.intellij.ui.PrevNextActionsDescriptor;
import com.intellij.ui.SideBorder;
import com.intellij.ui.TabbedPaneWrapper;
import com.intellij.ui.components.JBPanelWithEmptyText;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.ui.tabs.UiDecorator;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.Insets;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class EditorComposite
implements Disposable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.fileEditor.impl.EditorComposite");
    @NotNull
    private final VirtualFile myFile;
    private boolean myPinned;
    protected FileEditor[] myEditors;
    private final long myInitialFileTimeStamp;
    TabbedPaneWrapper myTabbedPaneWrapper;
    private final MyComponent myComponent;
    private final FocusWatcher myFocusWatcher;
    private FileEditor mySelectedEditor;
    private final FileEditorManagerEx myFileEditorManager;
    private final Map<FileEditor, JComponent> myTopComponents;
    private final Map<FileEditor, JComponent> myBottomComponents;
    private final Map<FileEditor, String> myDisplayNames;

    EditorComposite(@NotNull VirtualFile file2, @NotNull FileEditor[] editors, @NotNull FileEditorManagerEx fileEditorManager) {
        if (file2 == null) {
            EditorComposite.$$$reportNull$$$0(0);
        }
        if (editors == null) {
            EditorComposite.$$$reportNull$$$0(1);
        }
        if (fileEditorManager == null) {
            EditorComposite.$$$reportNull$$$0(2);
        }
        this.myTopComponents = new HashMap<FileEditor, JComponent>();
        this.myBottomComponents = new HashMap<FileEditor, JComponent>();
        this.myDisplayNames = ContainerUtil.newHashMap();
        this.myFile = file2;
        this.myEditors = editors;
        if (NullUtils.hasNull((Object[])editors)) {
            throw new IllegalArgumentException("Must not pass null editors in " + Arrays.asList(editors));
        }
        this.myFileEditorManager = fileEditorManager;
        this.myInitialFileTimeStamp = this.myFile.getTimeStamp();
        Disposer.register((Disposable)fileEditorManager.getProject(), (Disposable)this);
        if (editors.length > 1) {
            this.myTabbedPaneWrapper = this.createTabbedPaneWrapper(editors);
            JComponent component = this.myTabbedPaneWrapper.getComponent();
            this.myComponent = new MyComponent(component, component);
        } else if (editors.length == 1) {
            this.myTabbedPaneWrapper = null;
            FileEditor editor = editors[0];
            this.myComponent = new MyComponent(this.createEditorComponent(editor), editor.getPreferredFocusedComponent());
        } else {
            throw new IllegalArgumentException("editors array cannot be empty");
        }
        this.mySelectedEditor = editors[0];
        this.myFocusWatcher = new FocusWatcher();
        this.myFocusWatcher.install((Component)this.myComponent);
        this.myFileEditorManager.addFileEditorManagerListener(new FileEditorManagerListener(){

            public void selectionChanged(@NotNull FileEditorManagerEvent event) {
                VirtualFile newFile;
                VirtualFile oldFile;
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (Comparing.equal((Object)(oldFile = event.getOldFile()), (Object)(newFile = event.getNewFile())) && Comparing.equal((Object)EditorComposite.this.getFile(), (Object)newFile)) {
                    Runnable runnable2 = () -> {
                        FileEditor newEditor;
                        FileEditor oldEditor;
                        if (event == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        if ((oldEditor = event.getOldEditor()) != null) {
                            oldEditor.deselectNotify();
                        }
                        if ((newEditor = event.getNewEditor()) != null) {
                            newEditor.selectNotify();
                        }
                        ((FileEditorProviderManagerImpl)FileEditorProviderManager.getInstance()).providerSelected(EditorComposite.this);
                        ((IdeDocumentHistoryImpl)IdeDocumentHistory.getInstance(EditorComposite.this.myFileEditorManager.getProject())).onSelectionChanged();
                    };
                    if (ApplicationManager.getApplication().isDispatchThread()) {
                        CommandProcessor.getInstance().executeCommand(EditorComposite.this.myFileEditorManager.getProject(), runnable2, "Switch Active Editor", null);
                    } else {
                        runnable2.run();
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "event";
                objectArray2[1] = "com/intellij/openapi/fileEditor/impl/EditorComposite$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "selectionChanged";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "lambda$selectionChanged$0";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, this);
    }

    @NotNull
    private TabbedPaneWrapper.AsJBTabs createTabbedPaneWrapper(FileEditor[] editors) {
        PrevNextActionsDescriptor descriptor2 = new PrevNextActionsDescriptor("NextEditorTab", "PreviousEditorTab");
        TabbedPaneWrapper.AsJBTabs wrapper = new TabbedPaneWrapper.AsJBTabs(this.myFileEditorManager.getProject(), 3, descriptor2, this);
        wrapper.getTabs().getPresentation().setPaintBorder(0, 0, 0, 0).setTabSidePaintBorder(1).setGhostsAlwaysVisible(true).setUiDecorator(() -> new UiDecorator.UiDecoration(null, new Insets(0, 8, 0, 8)));
        wrapper.getTabs().getComponent().setBorder(new EmptyBorder(0, 0, 1, 0));
        boolean firstEditor = true;
        for (FileEditor editor : editors) {
            JComponent component = firstEditor && this.myComponent != null ? (JComponent)this.myComponent.getComponent(0) : this.createEditorComponent(editor);
            wrapper.addTab(this.getDisplayName(editor), component);
            firstEditor = false;
        }
        wrapper.addChangeListener(new MyChangeListener());
        TabbedPaneWrapper.AsJBTabs asJBTabs = wrapper;
        if (asJBTabs == null) {
            EditorComposite.$$$reportNull$$$0(3);
        }
        return asJBTabs;
    }

    private JComponent createEditorComponent(FileEditor editor) {
        JPanel component = new JPanel(new BorderLayout());
        JComponent comp = editor.getComponent();
        if (!FileEditorManagerImpl.isDumbAware(editor)) {
            comp = DumbService.getInstance((Project)this.myFileEditorManager.getProject()).wrapGently(comp, (Disposable)editor);
        }
        component.add((Component)comp, "Center");
        TopBottomPanel topPanel = new TopBottomPanel();
        this.myTopComponents.put(editor, (JComponent)((Object)topPanel));
        component.add((Component)((Object)topPanel), "North");
        TopBottomPanel bottomPanel = new TopBottomPanel();
        this.myBottomComponents.put(editor, (JComponent)((Object)bottomPanel));
        component.add((Component)((Object)bottomPanel), "South");
        return component;
    }

    public boolean isPinned() {
        return this.myPinned;
    }

    void setPinned(boolean pinned) {
        this.myPinned = pinned;
    }

    private void fireSelectedEditorChanged(FileEditor oldSelectedEditor, FileEditor newSelectedEditor) {
        if (!(EventQueue.isDispatchThread() && this.myFileEditorManager.isInsideChange() || Comparing.equal((Object)oldSelectedEditor, (Object)newSelectedEditor))) {
            this.myFileEditorManager.notifyPublisher(() -> {
                FileEditorManagerEvent event = new FileEditorManagerEvent((FileEditorManager)this.myFileEditorManager, this.myFile, oldSelectedEditor, this.myFile, newSelectedEditor);
                FileEditorManagerListener publisher = (FileEditorManagerListener)this.myFileEditorManager.getProject().getMessageBus().syncPublisher(FileEditorManagerListener.FILE_EDITOR_MANAGER);
                publisher.selectionChanged(event);
            });
            JComponent component = newSelectedEditor.getComponent();
            EditorWindowHolder holder = (EditorWindowHolder)UIUtil.getParentOfType(EditorWindowHolder.class, (Component)component);
            if (holder != null) {
                ((FileEditorManagerImpl)this.myFileEditorManager).addSelectionRecord(this.myFile, holder.getEditorWindow());
            }
        }
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        if (this.mySelectedEditor == null) {
            return null;
        }
        Component component = this.myFocusWatcher.getFocusedComponent();
        if (!(component instanceof JComponent && component.isShowing() && component.isEnabled() && component.isFocusable())) {
            return this.getSelectedEditor().getPreferredFocusedComponent();
        }
        return (JComponent)component;
    }

    @NotNull
    public VirtualFile getFile() {
        VirtualFile virtualFile = this.myFile;
        if (virtualFile == null) {
            EditorComposite.$$$reportNull$$$0(4);
        }
        return virtualFile;
    }

    public FileEditorManager getFileEditorManager() {
        return this.myFileEditorManager;
    }

    public long getInitialFileTimeStamp() {
        return this.myInitialFileTimeStamp;
    }

    @NotNull
    public FileEditor[] getEditors() {
        if (this.myEditors == null) {
            EditorComposite.$$$reportNull$$$0(5);
        }
        return this.myEditors;
    }

    @NotNull
    List<JComponent> getTopComponents(@NotNull FileEditor editor) {
        if (editor == null) {
            EditorComposite.$$$reportNull$$$0(6);
        }
        List<JComponent> list2 = this.getTopBottomComponents(editor, true);
        if (list2 == null) {
            EditorComposite.$$$reportNull$$$0(7);
        }
        return list2;
    }

    @NotNull
    public List<JComponent> getBottomComponents(@NotNull FileEditor editor) {
        if (editor == null) {
            EditorComposite.$$$reportNull$$$0(8);
        }
        List<JComponent> list2 = this.getTopBottomComponents(editor, false);
        if (list2 == null) {
            EditorComposite.$$$reportNull$$$0(9);
        }
        return list2;
    }

    @NotNull
    private List<JComponent> getTopBottomComponents(@NotNull FileEditor editor, boolean top) {
        if (editor == null) {
            EditorComposite.$$$reportNull$$$0(10);
        }
        SmartList result2 = new SmartList();
        JComponent container = top ? this.myTopComponents.get(editor) : this.myBottomComponents.get(editor);
        for (Component each : container.getComponents()) {
            if (!(each instanceof NonOpaquePanel)) continue;
            result2.add((Object)((NonOpaquePanel)each).getTargetComponent());
        }
        List<JComponent> list2 = Collections.unmodifiableList(result2);
        if (list2 == null) {
            EditorComposite.$$$reportNull$$$0(11);
        }
        return list2;
    }

    public void addTopComponent(FileEditor editor, JComponent component) {
        this.manageTopOrBottomComponent(editor, component, true, false);
    }

    public void removeTopComponent(FileEditor editor, JComponent component) {
        this.manageTopOrBottomComponent(editor, component, true, true);
    }

    public void addBottomComponent(FileEditor editor, JComponent component) {
        this.manageTopOrBottomComponent(editor, component, false, false);
    }

    public void removeBottomComponent(FileEditor editor, JComponent component) {
        this.manageTopOrBottomComponent(editor, component, false, true);
    }

    private void manageTopOrBottomComponent(FileEditor editor, JComponent component, boolean top, boolean remove) {
        JComponent container;
        JComponent jComponent = container = top ? this.myTopComponents.get(editor) : this.myBottomComponents.get(editor);
        assert (container != null);
        if (remove) {
            container.remove(component.getParent());
        } else {
            NonOpaquePanel wrapper = new NonOpaquePanel(component);
            if (!Boolean.TRUE.equals(component.getClientProperty(FileEditorManager.SEPARATOR_DISABLED))) {
                wrapper.setBorder((Border)EditorComposite.createTopBottomSideBorder(top));
            }
            container.add((Component)wrapper, EditorComposite.calcComponentInsertionIndex(component, container));
        }
        container.revalidate();
    }

    private static int calcComponentInsertionIndex(@NotNull JComponent newComponent, @NotNull JComponent container) {
        if (newComponent == null) {
            EditorComposite.$$$reportNull$$$0(12);
        }
        if (container == null) {
            EditorComposite.$$$reportNull$$$0(13);
        }
        int max = container.getComponentCount();
        for (int i = 0; i < max; ++i) {
            double w2;
            Component childWrapper = container.getComponent(i);
            Component childComponent = childWrapper instanceof Wrapper ? ((Wrapper)childWrapper).getTargetComponent() : childWrapper;
            boolean weighted1 = newComponent instanceof Weighted;
            boolean weighted2 = childComponent instanceof Weighted;
            if (!weighted2) continue;
            if (!weighted1) {
                return i;
            }
            double w1 = ((Weighted)newComponent).getWeight();
            if (!(w1 < (w2 = ((Weighted)childComponent).getWeight()))) continue;
            return i;
        }
        return -1;
    }

    public void setDisplayName(@NotNull FileEditor editor, @NotNull String name2) {
        if (editor == null) {
            EditorComposite.$$$reportNull$$$0(14);
        }
        if (name2 == null) {
            EditorComposite.$$$reportNull$$$0(15);
        }
        int index = ContainerUtil.indexOfIdentity((List)ContainerUtil.immutableList((Object[])this.myEditors), (Object)editor);
        assert (index != -1);
        this.myDisplayNames.put(editor, name2);
        if (this.myTabbedPaneWrapper != null) {
            this.myTabbedPaneWrapper.setTitleAt(index, name2);
        }
    }

    @NotNull
    protected String getDisplayName(@NotNull FileEditor editor) {
        if (editor == null) {
            EditorComposite.$$$reportNull$$$0(16);
        }
        String string = (String)ObjectUtils.notNull((Object)this.myDisplayNames.get(editor), (Object)editor.getName());
        if (string == null) {
            EditorComposite.$$$reportNull$$$0(17);
        }
        return string;
    }

    @NotNull
    FileEditor getSelectedEditor() {
        FileEditor fileEditor = (FileEditor)this.getSelectedEditorWithProvider().getFirst();
        if (fileEditor == null) {
            EditorComposite.$$$reportNull$$$0(18);
        }
        return fileEditor;
    }

    public boolean isDisposed() {
        return this.myTabbedPaneWrapper != null && this.myTabbedPaneWrapper.isDisposed();
    }

    @NotNull
    public abstract Pair<FileEditor, FileEditorProvider> getSelectedEditorWithProvider();

    void setSelectedEditor(int index) {
        if (this.myEditors.length == 1) {
            LOG.assertTrue(this.myTabbedPaneWrapper == null);
        } else {
            LOG.assertTrue(this.myTabbedPaneWrapper != null);
            this.myTabbedPaneWrapper.setSelectedIndex(index);
        }
    }

    public JComponent getComponent() {
        return this.myComponent;
    }

    public boolean isModified() {
        for (int i = this.myEditors.length - 1; i >= 0; --i) {
            if (!this.myEditors[i].isModified()) continue;
            return true;
        }
        return false;
    }

    public void dispose() {
        for (FileEditor editor : this.myEditors) {
            if (Disposer.isDisposed((Disposable)editor)) continue;
            Disposer.dispose((Disposable)editor);
        }
        this.myFocusWatcher.deinstall(this.myFocusWatcher.getTopComponent());
    }

    void addEditor(@NotNull FileEditor editor) {
        if (editor == null) {
            EditorComposite.$$$reportNull$$$0(19);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myEditors = (FileEditor[])ArrayUtil.append((Object[])this.myEditors, (Object)editor);
        if (this.myTabbedPaneWrapper == null) {
            this.myTabbedPaneWrapper = this.createTabbedPaneWrapper(this.myEditors);
            this.myComponent.setComponent(this.myTabbedPaneWrapper.getComponent());
        } else {
            JComponent component = this.createEditorComponent(editor);
            this.myTabbedPaneWrapper.addTab(this.getDisplayName(editor), component);
        }
        this.myFocusWatcher.deinstall(this.myFocusWatcher.getTopComponent());
        this.myFocusWatcher.install((Component)this.myComponent);
    }

    @NotNull
    private static SideBorder createTopBottomSideBorder(final boolean top) {
        SideBorder sideBorder = new SideBorder(null, top ? 8 : 2){

            public Color getLineColor() {
                EditorColorsScheme scheme2 = EditorColorsManager.getInstance().getGlobalScheme();
                Color result2 = scheme2.getColor(top ? EditorColors.SEPARATOR_ABOVE_COLOR : EditorColors.SEPARATOR_BELOW_COLOR);
                if (result2 == null) {
                    result2 = scheme2.getColor(EditorColors.TEARLINE_COLOR);
                }
                return result2 == null ? JBColor.BLACK : result2;
            }
        };
        if (sideBorder == null) {
            EditorComposite.$$$reportNull$$$0(20);
        }
        return sideBorder;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 17: 
            case 18: 
            case 20: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 17: 
            case 18: 
            case 20: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editors";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileEditorManager";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 17: 
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/fileEditor/impl/EditorComposite";
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 14: 
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newComponent";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/fileEditor/impl/EditorComposite";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createTabbedPaneWrapper";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditors";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getTopComponents";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getBottomComponents";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getTopBottomComponents";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedEditor";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "createTopBottomSideBorder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 17: 
            case 18: 
            case 20: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getTopComponents";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getBottomComponents";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getTopBottomComponents";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "calcComponentInsertionIndex";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "setDisplayName";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getDisplayName";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "addEditor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 17: 
            case 18: 
            case 20: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class TopBottomPanel
    extends JBPanelWithEmptyText {
        private TopBottomPanel() {
            this.setLayout(new BoxLayout((Container)((Object)this), 1));
        }

        public Color getBackground() {
            Color color = EditorColorsManager.getInstance().getGlobalScheme().getColor(EditorColors.GUTTER_BACKGROUND);
            return color == null ? EditorColors.GUTTER_BACKGROUND.getDefaultColor() : color;
        }
    }

    private class MyComponent
    extends JPanel
    implements DataProvider {
        @Nullable
        private JComponent myFocusComponent;

        public MyComponent(@Nullable JComponent realComponent, JComponent focusComponent) {
            if (realComponent == null) {
                MyComponent.$$$reportNull$$$0(0);
            }
            super(new BorderLayout());
            this.myFocusComponent = focusComponent;
            this.add((Component)realComponent, "Center");
        }

        void setComponent(JComponent newComponent) {
            this.add((Component)newComponent, "Center");
            this.myFocusComponent = newComponent;
        }

        @Override
        public boolean requestFocusInWindow() {
            return this.myFocusComponent != null && this.myFocusComponent.requestFocusInWindow();
        }

        @Override
        public void requestFocus() {
            if (this.myFocusComponent != null) {
                IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)this.myFocusComponent, true));
            }
        }

        @Override
        public boolean requestDefaultFocus() {
            return this.myFocusComponent != null && this.myFocusComponent.requestDefaultFocus();
        }

        public final Object getData(String dataId) {
            if (PlatformDataKeys.FILE_EDITOR.is(dataId)) {
                return EditorComposite.this.getSelectedEditor();
            }
            if (CommonDataKeys.VIRTUAL_FILE.is(dataId)) {
                return EditorComposite.this.myFile.isValid() ? EditorComposite.this.myFile : null;
            }
            if (CommonDataKeys.VIRTUAL_FILE_ARRAY.is(dataId)) {
                VirtualFile[] virtualFileArray;
                if (EditorComposite.this.myFile.isValid()) {
                    VirtualFile[] virtualFileArray2 = new VirtualFile[1];
                    virtualFileArray = virtualFileArray2;
                    virtualFileArray2[0] = EditorComposite.this.myFile;
                } else {
                    virtualFileArray = null;
                }
                return virtualFileArray;
            }
            JComponent component = EditorComposite.this.getPreferredFocusedComponent();
            if (component instanceof DataProvider && component != this) {
                return ((DataProvider)component).getData(dataId);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "realComponent", "com/intellij/openapi/fileEditor/impl/EditorComposite$MyComponent", "<init>"));
        }
    }

    private final class MyChangeListener
    implements ChangeListener {
        private MyChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            FileEditor oldSelectedEditor = EditorComposite.this.mySelectedEditor;
            LOG.assertTrue(oldSelectedEditor != null);
            int selectedIndex = EditorComposite.this.myTabbedPaneWrapper.getSelectedIndex();
            LOG.assertTrue(selectedIndex != -1);
            EditorComposite.this.mySelectedEditor = EditorComposite.this.myEditors[selectedIndex];
            EditorComposite.this.fireSelectedEditorChanged(oldSelectedEditor, EditorComposite.this.mySelectedEditor);
        }
    }
}

