/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.keymap.impl.ui;

import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.KeyStrokeAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.text.DefaultCaret;

public final class ShortcutTextField
extends JTextField {
    private KeyStroke myKeyStroke;

    ShortcutTextField() {
        this.enableEvents(8L);
        this.setFocusTraversalKeysEnabled(false);
        this.setCaret(new DefaultCaret(){

            @Override
            public boolean isVisible() {
                return false;
            }
        });
    }

    private static boolean absolutelyUnknownKey(KeyEvent e) {
        return e.getKeyCode() == 0 && e.getExtendedKeyCode() == 0 && e.getKeyChar() == '\uffff' && e.getKeyLocation() == 0 && e.getExtendedKeyCode() == 0;
    }

    @Override
    protected void processKeyEvent(KeyEvent e) {
        if (e.getID() == 401) {
            int keyCode = e.getKeyCode();
            if (keyCode == 16 || keyCode == 18 || keyCode == 17 || keyCode == 65406 || keyCode == 157 || ShortcutTextField.absolutelyUnknownKey(e)) {
                return;
            }
            this.setKeyStroke(KeyStrokeAdapter.getDefaultKeyStroke(e));
        }
    }

    void setKeyStroke(KeyStroke keyStroke) {
        KeyStroke old = this.myKeyStroke;
        if (old != null || keyStroke != null) {
            this.myKeyStroke = keyStroke;
            super.setText(KeymapUtil.getKeystrokeText((KeyStroke)keyStroke));
            this.setCaretPosition(0);
            this.firePropertyChange("keyStroke", old, keyStroke);
        }
    }

    KeyStroke getKeyStroke() {
        return this.myKeyStroke;
    }

    @Override
    public void enableInputMethods(boolean enable) {
        super.enableInputMethods(enable && Registry.is((String)"ide.settings.keymap.input.method.enabled"));
    }

    @Override
    public void setText(String text2) {
        super.setText(text2);
        this.setCaretPosition(0);
        if (text2 == null || text2.isEmpty()) {
            this.myKeyStroke = null;
            this.firePropertyChange("keyStroke", null, null);
        }
    }
}

