/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options.ex;

import com.intellij.BundleBase;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurableEP;
import com.intellij.openapi.options.ConfigurableGroup;
import com.intellij.openapi.options.ConfigurableProvider;
import com.intellij.openapi.options.OptionalConfigurable;
import com.intellij.openapi.options.OptionsBundle;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.options.ex.ConfigurableFilter;
import com.intellij.openapi.options.ex.ConfigurableWrapper;
import com.intellij.openapi.options.ex.SortedConfigurableGroup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfigurableExtensionPointUtil {
    private static final Logger LOG = Logger.getInstance(ConfigurableExtensionPointUtil.class);

    private ConfigurableExtensionPointUtil() {
    }

    public static List<Configurable> buildConfigurablesList(ConfigurableEP<Configurable>[] extensions, @Nullable ConfigurableFilter filter2) {
        ArrayList<Configurable> result2 = new ArrayList<Configurable>();
        HashMap idToConfigurable = ContainerUtil.newHashMap();
        ArrayList idsInEpOrder = ContainerUtil.newArrayList();
        for (ConfigurableEP<Configurable> ep : extensions) {
            Configurable configurable = ConfigurableWrapper.wrapConfigurable(ep);
            if (ConfigurableExtensionPointUtil.isSuppressed(configurable, filter2)) continue;
            if (configurable instanceof ConfigurableWrapper) {
                ConfigurableWrapper wrapper = (ConfigurableWrapper)configurable;
                idToConfigurable.put(wrapper.getId(), wrapper);
                idsInEpOrder.add(wrapper.getId());
                continue;
            }
            ContainerUtil.addIfNotNull(result2, (Object)configurable);
        }
        HashSet visited = ContainerUtil.newHashSet();
        Map<String, List<String>> idTree = ConfigurableExtensionPointUtil.buildIdTree(idToConfigurable, idsInEpOrder);
        for (String id : idsInEpOrder) {
            ConfigurableExtensionPointUtil.addChildrenRec(id, idToConfigurable, visited, idTree);
        }
        for (String id : idsInEpOrder) {
            ConfigurableWrapper wrapper = (ConfigurableWrapper)idToConfigurable.get(id);
            String parentId = wrapper.getParentId();
            if (parentId != null && idToConfigurable.containsKey(parentId)) continue;
            result2.add((Configurable)wrapper);
        }
        return result2;
    }

    @NotNull
    private static ConfigurableWrapper addChildrenRec(@NotNull String id, @NotNull Map<String, ConfigurableWrapper> idToConfigurable, @NotNull Set<String> visited, @NotNull Map<String, List<String>> idTree) {
        if (id == null) {
            ConfigurableExtensionPointUtil.$$$reportNull$$$0(0);
        }
        if (idToConfigurable == null) {
            ConfigurableExtensionPointUtil.$$$reportNull$$$0(1);
        }
        if (visited == null) {
            ConfigurableExtensionPointUtil.$$$reportNull$$$0(2);
        }
        if (idTree == null) {
            ConfigurableExtensionPointUtil.$$$reportNull$$$0(3);
        }
        ConfigurableWrapper wrapper = idToConfigurable.get(id);
        if (visited.contains(id)) {
            ConfigurableWrapper configurableWrapper = wrapper;
            if (configurableWrapper == null) {
                ConfigurableExtensionPointUtil.$$$reportNull$$$0(4);
            }
            return configurableWrapper;
        }
        visited.add(id);
        List<String> childIds = idTree.get(id);
        if (childIds != null) {
            for (String childId : childIds) {
                ConfigurableWrapper childWrapper = ConfigurableExtensionPointUtil.addChildrenRec(childId, idToConfigurable, visited, idTree);
                wrapper = wrapper.addChild((Configurable)childWrapper);
            }
            idToConfigurable.put(id, wrapper);
        }
        ConfigurableWrapper configurableWrapper = wrapper;
        if (configurableWrapper == null) {
            ConfigurableExtensionPointUtil.$$$reportNull$$$0(5);
        }
        return configurableWrapper;
    }

    @NotNull
    private static Map<String, List<String>> buildIdTree(@NotNull Map<String, ConfigurableWrapper> idToConfigurable, @NotNull List<String> idsInEpOrder) {
        if (idToConfigurable == null) {
            ConfigurableExtensionPointUtil.$$$reportNull$$$0(6);
        }
        if (idsInEpOrder == null) {
            ConfigurableExtensionPointUtil.$$$reportNull$$$0(7);
        }
        HashMap tree = ContainerUtil.newHashMap();
        for (String id : idsInEpOrder) {
            ConfigurableWrapper wrapper = idToConfigurable.get(id);
            String parentId = wrapper.getParentId();
            if (parentId == null) continue;
            ConfigurableWrapper parent = idToConfigurable.get(parentId);
            if (parent == null) {
                LOG.warn("Can't find parent for " + parentId + " (" + wrapper + ")");
                continue;
            }
            List children2 = (List)tree.get(parentId);
            if (children2 == null) {
                children2 = ContainerUtil.newArrayListWithCapacity((int)5);
                tree.put(parentId, children2);
            }
            children2.add(id);
        }
        HashMap hashMap = tree;
        if (hashMap == null) {
            ConfigurableExtensionPointUtil.$$$reportNull$$$0(8);
        }
        return hashMap;
    }

    public static ConfigurableGroup getConfigurableGroup(@Nullable Project project2, boolean withIdeSettings) {
        if (!withIdeSettings && project2 == null) {
            project2 = ProjectManager.getInstance().getDefaultProject();
        }
        return ConfigurableExtensionPointUtil.getConfigurableGroup(ConfigurableExtensionPointUtil.getConfigurables(project2, withIdeSettings), project2);
    }

    public static ConfigurableGroup getConfigurableGroup(@NotNull List<Configurable> configurables, @Nullable Project project2) {
        if (configurables == null) {
            ConfigurableExtensionPointUtil.$$$reportNull$$$0(9);
        }
        Map<String, List<Configurable>> map = ConfigurableExtensionPointUtil.groupConfigurables(configurables);
        HashMap tree = ContainerUtil.newHashMap();
        for (Map.Entry<String, List<Configurable>> entry : map.entrySet()) {
            ConfigurableExtensionPointUtil.addGroup(tree, project2, entry.getKey(), entry.getValue(), null);
        }
        SortedConfigurableGroup root = ConfigurableExtensionPointUtil.getGroup(tree, "root");
        if (!tree.isEmpty()) {
            for (String groupId : tree.keySet()) {
                LOG.warn("ignore group: " + groupId);
            }
        }
        if (root != null && root.myList != null && Registry.is((String)"ide.settings.replace.group.with.single.configurable")) {
            ConfigurableExtensionPointUtil.replaceGroupWithSingleConfigurable(root.myList);
        }
        return root;
    }

    private static void replaceGroupWithSingleConfigurable(List<Configurable> list2) {
        for (int i = 0; i < list2.size(); ++i) {
            SortedConfigurableGroup group;
            Configurable configurable = list2.get(i);
            if (!(configurable instanceof SortedConfigurableGroup) || (configurable = ConfigurableExtensionPointUtil.getConfigurableToReplace(group.myList, (group = (SortedConfigurableGroup)configurable).getWeight())) == null) continue;
            list2.set(i, configurable);
        }
    }

    private static Configurable getConfigurableToReplace(List<Configurable> list2, int weight) {
        if (list2 != null) {
            ConfigurableExtensionPointUtil.replaceGroupWithSingleConfigurable(list2);
            if (1 == list2.size()) {
                Configurable configurable = list2.get(0);
                if (configurable instanceof SortedConfigurableGroup) {
                    SortedConfigurableGroup group = (SortedConfigurableGroup)configurable;
                    group.myWeight = weight;
                    return group;
                }
                if (configurable instanceof ConfigurableWrapper) {
                    ConfigurableWrapper wrapper = (ConfigurableWrapper)configurable;
                    wrapper.myWeight = weight;
                    return wrapper;
                }
            }
        }
        return null;
    }

    private static SortedConfigurableGroup getGroup(Map<String, Node<SortedConfigurableGroup>> tree, String groupId) {
        Node<SortedConfigurableGroup> node = tree.remove(groupId);
        if (node.myChildren != null) {
            Iterator<Object> iterator = node.myChildren.iterator();
            while (iterator.hasNext()) {
                String childId = (String)iterator.next();
                ((SortedConfigurableGroup)node.myValue).myList.add((Configurable)ConfigurableExtensionPointUtil.getGroup(tree, childId));
                iterator.remove();
            }
        }
        return (SortedConfigurableGroup)node.myValue;
    }

    private static void addGroup(Map<String, Node<SortedConfigurableGroup>> tree, Project project2, String groupId, List<Configurable> configurables, ResourceBundle alternative) {
        String id = "configurable.group." + groupId;
        ResourceBundle bundle = ConfigurableExtensionPointUtil.getBundle(id + ".settings.display.name", configurables, alternative);
        if (bundle == null) {
            bundle = OptionsBundle.getBundle();
            if ("root".equals(groupId)) {
                try {
                    String value2 = bundle.getString("configurable.group.root.settings.display.name");
                    LOG.error("OptionsBundle does not contain root group", new String[]{value2});
                }
                catch (Exception exception) {
                    LOG.error("OptionsBundle does not contain root group", (Throwable)exception);
                }
            } else {
                LOG.warn("use other group instead of unexpected one: " + groupId);
                groupId = "other";
                id = "configurable.group." + groupId;
            }
        }
        Node node = Node.get(tree, groupId);
        if (node.myValue == null) {
            int weight = ConfigurableExtensionPointUtil.getInt(bundle, id + ".settings.weight");
            String help = ConfigurableExtensionPointUtil.getString(bundle, id + ".settings.help.topic");
            String name2 = ConfigurableExtensionPointUtil.getString(bundle, id + ".settings.display.name");
            if (name2 != null && project2 != null) {
                if (!project2.isDefault() && !name2.contains("{")) {
                    String named = ConfigurableExtensionPointUtil.getString(bundle, id + ".named.settings.display.name");
                    String string = name2 = named != null ? named : name2;
                }
                if (name2.contains("{")) {
                    name2 = StringUtil.first((String)MessageFormat.format(name2, project2.getName()), (int)30, (boolean)true);
                }
            }
            node.myValue = new SortedConfigurableGroup(id, name2, help, weight);
        }
        if (configurables != null) {
            ((SortedConfigurableGroup)node.myValue).myList.addAll(configurables);
        }
        if (node.myParent == null && !groupId.equals("root")) {
            String parentId = ConfigurableExtensionPointUtil.getString(bundle, id + ".settings.parent");
            parentId = (String)Node.cyclic(tree, parentId, "root", groupId, node);
            node.myParent = Node.add(tree, parentId, groupId);
            ConfigurableExtensionPointUtil.addGroup(tree, project2, parentId, null, bundle);
        }
    }

    public static Map<String, List<Configurable>> groupConfigurables(@NotNull List<Configurable> configurables) {
        if (configurables == null) {
            ConfigurableExtensionPointUtil.$$$reportNull$$$0(10);
        }
        THashMap tree = new THashMap();
        for (Configurable configurable : configurables) {
            String id;
            if (!(configurable instanceof ConfigurableWrapper)) {
                Node.add((Map)tree, "other", configurable);
                continue;
            }
            ConfigurableWrapper wrapper = (ConfigurableWrapper)configurable;
            try {
                id = wrapper.getId();
            }
            catch (Throwable e) {
                LOG.error("Cannot create configurable", e);
                continue;
            }
            Node node = Node.get((Map)tree, id);
            if (node.myValue != null) {
                LOG.warn("ignore configurable with duplicated id: " + id);
                continue;
            }
            String parentId = wrapper.getParentId();
            String groupId = wrapper.getExtensionPoint().groupId;
            if (groupId != null) {
                if (parentId != null) {
                    LOG.warn("ignore deprecated groupId: " + groupId + " for id: " + id);
                } else {
                    parentId = groupId;
                }
            }
            parentId = (String)Node.cyclic((Map)tree, parentId, "other", id, node);
            node.myParent = Node.add((Map)tree, parentId, node);
            node.myValue = wrapper;
        }
        THashMap map = new THashMap();
        for (String id : ArrayUtilRt.toStringArray(tree.keySet())) {
            List<Configurable> list2;
            Node node = (Node)tree.get(id);
            if (node == null || (list2 = ConfigurableExtensionPointUtil.getConfigurables((Map<String, Node<ConfigurableWrapper>>)tree, node)) == null) continue;
            map.put(id, list2);
            tree.remove(id);
        }
        return map;
    }

    private static List<Configurable> getConfigurables(Map<String, Node<ConfigurableWrapper>> tree, Node<ConfigurableWrapper> node) {
        if (node.myChildren == null) {
            if (node.myValue == null) {
                return ContainerUtil.newArrayList();
            }
            return null;
        }
        ArrayList list2 = ContainerUtil.newArrayListWithCapacity((int)node.myChildren.size());
        Iterator<Object> iterator = node.myChildren.iterator();
        while (iterator.hasNext()) {
            Object child = iterator.next();
            if (child instanceof Configurable) {
                list2.add((Configurable)child);
            } else {
                Node value2 = (Node)child;
                if (ConfigurableExtensionPointUtil.getConfigurables(tree, value2) != null) {
                    throw new IllegalStateException("unexpected algorithm state");
                }
                list2.add(value2.myValue);
                tree.remove(((ConfigurableWrapper)value2.myValue).getId());
            }
            iterator.remove();
        }
        if (node.myValue == null) {
            return list2;
        }
        for (Configurable configurable : list2) {
            node.myValue = ((ConfigurableWrapper)node.myValue).addChild(configurable);
        }
        return null;
    }

    private static List<Configurable> getConfigurables(@Nullable Project project2, boolean withIdeSettings) {
        Application application;
        ArrayList list2 = ContainerUtil.newArrayList();
        if (withIdeSettings && (application = ApplicationManager.getApplication()) != null) {
            ConfigurableEP[] configurableEPArray = (ConfigurableEP[])application.getExtensions(Configurable.APPLICATION_CONFIGURABLE);
            int n = configurableEPArray.length;
            for (int i = 0; i < n; ++i) {
                ConfigurableEP extension = configurableEPArray[i];
                ConfigurableExtensionPointUtil.addValid(list2, (Configurable)ConfigurableWrapper.wrapConfigurable(extension, true), null);
            }
        }
        if (project2 != null && !project2.isDisposed()) {
            for (ConfigurableEP extension : (ConfigurableEP[])project2.getExtensions(Configurable.PROJECT_CONFIGURABLE)) {
                ConfigurableExtensionPointUtil.addValid(list2, (Configurable)ConfigurableWrapper.wrapConfigurable(extension, true), project2);
            }
        }
        return list2;
    }

    private static void addValid(List<Configurable> list2, Configurable configurable, Project project2) {
        if (ConfigurableExtensionPointUtil.isValid(configurable, project2)) {
            list2.add(configurable);
        }
    }

    private static boolean isValid(Configurable configurable, Project project2) {
        if (configurable == null) {
            return false;
        }
        OptionalConfigurable optional = ConfigurableWrapper.cast(OptionalConfigurable.class, (UnnamedConfigurable)configurable);
        if (optional != null && !optional.needDisplay()) {
            return false;
        }
        return project2 == null || !project2.isDefault() || !ConfigurableWrapper.isNonDefaultProject(configurable);
    }

    @Nullable
    public static ResourceBundle getBundle(@NotNull String resource, @Nullable Iterable<Configurable> configurables, @Nullable ResourceBundle alternative) {
        ResourceBundle bundle;
        if (resource == null) {
            ConfigurableExtensionPointUtil.$$$reportNull$$$0(11);
        }
        if (ConfigurableExtensionPointUtil.getString(bundle = OptionsBundle.getBundle(), resource) != null) {
            return bundle;
        }
        if (configurables != null) {
            for (Configurable configurable : configurables) {
                ConfigurableWrapper wrapper;
                if (!(configurable instanceof ConfigurableWrapper) || ConfigurableExtensionPointUtil.getString(bundle = (wrapper = (ConfigurableWrapper)configurable).getExtensionPoint().findBundle(), resource) == null) continue;
                return bundle;
            }
        }
        if (ConfigurableExtensionPointUtil.getString(alternative, resource) != null) {
            return alternative;
        }
        return null;
    }

    private static String getString(ResourceBundle bundle, String resource) {
        if (bundle == null) {
            return null;
        }
        try {
            return BundleBase.replaceMnemonicAmpersand((String)bundle.getString(resource));
        }
        catch (MissingResourceException ignored) {
            return null;
        }
    }

    private static int getInt(ResourceBundle bundle, String resource) {
        try {
            String value2 = ConfigurableExtensionPointUtil.getString(bundle, resource);
            return value2 == null ? 0 : Integer.parseInt(value2);
        }
        catch (NumberFormatException ignored) {
            return 0;
        }
    }

    private static boolean isSuppressed(Configurable each, ConfigurableFilter filter2) {
        return !ConfigurableExtensionPointUtil.isValid(each, null) || filter2 != null && !filter2.isIncluded(each);
    }

    @NotNull
    public static <T extends Configurable> T findProjectConfigurable(@NotNull Project project2, @NotNull Class<T> configurableClass) {
        if (project2 == null) {
            ConfigurableExtensionPointUtil.$$$reportNull$$$0(12);
        }
        if (configurableClass == null) {
            ConfigurableExtensionPointUtil.$$$reportNull$$$0(13);
        }
        T t = ConfigurableExtensionPointUtil.findConfigurable((ConfigurableEP[])project2.getExtensions(Configurable.PROJECT_CONFIGURABLE), configurableClass);
        if (t == null) {
            ConfigurableExtensionPointUtil.$$$reportNull$$$0(14);
        }
        return t;
    }

    @NotNull
    public static <T extends Configurable> T findApplicationConfigurable(@NotNull Class<T> configurableClass) {
        if (configurableClass == null) {
            ConfigurableExtensionPointUtil.$$$reportNull$$$0(15);
        }
        T t = ConfigurableExtensionPointUtil.findConfigurable((ConfigurableEP[])Configurable.APPLICATION_CONFIGURABLE.getExtensions(), configurableClass);
        if (t == null) {
            ConfigurableExtensionPointUtil.$$$reportNull$$$0(16);
        }
        return t;
    }

    @NotNull
    private static <T extends Configurable> T findConfigurable(ConfigurableEP<Configurable>[] extensions, Class<T> configurableClass) {
        for (ConfigurableEP<Configurable> extension : extensions) {
            Configurable configurable;
            if (!extension.canCreateConfigurable() || !configurableClass.isInstance(configurable = (Configurable)extension.createConfigurable())) continue;
            Configurable configurable2 = (Configurable)configurableClass.cast(configurable);
            if (configurable2 == null) {
                ConfigurableExtensionPointUtil.$$$reportNull$$$0(17);
            }
            return (T)configurable2;
        }
        throw new IllegalArgumentException("Cannot find configurable of " + configurableClass);
    }

    @Nullable
    public static Configurable createProjectConfigurableForProvider(@NotNull Project project2, Class<? extends ConfigurableProvider> providerClass) {
        if (project2 == null) {
            ConfigurableExtensionPointUtil.$$$reportNull$$$0(18);
        }
        return ConfigurableExtensionPointUtil.createConfigurableForProvider((ConfigurableEP[])project2.getExtensions(Configurable.PROJECT_CONFIGURABLE), providerClass);
    }

    @Nullable
    public static Configurable createApplicationConfigurableForProvider(Class<? extends ConfigurableProvider> providerClass) {
        return ConfigurableExtensionPointUtil.createConfigurableForProvider((ConfigurableEP[])Configurable.APPLICATION_CONFIGURABLE.getExtensions(), providerClass);
    }

    @Nullable
    private static Configurable createConfigurableForProvider(ConfigurableEP<Configurable>[] extensions, Class<? extends ConfigurableProvider> providerClass) {
        for (ConfigurableEP<Configurable> extension : extensions) {
            Class aClass;
            if (extension.providerClass == null || (aClass = extension.findClassNoExceptions(extension.providerClass)) == null || !providerClass.isAssignableFrom(aClass)) continue;
            return (Configurable)extension.createConfigurable();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 14: 
            case 16: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 14: 
            case 16: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "idToConfigurable";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visited";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "idTree";
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 14: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/options/ex/ConfigurableExtensionPointUtil";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "idsInEpOrder";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurables";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resource";
                break;
            }
            case 12: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurableClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/options/ex/ConfigurableExtensionPointUtil";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "addChildrenRec";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "buildIdTree";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "findProjectConfigurable";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "findApplicationConfigurable";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "findConfigurable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addChildrenRec";
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 14: 
            case 16: 
            case 17: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "buildIdTree";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getConfigurableGroup";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "groupConfigurables";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getBundle";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "findProjectConfigurable";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "findApplicationConfigurable";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "createProjectConfigurableForProvider";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 14: 
            case 16: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class Node<V> {
        List<Object> myChildren;
        Node<V> myParent;
        V myValue;

        private Node() {
        }

        private static <I, V> Node<V> get(@NotNull Map<I, Node<V>> tree, @NotNull I id) {
            Node<V> node;
            if (tree == null) {
                Node.$$$reportNull$$$0(0);
            }
            if (id == null) {
                Node.$$$reportNull$$$0(1);
            }
            if ((node = tree.get(id)) == null) {
                node = new Node<V>();
                tree.put(id, node);
            }
            return node;
        }

        private static <I, V> Node<V> add(@NotNull Map<I, Node<V>> tree, @NotNull I id, Object child) {
            if (tree == null) {
                Node.$$$reportNull$$$0(2);
            }
            if (id == null) {
                Node.$$$reportNull$$$0(3);
            }
            Node<V> node = Node.get(tree, id);
            if (node.myChildren == null) {
                node.myChildren = new SmartList();
            }
            node.myChildren.add(child);
            return node;
        }

        private static <I, V> boolean cyclic(@NotNull Map<I, Node<V>> tree, @NotNull I id, Node<V> parent) {
            if (tree == null) {
                Node.$$$reportNull$$$0(4);
            }
            if (id == null) {
                Node.$$$reportNull$$$0(5);
            }
            Node<V> node = tree.get(id);
            while (node != null) {
                if (node == parent) {
                    return true;
                }
                node = node.myParent;
            }
            return false;
        }

        private static <I, V> I cyclic(@NotNull Map<I, Node<V>> tree, @Nullable I id, I idDefault, I idNode, Node<V> parent) {
            if (tree == null) {
                Node.$$$reportNull$$$0(6);
            }
            if (id == null) {
                id = idDefault;
            }
            if (Node.cyclic(tree, id, parent)) {
                LOG.warn("ignore cyclic dependency: " + id + " cannot contain " + idNode);
                id = idDefault;
            }
            return id;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tree";
                    break;
                }
                case 1: 
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "id";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/options/ex/ConfigurableExtensionPointUtil$Node";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "get";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "add";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "cyclic";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

