/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.project;

import com.intellij.ide.caches.FileContent;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationAdapter;
import com.intellij.openapi.application.ApplicationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.progress.util.ProgressWrapper;
import com.intellij.openapi.project.FileContentQueue;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;

public class CacheUpdateRunner {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.project.CacheUpdateRunner");
    private static final Key<Boolean> FAILED_TO_INDEX = Key.create((String)"FAILED_TO_INDEX");
    private static final int PROC_COUNT = Runtime.getRuntime().availableProcessors();
    public static final int DEFAULT_MAX_INDEXER_THREADS = 4;

    public static void processFiles(final ProgressIndicator indicator, Collection<VirtualFile> files, Project project2, Consumer<FileContent> processor2) {
        indicator.checkCanceled();
        FileContentQueue queue2 = new FileContentQueue(files, indicator);
        final double total = files.size();
        queue2.startLoading();
        ProgressUpdater progressUpdater = new ProgressUpdater(){
            final Set<VirtualFile> myFilesBeingProcessed = new THashSet();
            final AtomicInteger myNumberOfFilesProcessed = new AtomicInteger();

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void processingStarted(VirtualFile virtualFile) {
                boolean added;
                indicator.checkCanceled();
                Set<VirtualFile> set2 = this.myFilesBeingProcessed;
                synchronized (set2) {
                    added = this.myFilesBeingProcessed.add(virtualFile);
                }
                if (added) {
                    indicator.setFraction((double)this.myNumberOfFilesProcessed.incrementAndGet() / total);
                    VirtualFile parent = virtualFile.getParent();
                    if (parent != null) {
                        indicator.setText2(parent.getPresentableUrl());
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void processingSuccessfullyFinished(VirtualFile virtualFile) {
                Set<VirtualFile> set2 = this.myFilesBeingProcessed;
                synchronized (set2) {
                    boolean removed = this.myFilesBeingProcessed.remove(virtualFile);
                    assert (removed);
                }
            }
        };
        while (!project2.isDisposed()) {
            indicator.checkCanceled();
            if (!CacheUpdateRunner.processSomeFilesWhileUserIsInactive(queue2, progressUpdater, indicator, project2, processor2)) continue;
        }
        if (project2.isDisposed()) {
            indicator.cancel();
            indicator.checkCanceled();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean processSomeFilesWhileUserIsInactive(@NotNull FileContentQueue queue2, @NotNull ProgressUpdater progressUpdater, @NotNull ProgressIndicator suspendableIndicator, @NotNull Project project2, @NotNull Consumer<FileContent> fileProcessor) {
        if (queue2 == null) {
            CacheUpdateRunner.$$$reportNull$$$0(0);
        }
        if (progressUpdater == null) {
            CacheUpdateRunner.$$$reportNull$$$0(1);
        }
        if (suspendableIndicator == null) {
            CacheUpdateRunner.$$$reportNull$$$0(2);
        }
        if (project2 == null) {
            CacheUpdateRunner.$$$reportNull$$$0(3);
        }
        if (fileProcessor == null) {
            CacheUpdateRunner.$$$reportNull$$$0(4);
        }
        final ProgressIndicatorBase innerIndicator = new ProgressIndicatorBase(){

            @Override
            protected boolean isCancelable() {
                return true;
            }
        };
        ApplicationAdapter canceller = new ApplicationAdapter(){

            public void beforeWriteActionStart(@NotNull Object action) {
                if (action == null) {
                    3.$$$reportNull$$$0(0);
                }
                innerIndicator.cancel();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/openapi/project/CacheUpdateRunner$3", "beforeWriteActionStart"));
            }
        };
        Application application = ApplicationManager.getApplication();
        application.invokeAndWait(() -> application.addApplicationListener((ApplicationListener)canceller), ModalityState.any());
        AtomicBoolean isFinished = new AtomicBoolean();
        try {
            int threadsCount = CacheUpdateRunner.indexingThreadCount();
            if (threadsCount == 1 || application.isWriteAccessAllowed()) {
                MyRunnable process2 = new MyRunnable(innerIndicator, suspendableIndicator, queue2, isFinished, progressUpdater, project2, fileProcessor);
                ProgressManager.getInstance().runProcess((Runnable)process2, (ProgressIndicator)innerIndicator);
            } else {
                AtomicBoolean[] finishedRefs = new AtomicBoolean[threadsCount];
                Future[] futures = new Future[threadsCount];
                for (int i = 0; i < threadsCount; ++i) {
                    AtomicBoolean ref;
                    finishedRefs[i] = ref = new AtomicBoolean();
                    MyRunnable process3 = new MyRunnable(innerIndicator, suspendableIndicator, queue2, ref, progressUpdater, project2, fileProcessor);
                    futures[i] = application.executeOnPooledThread((Runnable)process3);
                }
                isFinished.set(CacheUpdateRunner.waitForAll(finishedRefs, futures));
            }
        }
        finally {
            application.removeApplicationListener((ApplicationListener)canceller);
        }
        return isFinished.get();
    }

    public static int indexingThreadCount() {
        int threadsCount = Registry.intValue((String)"caches.indexerThreadsCount");
        if (threadsCount <= 0) {
            int coresToLeaveForOtherActivity = ApplicationManager.getApplication().isCommandLine() ? 0 : 1;
            threadsCount = Math.max(1, Math.min(PROC_COUNT - coresToLeaveForOtherActivity, 4));
        }
        return threadsCount;
    }

    private static boolean waitForAll(@NotNull AtomicBoolean[] finishedRefs, @NotNull Future<?>[] futures) {
        if (finishedRefs == null) {
            CacheUpdateRunner.$$$reportNull$$$0(5);
        }
        if (futures == null) {
            CacheUpdateRunner.$$$reportNull$$$0(6);
        }
        assert (!ApplicationManager.getApplication().isWriteAccessAllowed());
        try {
            for (Future<?> future2 : futures) {
                future2.get();
            }
            boolean allFinished = true;
            for (AtomicBoolean ref : finishedRefs) {
                if (ref.get()) continue;
                allFinished = false;
                break;
            }
            return allFinished;
        }
        catch (InterruptedException allFinished) {
        }
        catch (Throwable throwable) {
            LOG.error(throwable);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "queue";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressUpdater";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suspendableIndicator";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileProcessor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "finishedRefs";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "futures";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/project/CacheUpdateRunner";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "processSomeFilesWhileUserIsInactive";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "waitForAll";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MyRunnable
    implements Runnable {
        private final ProgressIndicatorBase myInnerIndicator;
        private final ProgressIndicator mySuspendableIndicator;
        private final FileContentQueue myQueue;
        private final AtomicBoolean myFinished;
        private final ProgressUpdater myProgressUpdater;
        @NotNull
        private final Project myProject;
        @NotNull
        private final Consumer<FileContent> myProcessor;

        MyRunnable(@NotNull ProgressIndicatorBase innerIndicator, @NotNull ProgressIndicator suspendableIndicator, @NotNull FileContentQueue queue2, @NotNull AtomicBoolean finished2, @NotNull ProgressUpdater progressUpdater, @NotNull Project project2, @NotNull Consumer<FileContent> fileProcessor) {
            if (innerIndicator == null) {
                MyRunnable.$$$reportNull$$$0(0);
            }
            if (suspendableIndicator == null) {
                MyRunnable.$$$reportNull$$$0(1);
            }
            if (queue2 == null) {
                MyRunnable.$$$reportNull$$$0(2);
            }
            if (finished2 == null) {
                MyRunnable.$$$reportNull$$$0(3);
            }
            if (progressUpdater == null) {
                MyRunnable.$$$reportNull$$$0(4);
            }
            if (project2 == null) {
                MyRunnable.$$$reportNull$$$0(5);
            }
            if (fileProcessor == null) {
                MyRunnable.$$$reportNull$$$0(6);
            }
            this.myInnerIndicator = innerIndicator;
            this.mySuspendableIndicator = suspendableIndicator;
            this.myQueue = queue2;
            this.myFinished = finished2;
            this.myProgressUpdater = progressUpdater;
            this.myProject = project2;
            this.myProcessor = fileProcessor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!this.myProject.isDisposed() && !this.myInnerIndicator.isCanceled()) {
                try {
                    this.mySuspendableIndicator.checkCanceled();
                    FileContent fileContent = this.myQueue.take(this.myInnerIndicator);
                    if (fileContent == null) {
                        this.myFinished.set(true);
                        return;
                    }
                    Runnable action = () -> {
                        this.myInnerIndicator.checkCanceled();
                        if (!this.myProject.isDisposed()) {
                            VirtualFile file2 = fileContent.getVirtualFile();
                            try {
                                this.myProgressUpdater.processingStarted(file2);
                                if (!file2.isDirectory() && !Boolean.TRUE.equals(file2.getUserData(FAILED_TO_INDEX))) {
                                    this.myProcessor.consume((Object)fileContent);
                                }
                                this.myProgressUpdater.processingSuccessfullyFinished(file2);
                            }
                            catch (ProcessCanceledException e) {
                                throw e;
                            }
                            catch (Throwable e) {
                                MyRunnable.handleIndexingException(file2, e);
                            }
                        }
                    };
                    try {
                        ProgressManager.getInstance().runProcess(() -> {
                            if (!ApplicationManagerEx.getApplicationEx().tryRunReadAction(action)) {
                                throw new ProcessCanceledException();
                            }
                        }, (ProgressIndicator)ProgressWrapper.wrap(this.myInnerIndicator));
                    }
                    catch (ProcessCanceledException e) {
                        this.myQueue.pushBack(fileContent);
                        return;
                    }
                    finally {
                        this.myQueue.release(fileContent);
                    }
                }
                catch (ProcessCanceledException e) {
                    return;
                }
            }
            return;
        }

        private static void handleIndexingException(VirtualFile file2, Throwable e) {
            String message2 = "Error while indexing " + file2.getPresentableUrl() + "\nTo reindex this file IDEA has to be restarted";
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                System.err.println(message2);
                e.printStackTrace();
            } else {
                LOG.error(message2, e);
            }
            file2.putUserData(FAILED_TO_INDEX, (Object)Boolean.TRUE);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "innerIndicator";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "suspendableIndicator";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "queue";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "finished";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[0] = "progressUpdater";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[0] = "fileProcessor";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/project/CacheUpdateRunner$MyRunnable";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static interface ProgressUpdater {
        public void processingStarted(VirtualFile var1);

        public void processingSuccessfullyFinished(VirtualFile var1);
    }
}

