/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.PersistentOrderRootType;
import com.intellij.openapi.roots.RootProvider;
import com.intellij.openapi.vfs.JarCopyingFileSystem;
import com.intellij.openapi.vfs.StandardFileSystems;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerContainer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerListener;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.util.ArrayUtilRt;
import gnu.trove.THashMap;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class RootsAsVirtualFilePointers
implements RootProvider {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.projectRoots.impl.ProjectRootContainerImpl");
    private final Map<OrderRootType, VirtualFilePointerContainer> myRoots;
    private final boolean myNoCopyJars;

    RootsAsVirtualFilePointers(boolean noCopyJars, VirtualFilePointerListener listener2, @NotNull Disposable parent) {
        if (parent == null) {
            RootsAsVirtualFilePointers.$$$reportNull$$$0(0);
        }
        this.myRoots = new THashMap();
        this.myNoCopyJars = noCopyJars;
        for (OrderRootType rootType : OrderRootType.getAllTypes()) {
            this.myRoots.put(rootType, VirtualFilePointerManager.getInstance().createContainer(parent, listener2));
        }
    }

    @NotNull
    public VirtualFile[] getFiles(@NotNull OrderRootType type2) {
        VirtualFilePointerContainer container;
        if (type2 == null) {
            RootsAsVirtualFilePointers.$$$reportNull$$$0(1);
        }
        VirtualFile[] virtualFileArray = (container = this.myRoots.get(type2)) == null ? VirtualFile.EMPTY_ARRAY : container.getFiles();
        if (virtualFileArray == null) {
            RootsAsVirtualFilePointers.$$$reportNull$$$0(2);
        }
        return virtualFileArray;
    }

    @NotNull
    public String[] getUrls(@NotNull OrderRootType type2) {
        VirtualFilePointerContainer container;
        if (type2 == null) {
            RootsAsVirtualFilePointers.$$$reportNull$$$0(3);
        }
        String[] stringArray = (container = this.myRoots.get(type2)) == null ? ArrayUtilRt.EMPTY_STRING_ARRAY : container.getUrls();
        if (stringArray == null) {
            RootsAsVirtualFilePointers.$$$reportNull$$$0(4);
        }
        return stringArray;
    }

    public void addRoot(@NotNull VirtualFile virtualFile, @NotNull OrderRootType type2) {
        if (virtualFile == null) {
            RootsAsVirtualFilePointers.$$$reportNull$$$0(5);
        }
        if (type2 == null) {
            RootsAsVirtualFilePointers.$$$reportNull$$$0(6);
        }
        this.myRoots.get(type2).add(virtualFile);
    }

    public void removeAllRoots(@NotNull OrderRootType type2) {
        if (type2 == null) {
            RootsAsVirtualFilePointers.$$$reportNull$$$0(7);
        }
        this.myRoots.get(type2).clear();
    }

    public void removeRoot(@NotNull VirtualFile root, @NotNull OrderRootType type2) {
        VirtualFilePointerContainer container;
        VirtualFilePointer pointer;
        if (root == null) {
            RootsAsVirtualFilePointers.$$$reportNull$$$0(8);
        }
        if (type2 == null) {
            RootsAsVirtualFilePointers.$$$reportNull$$$0(9);
        }
        if ((pointer = (container = this.myRoots.get(type2)).findByUrl(root.getUrl())) != null) {
            container.remove(pointer);
        }
    }

    public void removeAllRoots() {
        for (VirtualFilePointerContainer myRoot : this.myRoots.values()) {
            myRoot.clear();
        }
    }

    public void readExternal(@NotNull Element element) {
        if (element == null) {
            RootsAsVirtualFilePointers.$$$reportNull$$$0(10);
        }
        for (PersistentOrderRootType persistentOrderRootType : OrderRootType.getAllPersistentTypes()) {
            this.read(element, persistentOrderRootType);
        }
        ApplicationManager.getApplication().runReadAction(() -> this.myRoots.values().forEach(container -> {
            if (this.myNoCopyJars) {
                for (String root : container.getUrls()) {
                    RootsAsVirtualFilePointers.setNoCopyJars(root);
                }
            }
        }));
        for (PersistentOrderRootType persistentOrderRootType : OrderRootType.getAllTypes()) {
            if (this.myRoots.get(persistentOrderRootType) != null) continue;
            LOG.error(persistentOrderRootType + " wasn't serialized");
        }
    }

    public void writeExternal(@NotNull Element element) {
        if (element == null) {
            RootsAsVirtualFilePointers.$$$reportNull$$$0(11);
        }
        List allTypes = OrderRootType.getSortedRootTypes();
        for (PersistentOrderRootType type2 : allTypes) {
            this.write(element, type2);
        }
    }

    void copyRootsFrom(@NotNull RootProvider rootContainer) {
        if (rootContainer == null) {
            RootsAsVirtualFilePointers.$$$reportNull$$$0(12);
        }
        this.removeAllRoots();
        for (OrderRootType rootType : OrderRootType.getAllTypes()) {
            VirtualFile[] newRoots;
            for (VirtualFile newRoot : newRoots = rootContainer.getFiles(rootType)) {
                this.addRoot(newRoot, rootType);
            }
        }
    }

    private static void setNoCopyJars(@NotNull String url) {
        if (url == null) {
            RootsAsVirtualFilePointers.$$$reportNull$$$0(13);
        }
        if ("jar".equals(VirtualFileManager.extractProtocol((String)url))) {
            String path = VirtualFileManager.extractPath((String)url);
            VirtualFileSystem fileSystem = StandardFileSystems.jar();
            if (fileSystem instanceof JarCopyingFileSystem) {
                ((JarCopyingFileSystem)fileSystem).setNoCopyJarForPath(path);
            }
        }
    }

    private void read(@NotNull Element roots, @NotNull PersistentOrderRootType type2) {
        String sdkRootName;
        Element child;
        if (roots == null) {
            RootsAsVirtualFilePointers.$$$reportNull$$$0(14);
        }
        if (type2 == null) {
            RootsAsVirtualFilePointers.$$$reportNull$$$0(15);
        }
        Element element = child = (sdkRootName = type2.getSdkRootName()) != null ? roots.getChild(sdkRootName) : null;
        if (child == null) {
            return;
        }
        List composites = child.getChildren();
        if (composites.size() != 1) {
            LOG.error((Object)composites);
        }
        Element composite = (Element)composites.get(0);
        this.myRoots.get(type2).readExternal(composite, "root", false);
    }

    private void write(@NotNull Element roots, @NotNull PersistentOrderRootType type2) {
        String sdkRootName;
        if (roots == null) {
            RootsAsVirtualFilePointers.$$$reportNull$$$0(16);
        }
        if (type2 == null) {
            RootsAsVirtualFilePointers.$$$reportNull$$$0(17);
        }
        if ((sdkRootName = type2.getSdkRootName()) == null) {
            return;
        }
        Element e = new Element(sdkRootName);
        roots.addContent(e);
        Element composite = new Element("root");
        composite.setAttribute("type", "composite");
        e.addContent(composite);
        this.myRoots.get(type2).writeExternal(composite, "root", false);
        for (Element root : composite.getChildren()) {
            root.setAttribute("type", "simple");
        }
    }

    public void addRootSetChangedListener(@NotNull RootProvider.RootSetChangedListener listener2) {
        if (listener2 == null) {
            RootsAsVirtualFilePointers.$$$reportNull$$$0(18);
        }
        throw new RuntimeException();
    }

    public void addRootSetChangedListener(@NotNull RootProvider.RootSetChangedListener listener2, @NotNull Disposable parentDisposable) {
        if (listener2 == null) {
            RootsAsVirtualFilePointers.$$$reportNull$$$0(19);
        }
        if (parentDisposable == null) {
            RootsAsVirtualFilePointers.$$$reportNull$$$0(20);
        }
        throw new RuntimeException();
    }

    public void removeRootSetChangedListener(@NotNull RootProvider.RootSetChangedListener listener2) {
        if (listener2 == null) {
            RootsAsVirtualFilePointers.$$$reportNull$$$0(21);
        }
        throw new RuntimeException();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 7: 
            case 9: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/projectRoots/impl/RootsAsVirtualFilePointers";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootContainer";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
            case 18: 
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/projectRoots/impl/RootsAsVirtualFilePointers";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFiles";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getUrls";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getFiles";
                break;
            }
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getUrls";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addRoot";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "removeAllRoots";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "removeRoot";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "copyRootsFrom";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "setNoCopyJars";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "read";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "write";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "addRootSetChangedListener";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "removeRootSetChangedListener";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

