/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl.libraries;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectModelExternalSource;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.impl.libraries.LibraryImpl;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.PersistentLibraryKind;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.EventDispatcher;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LibraryTableBase
implements PersistentStateComponent<Element>,
LibraryTable,
Disposable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.roots.impl.libraries.LibraryTableBase");
    private final EventDispatcher<LibraryTable.Listener> myDispatcher = EventDispatcher.create(LibraryTable.Listener.class);
    private LibraryModel myModel = new LibraryModel();
    private boolean myFirstLoad = true;
    private volatile long myModificationCount;

    @NotNull
    public LibraryTable.ModifiableModel getModifiableModel() {
        LibraryModel libraryModel = new LibraryModel(this.myModel);
        if (libraryModel == null) {
            LibraryTableBase.$$$reportNull$$$0(0);
        }
        return libraryModel;
    }

    public Element getState() {
        Element element = new Element("state");
        try {
            this.myModel.writeExternal(element);
        }
        catch (WriteExternalException e) {
            LOG.error((Throwable)e);
        }
        return element;
    }

    public void noStateLoaded() {
        this.myFirstLoad = false;
    }

    public void loadState(Element element) {
        if (this.myFirstLoad) {
            this.myModel.readExternal(element);
        } else {
            LibraryModel model = new LibraryModel(this.myModel);
            WriteAction.run(() -> {
                model.readExternal(element);
                this.commit(model);
            });
        }
        this.myFirstLoad = false;
    }

    public long getStateModificationCount() {
        return this.myModificationCount;
    }

    @NotNull
    public Library[] getLibraries() {
        Library[] libraryArray = this.myModel.getLibraries();
        if (libraryArray == null) {
            LibraryTableBase.$$$reportNull$$$0(1);
        }
        return libraryArray;
    }

    @NotNull
    public Iterator<Library> getLibraryIterator() {
        Iterator<Library> iterator = this.myModel.getLibraryIterator();
        if (iterator == null) {
            LibraryTableBase.$$$reportNull$$$0(2);
        }
        return iterator;
    }

    public Library getLibraryByName(@NotNull String name2) {
        if (name2 == null) {
            LibraryTableBase.$$$reportNull$$$0(3);
        }
        return this.myModel.getLibraryByName(name2);
    }

    public void addListener(@NotNull LibraryTable.Listener listener2) {
        if (listener2 == null) {
            LibraryTableBase.$$$reportNull$$$0(4);
        }
        this.myDispatcher.addListener((EventListener)listener2);
    }

    public void addListener(@NotNull LibraryTable.Listener listener2, @NotNull Disposable parentDisposable) {
        if (listener2 == null) {
            LibraryTableBase.$$$reportNull$$$0(5);
        }
        if (parentDisposable == null) {
            LibraryTableBase.$$$reportNull$$$0(6);
        }
        this.myDispatcher.addListener((EventListener)listener2, parentDisposable);
    }

    public void removeListener(@NotNull LibraryTable.Listener listener2) {
        if (listener2 == null) {
            LibraryTableBase.$$$reportNull$$$0(7);
        }
        this.myDispatcher.removeListener((EventListener)listener2);
    }

    private void fireLibraryAdded(@NotNull Library library) {
        if (library == null) {
            LibraryTableBase.$$$reportNull$$$0(8);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("fireLibraryAdded: " + library);
        }
        ((LibraryTable.Listener)this.myDispatcher.getMulticaster()).afterLibraryAdded(library);
    }

    private void fireBeforeLibraryRemoved(@NotNull Library library) {
        if (library == null) {
            LibraryTableBase.$$$reportNull$$$0(9);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("fireBeforeLibraryRemoved: " + library);
        }
        ((LibraryTable.Listener)this.myDispatcher.getMulticaster()).beforeLibraryRemoved(library);
    }

    public void dispose() {
        for (Library library : this.getLibraries()) {
            Disposer.dispose((Disposable)library);
        }
    }

    @NotNull
    public Library createLibrary() {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        Library library = this.createLibrary(null);
        if (library == null) {
            LibraryTableBase.$$$reportNull$$$0(10);
        }
        return library;
    }

    void fireLibraryRenamed(@NotNull LibraryImpl library) {
        if (library == null) {
            LibraryTableBase.$$$reportNull$$$0(11);
        }
        this.incrementModificationCount();
        ((LibraryTable.Listener)this.myDispatcher.getMulticaster()).afterLibraryRenamed((Library)library);
    }

    private void incrementModificationCount() {
        if (Registry.is((String)"store.track.module.root.manager.changes", (boolean)false)) {
            LOG.error("library");
        }
        ++this.myModificationCount;
    }

    @NotNull
    public Library createLibrary(String name2) {
        LibraryTable.ModifiableModel modifiableModel = this.getModifiableModel();
        Library library = modifiableModel.createLibrary(name2);
        modifiableModel.commit();
        Library library2 = library;
        if (library2 == null) {
            LibraryTableBase.$$$reportNull$$$0(12);
        }
        return library2;
    }

    public void removeLibrary(@NotNull Library library) {
        if (library == null) {
            LibraryTableBase.$$$reportNull$$$0(13);
        }
        LibraryTable.ModifiableModel modifiableModel = this.getModifiableModel();
        modifiableModel.removeLibrary(library);
        modifiableModel.commit();
    }

    private void commit(LibraryModel model) {
        this.myFirstLoad = false;
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        if (!model.isChanged()) {
            Disposer.dispose((Disposable)model);
            return;
        }
        this.incrementModificationCount();
        THashSet addedLibraries = ContainerUtil.newIdentityTroveSet((Collection)model.myLibraries);
        addedLibraries.removeAll(this.myModel.myLibraries);
        THashSet removedLibraries = ContainerUtil.newIdentityTroveSet((Collection)this.myModel.myLibraries);
        removedLibraries.removeAll(model.myLibraries);
        for (Library library : removedLibraries) {
            this.fireBeforeLibraryRemoved(library);
        }
        this.myModel.copyFrom(model);
        for (Library library : removedLibraries) {
            Disposer.dispose((Disposable)library);
            this.fireAfterLibraryRemoved(library);
        }
        for (Library library : addedLibraries) {
            this.fireLibraryAdded(library);
        }
        Disposer.dispose((Disposable)model);
    }

    private void fireAfterLibraryRemoved(Library library) {
        ((LibraryTable.Listener)this.myDispatcher.getMulticaster()).afterLibraryRemoved(library);
    }

    public void readExternal(Element element) throws InvalidDataException {
        this.myModel = new LibraryModel();
        this.myModel.readExternal(element);
    }

    public void writeExternal(Element element) throws WriteExternalException {
        this.myModel.writeExternal(element);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 13: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 13: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/impl/libraries/LibraryTableBase";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 4: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 8: 
            case 9: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "library";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getModifiableModel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibraries";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibraryIterator";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/impl/libraries/LibraryTableBase";
                break;
            }
            case 10: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createLibrary";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getLibraryByName";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "removeListener";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "fireLibraryAdded";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "fireBeforeLibraryRemoved";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "fireLibraryRenamed";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "removeLibrary";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 13: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    class LibraryModel
    implements LibraryTable.ModifiableModel,
    JDOMExternalizable,
    LibraryTable.Listener,
    Disposable {
        private final List<Library> myLibraries = new ArrayList<Library>();
        private volatile Map<String, Library> myLibraryByNameCache;
        private boolean myWritable;

        private LibraryModel() {
            LibraryTableBase.this.myDispatcher.addListener((EventListener)((Object)this));
            this.myWritable = false;
        }

        private LibraryModel(LibraryModel that) {
            LibraryTableBase.this.myDispatcher.addListener((EventListener)((Object)this));
            this.myWritable = true;
            this.myLibraries.addAll(that.myLibraries);
        }

        public void commit() {
            LibraryTableBase.this.commit(this);
            this.myWritable = false;
        }

        public void dispose() {
            LibraryTableBase.this.myDispatcher.removeListener((EventListener)((Object)this));
        }

        @NotNull
        public Iterator<Library> getLibraryIterator() {
            Iterator<Library> iterator = Collections.unmodifiableList(this.myLibraries).iterator();
            if (iterator == null) {
                LibraryModel.$$$reportNull$$$0(0);
            }
            return iterator;
        }

        @Nullable
        public Library getLibraryByName(@NotNull String name2) {
            Library library;
            Map<String, Library> cache;
            if (name2 == null) {
                LibraryModel.$$$reportNull$$$0(1);
            }
            if ((cache = this.myLibraryByNameCache) == null) {
                cache = new HashMap<String, Library>();
                for (Library library2 : this.myLibraries) {
                    cache.put(library2.getName(), library2);
                }
                this.myLibraryByNameCache = cache;
            }
            if ((library = cache.get(name2)) != null) {
                return library;
            }
            String libraryPrefix = "library.";
            String libPath = System.getProperty("library." + name2);
            if (libPath != null) {
                LibraryImpl libraryFromProperty = new LibraryImpl(name2, null, LibraryTableBase.this, null, null);
                libraryFromProperty.addRoot(libPath, OrderRootType.CLASSES);
                return libraryFromProperty;
            }
            return null;
        }

        @NotNull
        public Library[] getLibraries() {
            Library[] libraryArray = this.myLibraries.toArray(new Library[this.myLibraries.size()]);
            if (libraryArray == null) {
                LibraryModel.$$$reportNull$$$0(2);
            }
            return libraryArray;
        }

        private void assertWritable() {
            LOG.assertTrue(this.myWritable);
        }

        @NotNull
        public Library createLibrary(String name2) {
            Library library = this.createLibrary(name2, null);
            if (library == null) {
                LibraryModel.$$$reportNull$$$0(3);
            }
            return library;
        }

        @NotNull
        public Library createLibrary(String name2, @Nullable PersistentLibraryKind kind2) {
            Library library = this.createLibrary(name2, kind2, null);
            if (library == null) {
                LibraryModel.$$$reportNull$$$0(4);
            }
            return library;
        }

        @NotNull
        public Library createLibrary(String name2, @Nullable PersistentLibraryKind kind2, @Nullable ProjectModelExternalSource externalSource) {
            this.assertWritable();
            LibraryImpl library = new LibraryImpl(name2, kind2, LibraryTableBase.this, null, externalSource);
            this.myLibraries.add((Library)library);
            this.myLibraryByNameCache = null;
            LibraryImpl libraryImpl = library;
            if (libraryImpl == null) {
                LibraryModel.$$$reportNull$$$0(5);
            }
            return libraryImpl;
        }

        public void removeLibrary(@NotNull Library library) {
            if (library == null) {
                LibraryModel.$$$reportNull$$$0(6);
            }
            LibraryTableBase.this.incrementModificationCount();
            this.assertWritable();
            this.myLibraries.remove(library);
            this.myLibraryByNameCache = null;
        }

        public boolean isChanged() {
            if (!this.myWritable) {
                return false;
            }
            HashSet thisLibraries = new HashSet(this.myLibraries);
            HashSet thatLibraries = new HashSet(((LibraryTableBase)LibraryTableBase.this).myModel.myLibraries);
            return !thisLibraries.equals(thatLibraries);
        }

        public void readExternal(Element element) {
            this.myLibraries.clear();
            List libraryElements = element.getChildren("library");
            for (Element libraryElement : libraryElements) {
                LibraryImpl library = new LibraryImpl(LibraryTableBase.this, libraryElement, null);
                if (library.getName() != null) {
                    this.myLibraries.add((Library)library);
                    LibraryTableBase.this.fireLibraryAdded((Library)library);
                    continue;
                }
                Disposer.dispose((Disposable)library);
            }
            this.myLibraryByNameCache = null;
        }

        public void afterLibraryRenamed(@NotNull Library library) {
            if (library == null) {
                LibraryModel.$$$reportNull$$$0(7);
            }
            this.myLibraryByNameCache = null;
        }

        public void writeExternal(Element element) {
            List libraries = ContainerUtil.findAll(this.myLibraries, library -> !((LibraryEx)library).isDisposed());
            ContainerUtil.sort((List)libraries, (o1, o2) -> StringUtil.compare((String)o1.getName(), (String)o2.getName(), (boolean)true));
            for (Library library2 : libraries) {
                if (library2.getName() == null) continue;
                library2.writeExternal(element);
            }
        }

        void copyFrom(LibraryModel model) {
            this.myLibraries.clear();
            this.myLibraries.addAll(model.myLibraries);
            this.myLibraryByNameCache = null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 6: 
                case 7: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 6: 
                case 7: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/roots/impl/libraries/LibraryTableBase$LibraryModel";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "library";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLibraryIterator";
                    break;
                }
                case 1: 
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/roots/impl/libraries/LibraryTableBase$LibraryModel";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLibraries";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createLibrary";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getLibraryByName";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "removeLibrary";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "afterLibraryRenamed";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 6: 
                case 7: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

