/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.libraries.ui;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.ui.RootFilter;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;

public class DescendentBasedRootFilter
extends RootFilter {
    private final Predicate<VirtualFile> myCondition;

    public DescendentBasedRootFilter(OrderRootType rootType, boolean jarDirectory, String presentableRootTypeName, Predicate<VirtualFile> condition2) {
        super(rootType, jarDirectory, presentableRootTypeName);
        this.myCondition = condition2;
    }

    public static DescendentBasedRootFilter createFileTypeBasedFilter(OrderRootType rootType, boolean jarDirectory, @NotNull FileType fileType, String presentableRootTypeName) {
        if (fileType == null) {
            DescendentBasedRootFilter.$$$reportNull$$$0(0);
        }
        return new DescendentBasedRootFilter(rootType, jarDirectory, presentableRootTypeName, file2 -> {
            if (fileType == null) {
                DescendentBasedRootFilter.$$$reportNull$$$0(3);
            }
            return fileType.equals(file2.getFileType());
        });
    }

    @Override
    public boolean isAccepted(@NotNull VirtualFile rootCandidate, @NotNull ProgressIndicator progressIndicator) {
        if (rootCandidate == null) {
            DescendentBasedRootFilter.$$$reportNull$$$0(1);
        }
        if (progressIndicator == null) {
            DescendentBasedRootFilter.$$$reportNull$$$0(2);
        }
        if (this.isJarDirectory()) {
            if (!rootCandidate.isDirectory() || !rootCandidate.isInLocalFileSystem()) {
                return false;
            }
            for (VirtualFile child : rootCandidate.getChildren()) {
                VirtualFile jarRoot;
                if (child.isDirectory() || !child.getFileType().equals(FileTypes.ARCHIVE) || (jarRoot = JarFileSystem.getInstance().getJarRootForLocalFile(child)) == null || !this.containsFileOfType(jarRoot, progressIndicator)) continue;
                return true;
            }
            return false;
        }
        return this.containsFileOfType(rootCandidate, progressIndicator);
    }

    private boolean containsFileOfType(VirtualFile rootCandidate, ProgressIndicator progressIndicator) {
        return !VfsUtilCore.processFilesRecursively((VirtualFile)rootCandidate, virtualFile -> {
            progressIndicator.checkCanceled();
            if (virtualFile.isDirectory()) {
                progressIndicator.setText2(virtualFile.getPath());
                return true;
            }
            return !this.myCondition.test((VirtualFile)virtualFile);
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootCandidate";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressIndicator";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/roots/libraries/ui/DescendentBasedRootFilter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createFileTypeBasedFilter";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isAccepted";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$createFileTypeBasedFilter$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

