/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.libraries.ui.impl;

import com.intellij.ide.util.ChooseElementsDialog;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.LibraryRootType;
import com.intellij.openapi.roots.libraries.ui.DetectedLibraryRoot;
import com.intellij.openapi.roots.libraries.ui.LibraryRootsComponentDescriptor;
import com.intellij.openapi.roots.libraries.ui.LibraryRootsDetector;
import com.intellij.openapi.roots.libraries.ui.OrderRoot;
import com.intellij.openapi.roots.libraries.ui.impl.DetectedRootsChooserDialog;
import com.intellij.openapi.roots.libraries.ui.impl.SuggestedChildRootInfo;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RootDetectionUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.roots.ui.configuration.libraryEditor.RootDetectionUtil");

    private RootDetectionUtil() {
    }

    @NotNull
    public static List<OrderRoot> detectRoots(@NotNull Collection<VirtualFile> rootCandidates, @Nullable Component parentComponent, @Nullable Project project2, @NotNull LibraryRootsComponentDescriptor rootsComponentDescriptor) {
        if (rootCandidates == null) {
            RootDetectionUtil.$$$reportNull$$$0(0);
        }
        if (rootsComponentDescriptor == null) {
            RootDetectionUtil.$$$reportNull$$$0(1);
        }
        List<OrderRoot> list2 = RootDetectionUtil.detectRoots(rootCandidates, parentComponent, project2, rootsComponentDescriptor.getRootsDetector(), rootsComponentDescriptor.getRootTypes());
        if (list2 == null) {
            RootDetectionUtil.$$$reportNull$$$0(2);
        }
        return list2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static List<OrderRoot> detectRoots(final @NotNull Collection<VirtualFile> rootCandidates, @Nullable Component parentComponent, @Nullable Project project2, final @NotNull LibraryRootsDetector detector, @NotNull OrderRootType[] rootTypesAllowedToBeSelectedByUserIfNothingIsDetected) {
        if (rootCandidates == null) {
            RootDetectionUtil.$$$reportNull$$$0(3);
        }
        if (detector == null) {
            RootDetectionUtil.$$$reportNull$$$0(4);
        }
        if (rootTypesAllowedToBeSelectedByUserIfNothingIsDetected == null) {
            RootDetectionUtil.$$$reportNull$$$0(5);
        }
        final ArrayList<OrderRoot> result2 = new ArrayList<OrderRoot>();
        final ArrayList<SuggestedChildRootInfo> suggestedRoots = new ArrayList<SuggestedChildRootInfo>();
        new Task.Modal(project2, "Scanning for Roots", true){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                try {
                    for (VirtualFile rootCandidate : rootCandidates) {
                        Collection<DetectedLibraryRoot> roots = detector.detectRoots(rootCandidate, indicator);
                        if (!roots.isEmpty() && RootDetectionUtil.allRootsHaveOneTypeAndEqualToOrAreDirectParentOf(roots, rootCandidate)) {
                            for (DetectedLibraryRoot root : roots) {
                                LibraryRootType libraryRootType = root.getTypes().get(0);
                                result2.add(new OrderRoot(root.getFile(), libraryRootType.getType(), libraryRootType.isJarDirectory()));
                            }
                            continue;
                        }
                        for (DetectedLibraryRoot root : roots) {
                            HashMap<LibraryRootType, String> names = new HashMap<LibraryRootType, String>();
                            for (LibraryRootType type2 : root.getTypes()) {
                                String typeName = detector.getRootTypeName(type2);
                                LOG.assertTrue(typeName != null, (Object)("Unexpected root type " + type2.getType().name() + (type2.isJarDirectory() ? " (JAR directory)" : "") + ", detectors: " + detector));
                                names.put(type2, typeName);
                            }
                            suggestedRoots.add(new SuggestedChildRootInfo(rootCandidate, root, names));
                        }
                    }
                }
                catch (ProcessCanceledException processCanceledException) {
                    // empty catch block
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/roots/libraries/ui/impl/RootDetectionUtil$1", "run"));
            }
        }.queue();
        if (!suggestedRoots.isEmpty()) {
            DetectedRootsChooserDialog dialog2;
            DetectedRootsChooserDialog detectedRootsChooserDialog = dialog2 = parentComponent != null ? new DetectedRootsChooserDialog(parentComponent, suggestedRoots) : new DetectedRootsChooserDialog(project2, suggestedRoots);
            if (!dialog2.showAndGet()) {
                List<OrderRoot> list2 = Collections.emptyList();
                if (list2 == null) {
                    RootDetectionUtil.$$$reportNull$$$0(6);
                }
                return list2;
            }
            for (SuggestedChildRootInfo suggestedChildRootInfo : dialog2.getChosenRoots()) {
                LibraryRootType selectedRootType = suggestedChildRootInfo.getSelectedRootType();
                result2.add(new OrderRoot(suggestedChildRootInfo.getDetectedRoot().getFile(), selectedRootType.getType(), selectedRootType.isJarDirectory()));
            }
        }
        if (result2.isEmpty() && rootTypesAllowedToBeSelectedByUserIfNothingIsDetected.length > 0) {
            HashMap<String, Pair> types = new HashMap<String, Pair>();
            for (OrderRootType orderRootType : rootTypesAllowedToBeSelectedByUserIfNothingIsDetected) {
                for (Object isJarDirectory : (LibraryRootType)new boolean[]{false, true}) {
                    String typeName = detector.getRootTypeName(new LibraryRootType(orderRootType, (boolean)isJarDirectory));
                    if (typeName == null) continue;
                    types.put(StringUtil.capitalizeWords((String)typeName, (boolean)true), Pair.create((Object)orderRootType, (Object)((boolean)isJarDirectory)));
                }
            }
            LOG.assertTrue(!types.isEmpty(), (Object)("No allowed root types found for " + detector));
            ArrayList<String> arrayList = new ArrayList<String>(types.keySet());
            if (arrayList.size() == 1) {
                int answer;
                String title = "Attach Roots";
                String typeName = (String)arrayList.get(0);
                String string = ApplicationNamesInfo.getInstance().getProductName() + " cannot determine what kind of files the chosen items contain. Do you want to attach them as '" + typeName + "'?";
                int n = answer = parentComponent != null ? Messages.showYesNoDialog((Component)parentComponent, (String)string, (String)title, null) : Messages.showYesNoDialog((Project)project2, (String)string, (String)title, null);
                if (answer == 0) {
                    Pair pair2 = (Pair)types.get(typeName);
                    for (VirtualFile candidate : rootCandidates) {
                        result2.add(new OrderRoot(candidate, (OrderRootType)pair2.getFirst(), (Boolean)pair2.getSecond()));
                    }
                }
            } else {
                void var11_23;
                String title = "Choose Categories of Selected Files";
                String description = XmlStringUtil.wrapInHtml((CharSequence)(ApplicationNamesInfo.getInstance().getProductName() + " cannot determine what kind of files the chosen items contain.<br>Choose the appropriate categories from the list."));
                if (parentComponent != null) {
                    ChooseRootTypeElementsDialog chooseRootTypeElementsDialog = new ChooseRootTypeElementsDialog(parentComponent, arrayList, title, description);
                } else {
                    ChooseRootTypeElementsDialog chooseRootTypeElementsDialog = new ChooseRootTypeElementsDialog(project2, (List<String>)arrayList, title, description);
                }
                for (String rootType : var11_23.showAndGetResult()) {
                    Pair pair3 = (Pair)types.get(rootType);
                    for (VirtualFile candidate : rootCandidates) {
                        result2.add(new OrderRoot(candidate, (OrderRootType)pair3.getFirst(), (Boolean)pair3.getSecond()));
                    }
                }
            }
        }
        ArrayList<OrderRoot> arrayList = result2;
        if (arrayList == null) {
            RootDetectionUtil.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    private static boolean allRootsHaveOneTypeAndEqualToOrAreDirectParentOf(Collection<DetectedLibraryRoot> roots, VirtualFile candidate) {
        for (DetectedLibraryRoot root : roots) {
            if (root.getTypes().size() <= 1 && (root.getFile().equals(candidate) || root.getFile().equals(candidate.getParent()))) continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootCandidates";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootsComponentDescriptor";
                break;
            }
            case 2: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/libraries/ui/impl/RootDetectionUtil";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "detector";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootTypesAllowedToBeSelectedByUserIfNothingIsDetected";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/libraries/ui/impl/RootDetectionUtil";
                break;
            }
            case 2: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "detectRoots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "detectRoots";
                break;
            }
            case 2: 
            case 6: 
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ChooseRootTypeElementsDialog
    extends ChooseElementsDialog<String> {
        public ChooseRootTypeElementsDialog(Project project2, List<String> names, String title, String description) {
            super(project2, names, title, description, true);
        }

        private ChooseRootTypeElementsDialog(Component parent, List<String> names, String title, String description) {
            super(parent, names, title, description, true);
        }

        @Override
        protected String getItemText(String item) {
            return item;
        }

        @Override
        @Nullable
        protected Icon getItemIcon(String item) {
            return null;
        }
    }
}

