/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.classpath;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.ExportableOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.impl.ClonableOrderEntry;
import com.intellij.openapi.roots.impl.OrderEntryUtil;
import com.intellij.openapi.roots.impl.ProjectRootManagerImpl;
import com.intellij.openapi.roots.impl.RootModelImpl;
import com.intellij.openapi.roots.ui.configuration.ModuleEditor;
import com.intellij.openapi.roots.ui.configuration.ProjectStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.classpath.ClasspathPanelImpl;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureConfigurableContext;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ModuleProjectStructureElement;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import java.lang.reflect.Proxy;

public class InlineModuleDependencyAction
extends AnAction {
    private static final Logger LOG = Logger.getInstance(InlineModuleDependencyAction.class);
    private final ClasspathPanelImpl myClasspathPanel;

    public InlineModuleDependencyAction(ClasspathPanelImpl classpathPanel) {
        super("Inline Module Dependency", "Replace dependency on a module without source roots by the list of its dependencies", null);
        this.myClasspathPanel = classpathPanel;
    }

    public void actionPerformed(AnActionEvent e) {
        OrderEntry selectedEntry = this.myClasspathPanel.getSelectedEntry();
        if (!(selectedEntry instanceof ModuleOrderEntry)) {
            return;
        }
        ModuleOrderEntry entryToInline = (ModuleOrderEntry)selectedEntry;
        Module module2 = entryToInline.getModule();
        if (module2 == null) {
            return;
        }
        ModifiableRootModel model = this.myClasspathPanel.getRootModel();
        int toInlineIndex = InlineModuleDependencyAction.findModuleEntryIndex(model, module2);
        if (toInlineIndex == -1) {
            return;
        }
        model.removeOrderEntry((OrderEntry)entryToInline);
        RootModelImpl modelImpl = Proxy.isProxyClass(model.getClass()) ? (RootModelImpl)((ModuleEditor.ProxyDelegateAccessor)((Object)Proxy.getInvocationHandler(model))).getDelegate() : (RootModelImpl)model;
        int addedCount = 0;
        ModuleRootModel otherModel = this.myClasspathPanel.getModuleConfigurationState().getModulesProvider().getRootModel(module2);
        ProjectRootManagerImpl rootManager = ProjectRootManagerImpl.getInstanceImpl(this.myClasspathPanel.getProject());
        VirtualFilePointerManager virtualFilePointerManager = VirtualFilePointerManager.getInstance();
        for (OrderEntry entry : otherModel.getOrderEntries()) {
            if (!(entry instanceof LibraryOrderEntry) && !(entry instanceof ModuleOrderEntry)) continue;
            LOG.assertTrue(entry instanceof ClonableOrderEntry, (Object)entry);
            ExportableOrderEntry entryToCopy = (ExportableOrderEntry)entry;
            ExportableOrderEntry cloned = (ExportableOrderEntry)((ClonableOrderEntry)entry).cloneEntry(modelImpl, rootManager, virtualFilePointerManager);
            cloned.setExported(entryToInline.isExported() && entryToCopy.isExported());
            cloned.setScope(OrderEntryUtil.intersectScopes(entryToInline.getScope(), entryToCopy.getScope()));
            model.addOrderEntry((OrderEntry)cloned);
            ++addedCount;
        }
        OrderEntry[] oldEntries = model.getOrderEntries();
        OrderEntry[] newEntries = new OrderEntry[oldEntries.length];
        System.arraycopy(oldEntries, 0, newEntries, 0, toInlineIndex);
        System.arraycopy(oldEntries, oldEntries.length - addedCount, newEntries, toInlineIndex, addedCount);
        System.arraycopy(oldEntries, toInlineIndex, newEntries, toInlineIndex + addedCount, oldEntries.length - toInlineIndex - addedCount);
        model.rearrangeOrderEntries(newEntries);
        StructureConfigurableContext context = ProjectStructureConfigurable.getInstance(this.myClasspathPanel.getProject()).getContext();
        context.getDaemonAnalyzer().queueUpdate(new ModuleProjectStructureElement(context, module2));
    }

    private static int findModuleEntryIndex(ModifiableRootModel model, Module module2) {
        OrderEntry[] entries = model.getOrderEntries();
        for (int i = 0; i < entries.length; ++i) {
            OrderEntry entry = entries[i];
            if (!(entry instanceof ModuleOrderEntry) || !module2.equals(((ModuleOrderEntry)entry).getModule())) continue;
            return i;
        }
        return -1;
    }

    public void update(AnActionEvent e) {
        e.getPresentation().setEnabledAndVisible(this.isEnabled());
    }

    private boolean isEnabled() {
        OrderEntry entry = this.myClasspathPanel.getSelectedEntry();
        if (!(entry instanceof ModuleOrderEntry)) {
            return false;
        }
        Module module2 = ((ModuleOrderEntry)entry).getModule();
        if (module2 == null) {
            return false;
        }
        ModuleRootModel model = this.myClasspathPanel.getModuleConfigurationState().getModulesProvider().getRootModel(module2);
        return model.getSourceRootUrls().length == 0;
    }
}

