/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.dependencyAnalysis;

import com.intellij.icons.AllIcons;
import com.intellij.ide.presentation.VirtualFilePresentation;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleSourceOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.OrderRootsEnumerator;
import com.intellij.openapi.roots.ui.CellAppearanceEx;
import com.intellij.openapi.roots.ui.OrderEntryAppearanceService;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModuleDependenciesAnalyzer {
    private final Module myModule;
    private final boolean myProduction;
    private final boolean myCompile;
    private final boolean mySdk;
    private final List<OrderEntryExplanation> myOrderEntries = new ArrayList<OrderEntryExplanation>();
    private final List<UrlExplanation> myUrls = new ArrayList<UrlExplanation>();

    public ModuleDependenciesAnalyzer(Module module2, boolean production, boolean compile, boolean sdk) {
        this.myModule = module2;
        this.myProduction = production;
        this.myCompile = compile;
        this.mySdk = sdk;
        this.analyze();
    }

    public List<UrlExplanation> getUrls() {
        return Collections.unmodifiableList(this.myUrls);
    }

    public List<OrderEntryExplanation> getOrderEntries() {
        return Collections.unmodifiableList(this.myOrderEntries);
    }

    private void analyze() {
        OrderEnumerator e = ModuleRootManager.getInstance((Module)this.myModule).orderEntries();
        e.recursively();
        if (!this.mySdk) {
            e.withoutSdk();
        }
        if (this.myCompile) {
            e.compileOnly();
        } else {
            e.runtimeOnly();
        }
        if (this.myProduction) {
            e.productionOnly();
        }
        LinkedHashMap<String, List<OrderPath>> urlExplanations = new LinkedHashMap<String, List<OrderPath>>();
        OrderRootsEnumerator classes2 = e.classes();
        if (this.myCompile) {
            classes2.withoutSelfModuleOutput();
        }
        for (String url : classes2.getUrls()) {
            if (urlExplanations.containsKey(url)) continue;
            urlExplanations.put(url, new ArrayList());
        }
        LinkedHashMap<OrderEntry, List<OrderPath>> orderExplanations = new LinkedHashMap<OrderEntry, List<OrderPath>>();
        new PathWalker(urlExplanations, orderExplanations).examine(this.myModule, 0);
        for (Map.Entry entry : orderExplanations.entrySet()) {
            this.myOrderEntries.add(new OrderEntryExplanation((OrderEntry)entry.getKey(), (List)entry.getValue()));
        }
        for (Map.Entry entry : urlExplanations.entrySet()) {
            this.myUrls.add(new UrlExplanation((String)entry.getKey(), (List)entry.getValue()));
        }
    }

    public static class UrlExplanation
    extends Explanation {
        private final String myUrl;

        UrlExplanation(String url, List<OrderPath> paths) {
            super(paths);
            this.myUrl = url;
        }

        public String url() {
            return this.myUrl;
        }

        @Nullable
        public Icon getIcon() {
            VirtualFile file2 = this.getLocalFile();
            return file2 == null ? AllIcons.General.Error : VirtualFilePresentation.getIcon((VirtualFile)file2);
        }

        @Nullable
        public VirtualFile getLocalFile() {
            VirtualFile file2 = VirtualFileManager.getInstance().findFileByUrl(this.myUrl);
            if (file2 != null) {
                file2 = VfsUtil.getLocalFile((VirtualFile)file2);
            }
            return file2;
        }
    }

    public static class OrderEntryExplanation
    extends Explanation {
        private final OrderEntry myEntry;

        OrderEntryExplanation(OrderEntry entry, List<OrderPath> paths) {
            super(paths);
            this.myEntry = entry;
        }

        public OrderEntry entry() {
            return this.myEntry;
        }
    }

    public static class Explanation {
        public final List<OrderPath> myPaths;

        Explanation(List<OrderPath> paths) {
            this.myPaths = Collections.unmodifiableList(paths);
        }

        public List<OrderPath> paths() {
            return this.myPaths;
        }
    }

    public static class OrderEntryPathElement
    extends OrderPathElement {
        private final OrderEntry myEntry;

        public OrderEntryPathElement(OrderEntry entry) {
            this.myEntry = entry;
        }

        public OrderEntry entry() {
            return this.myEntry;
        }

        public int hashCode() {
            return this.myEntry.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof OrderEntryPathElement)) {
                return false;
            }
            OrderEntryPathElement o = (OrderEntryPathElement)obj;
            return o.myEntry == this.myEntry;
        }

        public String toString() {
            return this.myEntry.getPresentableName();
        }

        @Override
        @NotNull
        public CellAppearanceEx getAppearance(boolean isSelected) {
            CellAppearanceEx cellAppearanceEx = OrderEntryAppearanceService.getInstance().forOrderEntry(this.myEntry.getOwnerModule().getProject(), this.myEntry, isSelected);
            if (cellAppearanceEx == null) {
                OrderEntryPathElement.$$$reportNull$$$0(0);
            }
            return cellAppearanceEx;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/configuration/dependencyAnalysis/ModuleDependenciesAnalyzer$OrderEntryPathElement", "getAppearance"));
        }
    }

    public static abstract class OrderPathElement {
        @NotNull
        public abstract CellAppearanceEx getAppearance(boolean var1);
    }

    public static class OrderPath {
        private final List<OrderPathElement> myEntries;

        public OrderPath(List<OrderPathElement> entries) {
            this.myEntries = Collections.unmodifiableList(new ArrayList<OrderPathElement>(entries));
        }

        public List<OrderPathElement> entries() {
            return this.myEntries;
        }

        public int hashCode() {
            return this.myEntries.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof OrderPath)) {
                return false;
            }
            return this.myEntries.equals(((OrderPath)obj).myEntries);
        }
    }

    private class PathWalker {
        private final Map<String, List<OrderPath>> myUrlExplanations;
        private final Map<OrderEntry, List<OrderPath>> myOrderExplanations;
        private final ArrayList<OrderPathElement> myStack = new ArrayList();
        private final HashSet<Module> myVisited = new HashSet();

        public PathWalker(Map<String, List<OrderPath>> urlExplanations, Map<OrderEntry, List<OrderPath>> orderExplanations) {
            this.myUrlExplanations = urlExplanations;
            this.myOrderExplanations = orderExplanations;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void examine(Module m, int level) {
            if (this.myVisited.contains(m)) {
                return;
            }
            this.myVisited.add(m);
            try {
                OrderEnumerator e = ModuleRootManager.getInstance((Module)m).orderEntries();
                if (!ModuleDependenciesAnalyzer.this.mySdk || level != 0) {
                    e.withoutSdk();
                }
                if (ModuleDependenciesAnalyzer.this.myCompile && level != 0) {
                    e.exportedOnly();
                }
                if (ModuleDependenciesAnalyzer.this.myProduction) {
                    e.productionOnly();
                }
                if (ModuleDependenciesAnalyzer.this.myCompile) {
                    e.compileOnly();
                } else {
                    e.runtimeOnly();
                }
                e.forEach(orderEntry -> {
                    this.myStack.add(new OrderEntryPathElement((OrderEntry)orderEntry));
                    try {
                        if (orderEntry instanceof ModuleOrderEntry) {
                            ModuleOrderEntry o = (ModuleOrderEntry)orderEntry;
                            this.examine(o.getModule(), level + 1);
                        } else if (orderEntry instanceof ModuleSourceOrderEntry) {
                            if (!ModuleDependenciesAnalyzer.this.myProduction || !ModuleDependenciesAnalyzer.this.myCompile) {
                                CompilerModuleExtension e1 = CompilerModuleExtension.getInstance((Module)m);
                                OrderPath p = new OrderPath(this.myStack);
                                for (String u : e1.getOutputRootUrls(!ModuleDependenciesAnalyzer.this.myCompile ? !ModuleDependenciesAnalyzer.this.myProduction : level > 0 && !ModuleDependenciesAnalyzer.this.myProduction)) {
                                    this.addUrlPath(p, u);
                                }
                                this.addEntryPath((OrderEntry)orderEntry, p);
                            }
                        } else {
                            OrderPath p = new OrderPath(this.myStack);
                            for (String u : orderEntry.getUrls(OrderRootType.CLASSES)) {
                                this.addUrlPath(p, u);
                            }
                            this.addEntryPath((OrderEntry)orderEntry, p);
                        }
                    }
                    finally {
                        this.myStack.remove(this.myStack.size() - 1);
                    }
                    return true;
                });
            }
            finally {
                this.myVisited.remove(m);
            }
        }

        private void addUrlPath(OrderPath p, String u) {
            List<OrderPath> orderPaths = this.myUrlExplanations.get(u);
            if (orderPaths != null) {
                orderPaths.add(p);
            }
        }

        private void addEntryPath(OrderEntry orderEntry, OrderPath p) {
            List<OrderPath> paths = this.myOrderExplanations.get(orderEntry);
            if (paths == null) {
                paths = new ArrayList<OrderPath>();
                this.myOrderExplanations.put(orderEntry, paths);
            }
            paths.add(p);
        }
    }
}

