/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.libraryEditor;

import com.intellij.ide.IdeBundle;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryType;
import com.intellij.openapi.roots.libraries.LibraryTypeService;
import com.intellij.openapi.roots.libraries.NewLibraryConfiguration;
import com.intellij.openapi.roots.ui.configuration.ProjectStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.libraries.LibraryEditingUtil;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.DefaultLibraryRootsComponentDescriptor;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.NewLibraryEditor;
import com.intellij.openapi.roots.ui.configuration.projectRoot.BaseLibrariesConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesModifiableModel;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ModuleStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ProjectLibrariesConfigurable;
import com.intellij.openapi.ui.MasterDetailsComponent;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PlatformIcons;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateNewLibraryAction
extends DumbAwareAction {
    @Nullable
    private final LibraryType myType;
    private final BaseLibrariesConfigurable myLibrariesConfigurable;
    private final Project myProject;

    private CreateNewLibraryAction(@NotNull String text2, @Nullable Icon icon, @Nullable LibraryType type2, @NotNull BaseLibrariesConfigurable librariesConfigurable, @NotNull Project project2) {
        if (text2 == null) {
            CreateNewLibraryAction.$$$reportNull$$$0(0);
        }
        if (librariesConfigurable == null) {
            CreateNewLibraryAction.$$$reportNull$$$0(1);
        }
        if (project2 == null) {
            CreateNewLibraryAction.$$$reportNull$$$0(2);
        }
        super(text2, null, icon);
        this.myType = type2;
        this.myLibrariesConfigurable = librariesConfigurable;
        this.myProject = project2;
    }

    @Nullable
    public static Library createLibrary(@Nullable LibraryType type2, @NotNull JComponent parentComponent, @NotNull Project project2, @NotNull LibrariesModifiableModel modifiableModel) {
        NewLibraryConfiguration configuration;
        if (parentComponent == null) {
            CreateNewLibraryAction.$$$reportNull$$$0(3);
        }
        if (project2 == null) {
            CreateNewLibraryAction.$$$reportNull$$$0(4);
        }
        if (modifiableModel == null) {
            CreateNewLibraryAction.$$$reportNull$$$0(5);
        }
        if ((configuration = CreateNewLibraryAction.createNewLibraryConfiguration(type2, parentComponent, project2)) == null) {
            return null;
        }
        LibraryType<?> libraryType = configuration.getLibraryType();
        Library library = modifiableModel.createLibrary(LibraryEditingUtil.suggestNewLibraryName(modifiableModel, configuration.getDefaultLibraryName()), libraryType != null ? libraryType.getKind() : null);
        NewLibraryEditor editor = new NewLibraryEditor(libraryType, configuration.getProperties());
        configuration.addRoots(editor);
        Library.ModifiableModel model = library.getModifiableModel();
        editor.applyTo((LibraryEx.ModifiableModelEx)model);
        WriteAction.run(() -> model.commit());
        return library;
    }

    @Nullable
    public static NewLibraryConfiguration createNewLibraryConfiguration(@Nullable LibraryType type2, @NotNull JComponent parentComponent, @NotNull Project project2) {
        if (parentComponent == null) {
            CreateNewLibraryAction.$$$reportNull$$$0(6);
        }
        if (project2 == null) {
            CreateNewLibraryAction.$$$reportNull$$$0(7);
        }
        VirtualFile baseDir = project2.getBaseDir();
        NewLibraryConfiguration configuration = type2 != null ? type2.createNewLibrary(parentComponent, baseDir, project2) : LibraryTypeService.getInstance().createLibraryFromFiles(new DefaultLibraryRootsComponentDescriptor(), parentComponent, baseDir, null, project2);
        if (configuration == null) {
            return null;
        }
        return configuration;
    }

    public static AnAction[] createActionOrGroup(@NotNull String text2, @NotNull BaseLibrariesConfigurable librariesConfigurable, @NotNull Project project2) {
        if (text2 == null) {
            CreateNewLibraryAction.$$$reportNull$$$0(8);
        }
        if (librariesConfigurable == null) {
            CreateNewLibraryAction.$$$reportNull$$$0(9);
        }
        if (project2 == null) {
            CreateNewLibraryAction.$$$reportNull$$$0(10);
        }
        LibraryType[] extensions = (LibraryType[])LibraryType.EP_NAME.getExtensions();
        ArrayList<LibraryType> suitableTypes = new ArrayList<LibraryType>();
        if (librariesConfigurable instanceof ProjectLibrariesConfigurable || !project2.isDefault()) {
            ModuleStructureConfigurable configurable = ModuleStructureConfigurable.getInstance(project2);
            for (LibraryType extension : extensions) {
                if (LibraryEditingUtil.getSuitableModules(configurable, extension.getKind(), null).isEmpty()) continue;
                suitableTypes.add(extension);
            }
        } else {
            Collections.addAll(suitableTypes, extensions);
        }
        if (suitableTypes.isEmpty()) {
            return new AnAction[]{new CreateNewLibraryAction(text2, PlatformIcons.LIBRARY_ICON, null, librariesConfigurable, project2)};
        }
        ArrayList<CreateNewLibraryAction> actions = new ArrayList<CreateNewLibraryAction>();
        actions.add(new CreateNewLibraryAction(IdeBundle.message((String)"create.default.library.type.action.name", (Object[])new Object[0]), PlatformIcons.LIBRARY_ICON, null, librariesConfigurable, project2));
        for (LibraryType type2 : suitableTypes) {
            String actionName = type2.getCreateActionName();
            if (actionName == null) continue;
            actions.add(new CreateNewLibraryAction(actionName, type2.getIcon(null), type2, librariesConfigurable, project2));
        }
        return actions.toArray(new AnAction[actions.size()]);
    }

    public void actionPerformed(AnActionEvent e) {
        Library library = CreateNewLibraryAction.createLibrary(this.myType, (JComponent)this.myLibrariesConfigurable.getTree(), this.myProject, this.myLibrariesConfigurable.getModelProvider().getModifiableModel());
        if (library == null) {
            return;
        }
        BaseLibrariesConfigurable rootConfigurable = ProjectStructureConfigurable.getInstance(this.myProject).getConfigurableFor(library);
        MasterDetailsComponent.MyNode libraryNode = MasterDetailsComponent.findNodeByObject((TreeNode)((TreeNode)rootConfigurable.getTree().getModel().getRoot()), (Object)library);
        rootConfigurable.selectNodeInTree((DefaultMutableTreeNode)libraryNode);
        LibraryEditingUtil.showDialogAndAddLibraryToDependencies(library, this.myProject, true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "librariesConfigurable";
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentComponent";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifiableModel";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/libraryEditor/CreateNewLibraryAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "createLibrary";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "createNewLibraryConfiguration";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "createActionOrGroup";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

