/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.libraryEditor;

import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.ui.LibraryRootsComponentDescriptor;
import com.intellij.openapi.roots.libraries.ui.OrderRootTypePresentation;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.DefaultLibraryRootsComponentDescriptor;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.ExcludedRootElement;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.ItemElement;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryEditor;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryRootsComponent;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.OrderRootTypeElement;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

class LibraryTreeStructure
extends AbstractTreeStructure {
    private final NodeDescriptor myRootElementDescriptor;
    private final LibraryRootsComponent myParentEditor;
    private final LibraryRootsComponentDescriptor myComponentDescriptor;

    LibraryTreeStructure(LibraryRootsComponent parentElement, LibraryRootsComponentDescriptor componentDescriptor) {
        this.myParentEditor = parentElement;
        this.myComponentDescriptor = componentDescriptor;
        this.myRootElementDescriptor = new NodeDescriptor(null, null){

            public boolean update() {
                this.myName = ProjectBundle.message((String)"library.root.node", (Object[])new Object[0]);
                return false;
            }

            public Object getElement() {
                return this;
            }
        };
    }

    public Object getRootElement() {
        return this.myRootElementDescriptor;
    }

    public Object[] getChildElements(Object element) {
        LibraryEditor libraryEditor = this.myParentEditor.getLibraryEditor();
        if (element == this.myRootElementDescriptor) {
            ArrayList<OrderRootTypeElement> elements = new ArrayList<OrderRootTypeElement>(3);
            for (OrderRootType type2 : this.myComponentDescriptor.getRootTypes()) {
                String[] urls = libraryEditor.getUrls(type2);
                if (urls.length <= 0) continue;
                OrderRootTypePresentation presentation = this.myComponentDescriptor.getRootTypePresentation(type2);
                if (presentation == null) {
                    presentation = DefaultLibraryRootsComponentDescriptor.getDefaultPresentation(type2);
                }
                elements.add(new OrderRootTypeElement(this.myRootElementDescriptor, type2, presentation.getNodeText(), presentation.getIcon()));
            }
            return elements.toArray();
        }
        if (element instanceof OrderRootTypeElement) {
            OrderRootTypeElement rootTypeElement = (OrderRootTypeElement)((Object)element);
            OrderRootType orderRootType = rootTypeElement.getOrderRootType();
            String[] urls = (String[])libraryEditor.getUrls(orderRootType).clone();
            Arrays.sort(urls, LibraryRootsComponent.ourUrlComparator);
            ArrayList<ItemElement> items = new ArrayList<ItemElement>(urls.length);
            for (String url : urls) {
                items.add(new ItemElement(rootTypeElement, url, orderRootType, libraryEditor.isJarDirectory(url, orderRootType), libraryEditor.isValid(url, orderRootType)));
            }
            return items.toArray();
        }
        if (element instanceof ItemElement) {
            ItemElement itemElement = (ItemElement)((Object)element);
            ArrayList<String> excludedUrls = new ArrayList<String>();
            for (String excludedUrl : libraryEditor.getExcludedRootUrls()) {
                if (!VfsUtilCore.isEqualOrAncestor((String)itemElement.getUrl(), (String)excludedUrl)) continue;
                excludedUrls.add(excludedUrl);
            }
            ExcludedRootElement[] items = new ExcludedRootElement[excludedUrls.size()];
            Collections.sort(excludedUrls, LibraryRootsComponent.ourUrlComparator);
            for (int i = 0; i < excludedUrls.size(); ++i) {
                items[i] = new ExcludedRootElement(itemElement, itemElement.getUrl(), (String)excludedUrls.get(i));
            }
            return items;
        }
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    public void commit() {
    }

    public boolean hasSomethingToCommit() {
        return false;
    }

    public Object getParentElement(Object element) {
        return ((NodeDescriptor)element).getParentDescriptor();
    }

    @NotNull
    public NodeDescriptor createDescriptor(Object element, NodeDescriptor parentDescriptor) {
        NodeDescriptor nodeDescriptor = (NodeDescriptor)element;
        if (nodeDescriptor == null) {
            LibraryTreeStructure.$$$reportNull$$$0(0);
        }
        return nodeDescriptor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/configuration/libraryEditor/LibraryTreeStructure", "createDescriptor"));
    }
}

